/*
 * Decompiled with CFR 0.152.
 */
package tests;

import ai.RandomBiasedAI;
import ai.core.AI;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.mcts.naivemcts.NaiveMCTS;
import ai.montecarlo.lsi.LSI;
import ai.montecarlo.lsi.Sampling;
import gui.PhysicalGameStateJFrame;
import gui.PhysicalGameStatePanel;
import java.io.OutputStreamWriter;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public class LMCTest {
    public static void main(String[] stringArray) throws Exception {
        String string = "maps/8x8/basesWorkers8x8.xml";
        UnitTypeTable unitTypeTable = new UnitTypeTable();
        int n = 3000;
        int n2 = 1000;
        int n3 = 100;
        RandomBiasedAI randomBiasedAI = new RandomBiasedAI();
        SimpleSqrtEvaluationFunction3 simpleSqrtEvaluationFunction3 = new SimpleSqrtEvaluationFunction3();
        LSI lSI = new LSI(n2, n3, 0.25, LSI.EstimateType.RANDOM_TAIL, LSI.EstimateReuseType.ALL, LSI.GenerateType.PER_AGENT, Sampling.AgentOrderingType.ENTROPY, LSI.EvaluateType.HALVING, false, LSI.RelaxationType.NONE, 2, false, randomBiasedAI, simpleSqrtEvaluationFunction3);
        NaiveMCTS naiveMCTS = new NaiveMCTS(-1, n2, n3, 1, 0.33f, 0.0f, 0.75f, new RandomBiasedAI(), simpleSqrtEvaluationFunction3, true);
        PhysicalGameState physicalGameState = PhysicalGameState.load(string, unitTypeTable);
        GameState gameState = new GameState(physicalGameState, unitTypeTable);
        XMLWriter xMLWriter = new XMLWriter(new OutputStreamWriter(System.out));
        physicalGameState.toxml(xMLWriter);
        xMLWriter.flush();
        PhysicalGameStateJFrame physicalGameStateJFrame = PhysicalGameStatePanel.newVisualizer(gameState, 640, 640, simpleSqrtEvaluationFunction3);
        physicalGameStateJFrame.repaint();
        boolean bl = false;
        do {
            long l = System.currentTimeMillis();
            PlayerAction playerAction = ((AI)lSI).getAction(0, gameState);
            PlayerAction playerAction2 = ((AI)naiveMCTS).getAction(1, gameState);
            gameState.issueSafe(playerAction);
            gameState.issueSafe(playerAction2);
            l = System.currentTimeMillis() - l;
            if (l < 50L) {
                Thread.sleep(50L - l);
            }
            bl = gameState.cycle();
            physicalGameStateJFrame.repaint();
        } while (!bl && gameState.getTime() < n);
        System.out.println("Game Over");
        String string2 = "";
        string2 = string2 + string + "\t";
        string2 = string2 + n + "\t";
        string2 = string2 + n2 + "\t";
        string2 = string2 + n3 + "\t";
        string2 = string2 + randomBiasedAI.getClass().getSimpleName() + "\t";
        string2 = string2 + simpleSqrtEvaluationFunction3.getClass().getSimpleName() + "\t";
        string2 = string2 + lSI.getClass().getSimpleName() + "\t";
        string2 = string2 + naiveMCTS.getClass().getSimpleName() + "\t";
        string2 = string2 + gameState.winner() + "\t";
        string2 = string2 + ((EvaluationFunction)simpleSqrtEvaluationFunction3).evaluate(0, 1, gameState) + "\t";
        string2 = string2 + ((AI)lSI).statisticsString() + "\t";
        string2 = string2 + ((AI)naiveMCTS).statisticsString() + "\t";
        System.out.println(string2);
    }
}

