/*
 * Decompiled with CFR 0.152.
 */
package tests;

import java.io.FileWriter;
import java.io.IOException;
import rts.PhysicalGameState;
import rts.Player;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public class MapGenerator {
    static UnitTypeTable utt = null;
    UnitType resourceType = null;
    UnitType baseType = null;
    UnitType barracksType = null;
    UnitType workerType = null;
    UnitType lightType = null;
    UnitType heavyType = null;
    UnitType rangedType = null;

    public MapGenerator(UnitTypeTable unitTypeTable) {
        utt = unitTypeTable;
        this.resourceType = utt.getUnitType("Resource");
        this.baseType = utt.getUnitType("Base");
        this.barracksType = utt.getUnitType("Barracks");
        this.workerType = utt.getUnitType("Worker");
        this.lightType = utt.getUnitType("Light");
        this.heavyType = utt.getUnitType("Heavy");
        this.rangedType = utt.getUnitType("Ranged");
    }

    public static void main(String[] stringArray) throws IOException {
        MapGenerator mapGenerator = new MapGenerator(new UnitTypeTable());
        XMLWriter xMLWriter = new XMLWriter(new FileWriter("maps/8x8/bases8x8.xml"));
        mapGenerator.bases8x8().toxml(xMLWriter);
        xMLWriter.flush();
        xMLWriter = new XMLWriter(new FileWriter("maps/8x8/basesWorkers8x8.xml"));
        mapGenerator.basesWorkers8x8().toxml(xMLWriter);
        xMLWriter.flush();
        xMLWriter = new XMLWriter(new FileWriter("maps/8x8/basesWorkers8x8Obstacle.xml"));
        mapGenerator.basesWorkers8x8Obstacle().toxml(xMLWriter);
        xMLWriter.flush();
        xMLWriter = new XMLWriter(new FileWriter("maps/12x12/basesWorkers12x12.xml"));
        mapGenerator.basesWorkers12x12().toxml(xMLWriter);
        xMLWriter.flush();
        xMLWriter = new XMLWriter(new FileWriter("maps/12x12/complexBasesWorkers12x12.xml"));
        mapGenerator.complexBasesWorkers12x12().toxml(xMLWriter);
        xMLWriter.flush();
        xMLWriter = new XMLWriter(new FileWriter("maps/16x16/basesWorkers16x16.xml"));
        mapGenerator.basesWorkers16x16().toxml(xMLWriter);
        xMLWriter.flush();
        xMLWriter = new XMLWriter(new FileWriter("maps/8x8/basesWorkersBarracks8x8.xml"));
        mapGenerator.basesWorkersBarracks8x8().toxml(xMLWriter);
        xMLWriter.flush();
        xMLWriter = new XMLWriter(new FileWriter("maps/melee4x4light2.xml"));
        mapGenerator.melee4x4light2().toxml(xMLWriter);
        xMLWriter.flush();
        xMLWriter = new XMLWriter(new FileWriter("maps/8x8/melee8x8light4.xml"));
        mapGenerator.melee8x8light4().toxml(xMLWriter);
        xMLWriter.flush();
        xMLWriter = new XMLWriter(new FileWriter("maps/8x8/melee8x8Mixed4.xml"));
        mapGenerator.melee8x8Mixed4().toxml(xMLWriter);
        xMLWriter.flush();
        xMLWriter = new XMLWriter(new FileWriter("maps/8x8/melee8x8Mixed6.xml"));
        mapGenerator.melee8x8Mixed6().toxml(xMLWriter);
        xMLWriter.flush();
        xMLWriter = new XMLWriter(new FileWriter("maps/16x16/melee16x16Mixed8.xml"));
        mapGenerator.melee16x16Mixed8().toxml(xMLWriter);
        xMLWriter.flush();
        xMLWriter = new XMLWriter(new FileWriter("maps/12x12/melee12x12Mixed12.xml"));
        mapGenerator.melee12x12Mixed12().toxml(xMLWriter);
        xMLWriter.flush();
        xMLWriter = new XMLWriter(new FileWriter("maps/16x16/melee16x16Mixed12.xml"));
        mapGenerator.melee16x16Mixed12().toxml(xMLWriter);
        xMLWriter.flush();
        xMLWriter = new XMLWriter(new FileWriter("maps/14x12/melee14x12Mixed18.xml"));
        mapGenerator.melee14x12Mixed18().toxml(xMLWriter);
        xMLWriter.flush();
    }

    public PhysicalGameState bases8x8() {
        PhysicalGameState physicalGameState = new PhysicalGameState(8, 8);
        Player player = new Player(0, 5);
        Player player2 = new Player(1, 5);
        physicalGameState.addPlayer(player);
        physicalGameState.addPlayer(player2);
        Unit unit = new Unit(-1, this.resourceType, 0, 0, 20);
        Unit unit2 = new Unit(-1, this.resourceType, 7, 7, 20);
        physicalGameState.addUnit(unit);
        physicalGameState.addUnit(unit2);
        Unit unit3 = new Unit(0, this.baseType, 2, 1, 0);
        Unit unit4 = new Unit(1, this.baseType, 5, 6, 0);
        physicalGameState.addUnit(unit3);
        physicalGameState.addUnit(unit4);
        return physicalGameState;
    }

    public PhysicalGameState basesWorkers8x8() {
        PhysicalGameState physicalGameState = new PhysicalGameState(8, 8);
        Player player = new Player(0, 5);
        Player player2 = new Player(1, 5);
        physicalGameState.addPlayer(player);
        physicalGameState.addPlayer(player2);
        Unit unit = new Unit(-1, this.resourceType, 0, 0, 20);
        Unit unit2 = new Unit(-1, this.resourceType, 7, 7, 20);
        physicalGameState.addUnit(unit);
        physicalGameState.addUnit(unit2);
        Unit unit3 = new Unit(0, this.baseType, 2, 1, 0);
        Unit unit4 = new Unit(1, this.baseType, 5, 6, 0);
        physicalGameState.addUnit(unit3);
        physicalGameState.addUnit(unit4);
        Unit unit5 = new Unit(0, this.workerType, 1, 1, 0);
        Unit unit6 = new Unit(1, this.workerType, 6, 6, 0);
        physicalGameState.addUnit(unit5);
        physicalGameState.addUnit(unit6);
        return physicalGameState;
    }

    public PhysicalGameState basesWorkers8x8Obstacle() {
        PhysicalGameState physicalGameState = new PhysicalGameState(8, 8);
        Player player = new Player(0, 5);
        Player player2 = new Player(1, 5);
        physicalGameState.addPlayer(player);
        physicalGameState.addPlayer(player2);
        Unit unit = new Unit(-1, this.resourceType, 0, 0, 20);
        Unit unit2 = new Unit(-1, this.resourceType, 7, 7, 20);
        physicalGameState.addUnit(unit);
        physicalGameState.addUnit(unit2);
        Unit unit3 = new Unit(0, this.baseType, 2, 1, 0);
        Unit unit4 = new Unit(1, this.baseType, 5, 6, 0);
        physicalGameState.addUnit(unit3);
        physicalGameState.addUnit(unit4);
        Unit unit5 = new Unit(0, this.workerType, 1, 1, 0);
        Unit unit6 = new Unit(1, this.workerType, 6, 6, 0);
        physicalGameState.addUnit(unit5);
        physicalGameState.addUnit(unit6);
        physicalGameState.setTerrain(2, 3, 1);
        physicalGameState.setTerrain(2, 4, 1);
        physicalGameState.setTerrain(3, 3, 1);
        physicalGameState.setTerrain(3, 4, 1);
        physicalGameState.setTerrain(4, 3, 1);
        physicalGameState.setTerrain(4, 4, 1);
        physicalGameState.setTerrain(5, 3, 1);
        physicalGameState.setTerrain(5, 4, 1);
        return physicalGameState;
    }

    public PhysicalGameState basesWorkers12x12() {
        PhysicalGameState physicalGameState = new PhysicalGameState(12, 12);
        Player player = new Player(0, 5);
        Player player2 = new Player(1, 5);
        physicalGameState.addPlayer(player);
        physicalGameState.addPlayer(player2);
        Unit unit = new Unit(-1, this.resourceType, 0, 0, 20);
        Unit unit2 = new Unit(-1, this.resourceType, 1, 0, 20);
        Unit unit3 = new Unit(-1, this.resourceType, 11, 11, 20);
        Unit unit4 = new Unit(-1, this.resourceType, 10, 11, 20);
        physicalGameState.addUnit(unit);
        physicalGameState.addUnit(unit2);
        physicalGameState.addUnit(unit3);
        physicalGameState.addUnit(unit4);
        Unit unit5 = new Unit(0, this.baseType, 1, 2, 0);
        Unit unit6 = new Unit(1, this.baseType, 10, 9, 0);
        physicalGameState.addUnit(unit5);
        physicalGameState.addUnit(unit6);
        Unit unit7 = new Unit(0, this.workerType, 1, 1, 0);
        Unit unit8 = new Unit(1, this.workerType, 10, 10, 0);
        physicalGameState.addUnit(unit7);
        physicalGameState.addUnit(unit8);
        return physicalGameState;
    }

    public PhysicalGameState complexBasesWorkers12x12() {
        PhysicalGameState physicalGameState = new PhysicalGameState(12, 12);
        Player player = new Player(0, 5);
        Player player2 = new Player(1, 5);
        physicalGameState.addPlayer(player);
        physicalGameState.addPlayer(player2);
        Unit unit = new Unit(-1, this.resourceType, 0, 0, 20);
        Unit unit2 = new Unit(-1, this.resourceType, 1, 0, 20);
        Unit unit3 = new Unit(-1, this.resourceType, 0, 1, 20);
        Unit unit4 = new Unit(-1, this.resourceType, 11, 11, 20);
        Unit unit5 = new Unit(-1, this.resourceType, 10, 11, 20);
        Unit unit6 = new Unit(-1, this.resourceType, 11, 10, 20);
        physicalGameState.addUnit(unit);
        physicalGameState.addUnit(unit2);
        physicalGameState.addUnit(unit3);
        physicalGameState.addUnit(unit4);
        physicalGameState.addUnit(unit5);
        physicalGameState.addUnit(unit6);
        Unit unit7 = new Unit(0, this.baseType, 1, 3, 0);
        Unit unit8 = new Unit(0, this.baseType, 3, 1, 0);
        Unit unit9 = new Unit(1, this.baseType, 10, 8, 0);
        Unit unit10 = new Unit(1, this.baseType, 8, 10, 0);
        physicalGameState.addUnit(unit7);
        physicalGameState.addUnit(unit8);
        physicalGameState.addUnit(unit9);
        physicalGameState.addUnit(unit10);
        Unit unit11 = new Unit(0, this.workerType, 2, 2, 0);
        Unit unit12 = new Unit(1, this.workerType, 9, 9, 0);
        physicalGameState.addUnit(unit11);
        physicalGameState.addUnit(unit12);
        return physicalGameState;
    }

    public PhysicalGameState basesWorkers16x16() {
        PhysicalGameState physicalGameState = new PhysicalGameState(16, 16);
        Player player = new Player(0, 5);
        Player player2 = new Player(1, 5);
        physicalGameState.addPlayer(player);
        physicalGameState.addPlayer(player2);
        Unit unit = new Unit(-1, this.resourceType, 0, 0, 25);
        Unit unit2 = new Unit(-1, this.resourceType, 0, 1, 25);
        Unit unit3 = new Unit(-1, this.resourceType, 15, 14, 25);
        Unit unit4 = new Unit(-1, this.resourceType, 15, 15, 25);
        physicalGameState.addUnit(unit);
        physicalGameState.addUnit(unit2);
        physicalGameState.addUnit(unit3);
        physicalGameState.addUnit(unit4);
        Unit unit5 = new Unit(0, this.baseType, 2, 2, 0);
        Unit unit6 = new Unit(1, this.baseType, 13, 13, 0);
        physicalGameState.addUnit(unit5);
        physicalGameState.addUnit(unit6);
        Unit unit7 = new Unit(0, this.workerType, 1, 1, 0);
        Unit unit8 = new Unit(1, this.workerType, 14, 14, 0);
        physicalGameState.addUnit(unit7);
        physicalGameState.addUnit(unit8);
        return physicalGameState;
    }

    public PhysicalGameState basesWorkersBarracks8x8() {
        PhysicalGameState physicalGameState = new PhysicalGameState(8, 8);
        Player player = new Player(0, 5);
        Player player2 = new Player(1, 5);
        physicalGameState.addPlayer(player);
        physicalGameState.addPlayer(player2);
        Unit unit = new Unit(-1, this.resourceType, 0, 0, 10);
        Unit unit2 = new Unit(-1, this.resourceType, 7, 7, 10);
        physicalGameState.addUnit(unit);
        physicalGameState.addUnit(unit2);
        Unit unit3 = new Unit(0, this.baseType, 2, 1, 0);
        Unit unit4 = new Unit(1, this.baseType, 5, 6, 0);
        physicalGameState.addUnit(unit3);
        physicalGameState.addUnit(unit4);
        Unit unit5 = new Unit(0, this.workerType, 1, 1, 0);
        Unit unit6 = new Unit(1, this.workerType, 6, 6, 0);
        physicalGameState.addUnit(unit5);
        physicalGameState.addUnit(unit6);
        Unit unit7 = new Unit(0, this.barracksType, 4, 0, 0);
        Unit unit8 = new Unit(1, this.barracksType, 3, 7, 0);
        physicalGameState.addUnit(unit7);
        physicalGameState.addUnit(unit8);
        return physicalGameState;
    }

    public PhysicalGameState melee4x4light2() {
        PhysicalGameState physicalGameState = new PhysicalGameState(4, 4);
        Player player = new Player(0, 0);
        Player player2 = new Player(1, 0);
        physicalGameState.addPlayer(player);
        physicalGameState.addPlayer(player2);
        Unit unit = new Unit(0, this.lightType, 0, 0);
        Unit unit2 = new Unit(0, this.lightType, 0, 1);
        Unit unit3 = new Unit(1, this.lightType, 3, 2);
        Unit unit4 = new Unit(1, this.lightType, 3, 3);
        physicalGameState.addUnit(unit);
        physicalGameState.addUnit(unit2);
        physicalGameState.addUnit(unit3);
        physicalGameState.addUnit(unit4);
        return physicalGameState;
    }

    public PhysicalGameState melee8x8light4() {
        PhysicalGameState physicalGameState = new PhysicalGameState(8, 8);
        Player player = new Player(0, 0);
        Player player2 = new Player(1, 0);
        physicalGameState.addPlayer(player);
        physicalGameState.addPlayer(player2);
        Unit unit = new Unit(0, this.lightType, 1, 1);
        Unit unit2 = new Unit(0, this.lightType, 2, 1);
        Unit unit3 = new Unit(0, this.lightType, 1, 2);
        Unit unit4 = new Unit(0, this.lightType, 2, 2);
        Unit unit5 = new Unit(1, this.lightType, 5, 5);
        Unit unit6 = new Unit(1, this.lightType, 5, 6);
        Unit unit7 = new Unit(1, this.lightType, 6, 5);
        Unit unit8 = new Unit(1, this.lightType, 6, 6);
        physicalGameState.addUnit(unit);
        physicalGameState.addUnit(unit2);
        physicalGameState.addUnit(unit3);
        physicalGameState.addUnit(unit4);
        physicalGameState.addUnit(unit5);
        physicalGameState.addUnit(unit6);
        physicalGameState.addUnit(unit7);
        physicalGameState.addUnit(unit8);
        return physicalGameState;
    }

    public PhysicalGameState melee8x8Mixed4() {
        PhysicalGameState physicalGameState = new PhysicalGameState(8, 8);
        Player player = new Player(0, 0);
        Player player2 = new Player(1, 0);
        physicalGameState.addPlayer(player);
        physicalGameState.addPlayer(player2);
        Unit unit = new Unit(0, this.heavyType, 1, 1);
        Unit unit2 = new Unit(0, this.lightType, 2, 1);
        Unit unit3 = new Unit(0, this.heavyType, 1, 2);
        Unit unit4 = new Unit(0, this.lightType, 2, 2);
        Unit unit5 = new Unit(1, this.lightType, 5, 5);
        Unit unit6 = new Unit(1, this.lightType, 5, 6);
        Unit unit7 = new Unit(1, this.heavyType, 6, 5);
        Unit unit8 = new Unit(1, this.heavyType, 6, 6);
        physicalGameState.addUnit(unit);
        physicalGameState.addUnit(unit2);
        physicalGameState.addUnit(unit3);
        physicalGameState.addUnit(unit4);
        physicalGameState.addUnit(unit5);
        physicalGameState.addUnit(unit6);
        physicalGameState.addUnit(unit7);
        physicalGameState.addUnit(unit8);
        return physicalGameState;
    }

    public PhysicalGameState melee8x8Mixed6() {
        PhysicalGameState physicalGameState = new PhysicalGameState(8, 8);
        Player player = new Player(0, 0);
        Player player2 = new Player(1, 0);
        physicalGameState.addPlayer(player);
        physicalGameState.addPlayer(player2);
        physicalGameState.addUnit(new Unit(0, this.lightType, 2, 0));
        physicalGameState.addUnit(new Unit(0, this.lightType, 2, 1));
        physicalGameState.addUnit(new Unit(0, this.heavyType, 1, 0));
        physicalGameState.addUnit(new Unit(0, this.heavyType, 1, 1));
        physicalGameState.addUnit(new Unit(0, this.rangedType, 0, 0));
        physicalGameState.addUnit(new Unit(0, this.rangedType, 0, 1));
        physicalGameState.addUnit(new Unit(1, this.lightType, 5, 6));
        physicalGameState.addUnit(new Unit(1, this.lightType, 5, 7));
        physicalGameState.addUnit(new Unit(1, this.heavyType, 6, 6));
        physicalGameState.addUnit(new Unit(1, this.heavyType, 6, 7));
        physicalGameState.addUnit(new Unit(1, this.rangedType, 7, 6));
        physicalGameState.addUnit(new Unit(1, this.rangedType, 7, 7));
        return physicalGameState;
    }

    public PhysicalGameState melee16x16Mixed8() {
        PhysicalGameState physicalGameState = new PhysicalGameState(16, 16);
        Player player = new Player(0, 0);
        Player player2 = new Player(1, 0);
        physicalGameState.addPlayer(player);
        physicalGameState.addPlayer(player2);
        physicalGameState.addUnit(new Unit(0, this.lightType, 2, 1));
        physicalGameState.addUnit(new Unit(0, this.lightType, 2, 2));
        physicalGameState.addUnit(new Unit(0, this.lightType, 2, 3));
        physicalGameState.addUnit(new Unit(0, this.lightType, 2, 4));
        physicalGameState.addUnit(new Unit(0, this.heavyType, 1, 1));
        physicalGameState.addUnit(new Unit(0, this.heavyType, 1, 2));
        physicalGameState.addUnit(new Unit(0, this.heavyType, 1, 3));
        physicalGameState.addUnit(new Unit(0, this.heavyType, 1, 4));
        physicalGameState.addUnit(new Unit(1, this.lightType, 13, 11));
        physicalGameState.addUnit(new Unit(1, this.lightType, 13, 12));
        physicalGameState.addUnit(new Unit(1, this.lightType, 13, 13));
        physicalGameState.addUnit(new Unit(1, this.lightType, 13, 14));
        physicalGameState.addUnit(new Unit(1, this.heavyType, 14, 11));
        physicalGameState.addUnit(new Unit(1, this.heavyType, 14, 12));
        physicalGameState.addUnit(new Unit(1, this.heavyType, 14, 13));
        physicalGameState.addUnit(new Unit(1, this.heavyType, 14, 14));
        return physicalGameState;
    }

    public PhysicalGameState melee12x12Mixed12() {
        PhysicalGameState physicalGameState = new PhysicalGameState(12, 12);
        Player player = new Player(0, 0);
        Player player2 = new Player(1, 0);
        physicalGameState.addPlayer(player);
        physicalGameState.addPlayer(player2);
        physicalGameState.addUnit(new Unit(0, this.lightType, 2, 1));
        physicalGameState.addUnit(new Unit(0, this.lightType, 2, 2));
        physicalGameState.addUnit(new Unit(0, this.lightType, 2, 3));
        physicalGameState.addUnit(new Unit(0, this.lightType, 2, 4));
        physicalGameState.addUnit(new Unit(0, this.heavyType, 1, 1));
        physicalGameState.addUnit(new Unit(0, this.heavyType, 1, 2));
        physicalGameState.addUnit(new Unit(0, this.heavyType, 1, 3));
        physicalGameState.addUnit(new Unit(0, this.heavyType, 1, 4));
        physicalGameState.addUnit(new Unit(0, this.rangedType, 0, 1));
        physicalGameState.addUnit(new Unit(0, this.rangedType, 0, 2));
        physicalGameState.addUnit(new Unit(0, this.rangedType, 0, 3));
        physicalGameState.addUnit(new Unit(0, this.rangedType, 0, 4));
        physicalGameState.addUnit(new Unit(1, this.lightType, 9, 7));
        physicalGameState.addUnit(new Unit(1, this.lightType, 9, 8));
        physicalGameState.addUnit(new Unit(1, this.lightType, 9, 9));
        physicalGameState.addUnit(new Unit(1, this.lightType, 9, 10));
        physicalGameState.addUnit(new Unit(1, this.heavyType, 10, 7));
        physicalGameState.addUnit(new Unit(1, this.heavyType, 10, 8));
        physicalGameState.addUnit(new Unit(1, this.heavyType, 10, 9));
        physicalGameState.addUnit(new Unit(1, this.heavyType, 10, 10));
        physicalGameState.addUnit(new Unit(1, this.rangedType, 11, 7));
        physicalGameState.addUnit(new Unit(1, this.rangedType, 11, 8));
        physicalGameState.addUnit(new Unit(1, this.rangedType, 11, 9));
        physicalGameState.addUnit(new Unit(1, this.rangedType, 11, 10));
        return physicalGameState;
    }

    public PhysicalGameState melee16x16Mixed12() {
        PhysicalGameState physicalGameState = new PhysicalGameState(16, 16);
        Player player = new Player(0, 0);
        Player player2 = new Player(1, 0);
        physicalGameState.addPlayer(player);
        physicalGameState.addPlayer(player2);
        physicalGameState.addUnit(new Unit(0, this.lightType, 2, 1));
        physicalGameState.addUnit(new Unit(0, this.lightType, 2, 2));
        physicalGameState.addUnit(new Unit(0, this.lightType, 2, 3));
        physicalGameState.addUnit(new Unit(0, this.lightType, 2, 4));
        physicalGameState.addUnit(new Unit(0, this.heavyType, 1, 1));
        physicalGameState.addUnit(new Unit(0, this.heavyType, 1, 2));
        physicalGameState.addUnit(new Unit(0, this.heavyType, 1, 3));
        physicalGameState.addUnit(new Unit(0, this.heavyType, 1, 4));
        physicalGameState.addUnit(new Unit(0, this.rangedType, 0, 1));
        physicalGameState.addUnit(new Unit(0, this.rangedType, 0, 2));
        physicalGameState.addUnit(new Unit(0, this.rangedType, 0, 3));
        physicalGameState.addUnit(new Unit(0, this.rangedType, 0, 4));
        physicalGameState.addUnit(new Unit(1, this.lightType, 13, 11));
        physicalGameState.addUnit(new Unit(1, this.lightType, 13, 12));
        physicalGameState.addUnit(new Unit(1, this.lightType, 13, 13));
        physicalGameState.addUnit(new Unit(1, this.lightType, 13, 14));
        physicalGameState.addUnit(new Unit(1, this.heavyType, 14, 11));
        physicalGameState.addUnit(new Unit(1, this.heavyType, 14, 12));
        physicalGameState.addUnit(new Unit(1, this.heavyType, 14, 13));
        physicalGameState.addUnit(new Unit(1, this.heavyType, 14, 14));
        physicalGameState.addUnit(new Unit(1, this.rangedType, 15, 11));
        physicalGameState.addUnit(new Unit(1, this.rangedType, 15, 12));
        physicalGameState.addUnit(new Unit(1, this.rangedType, 15, 13));
        physicalGameState.addUnit(new Unit(1, this.rangedType, 15, 14));
        return physicalGameState;
    }

    public PhysicalGameState melee14x12Mixed18() {
        PhysicalGameState physicalGameState = new PhysicalGameState(14, 12);
        Player player = new Player(0, 0);
        Player player2 = new Player(1, 0);
        physicalGameState.addPlayer(player);
        physicalGameState.addPlayer(player2);
        physicalGameState.addUnit(new Unit(0, this.lightType, 2, 1));
        physicalGameState.addUnit(new Unit(0, this.lightType, 2, 2));
        physicalGameState.addUnit(new Unit(0, this.lightType, 2, 3));
        physicalGameState.addUnit(new Unit(0, this.lightType, 2, 4));
        physicalGameState.addUnit(new Unit(0, this.lightType, 2, 5));
        physicalGameState.addUnit(new Unit(0, this.lightType, 2, 6));
        physicalGameState.addUnit(new Unit(0, this.heavyType, 1, 1));
        physicalGameState.addUnit(new Unit(0, this.heavyType, 1, 2));
        physicalGameState.addUnit(new Unit(0, this.heavyType, 1, 3));
        physicalGameState.addUnit(new Unit(0, this.heavyType, 1, 4));
        physicalGameState.addUnit(new Unit(0, this.heavyType, 1, 5));
        physicalGameState.addUnit(new Unit(0, this.heavyType, 1, 6));
        physicalGameState.addUnit(new Unit(0, this.rangedType, 0, 1));
        physicalGameState.addUnit(new Unit(0, this.rangedType, 0, 2));
        physicalGameState.addUnit(new Unit(0, this.rangedType, 0, 3));
        physicalGameState.addUnit(new Unit(0, this.rangedType, 0, 4));
        physicalGameState.addUnit(new Unit(0, this.rangedType, 0, 5));
        physicalGameState.addUnit(new Unit(0, this.rangedType, 0, 6));
        physicalGameState.addUnit(new Unit(1, this.lightType, 11, 5));
        physicalGameState.addUnit(new Unit(1, this.lightType, 11, 6));
        physicalGameState.addUnit(new Unit(1, this.lightType, 11, 7));
        physicalGameState.addUnit(new Unit(1, this.lightType, 11, 8));
        physicalGameState.addUnit(new Unit(1, this.lightType, 11, 9));
        physicalGameState.addUnit(new Unit(1, this.lightType, 11, 10));
        physicalGameState.addUnit(new Unit(1, this.heavyType, 12, 5));
        physicalGameState.addUnit(new Unit(1, this.heavyType, 12, 6));
        physicalGameState.addUnit(new Unit(1, this.heavyType, 12, 7));
        physicalGameState.addUnit(new Unit(1, this.heavyType, 12, 8));
        physicalGameState.addUnit(new Unit(1, this.heavyType, 12, 9));
        physicalGameState.addUnit(new Unit(1, this.heavyType, 12, 10));
        physicalGameState.addUnit(new Unit(1, this.rangedType, 13, 5));
        physicalGameState.addUnit(new Unit(1, this.rangedType, 13, 6));
        physicalGameState.addUnit(new Unit(1, this.rangedType, 13, 7));
        physicalGameState.addUnit(new Unit(1, this.rangedType, 13, 8));
        physicalGameState.addUnit(new Unit(1, this.rangedType, 13, 9));
        physicalGameState.addUnit(new Unit(1, this.rangedType, 13, 10));
        return physicalGameState;
    }
}

