/*
 * Decompiled with CFR 0.152.
 */
package tests;

import ai.RandomBiasedAI;
import ai.abstraction.LightRush;
import ai.abstraction.pathfinding.BFSPathFinding;
import ai.core.AI;
import gui.PhysicalGameStateJFrame;
import gui.PhysicalGameStatePanel;
import java.io.OutputStreamWriter;
import rts.GameState;
import rts.PartiallyObservableGameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public class POGameVisualSimulationTest {
    public static void main(String[] stringArray) throws Exception {
        UnitTypeTable unitTypeTable = new UnitTypeTable();
        PhysicalGameState physicalGameState = PhysicalGameState.load("maps/16x16/basesWorkers16x16.xml", unitTypeTable);
        GameState gameState = new GameState(physicalGameState, unitTypeTable);
        int n = 5000;
        int n2 = 20;
        boolean bl = false;
        LightRush lightRush = new LightRush(unitTypeTable, new BFSPathFinding());
        RandomBiasedAI randomBiasedAI = new RandomBiasedAI();
        XMLWriter xMLWriter = new XMLWriter(new OutputStreamWriter(System.out));
        physicalGameState.toxml(xMLWriter);
        xMLWriter.flush();
        PhysicalGameStateJFrame physicalGameStateJFrame = PhysicalGameStatePanel.newVisualizer(gameState, 640, 640, true);
        long l = System.currentTimeMillis() + (long)n2;
        do {
            if (System.currentTimeMillis() >= l) {
                PlayerAction playerAction = ((AI)lightRush).getAction(0, new PartiallyObservableGameState(gameState, 0));
                PlayerAction playerAction2 = ((AI)randomBiasedAI).getAction(1, new PartiallyObservableGameState(gameState, 1));
                gameState.issueSafe(playerAction);
                gameState.issueSafe(playerAction2);
                bl = gameState.cycle();
                physicalGameStateJFrame.repaint();
                l += (long)n2;
                continue;
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } while (!bl && gameState.getTime() < n);
        lightRush.gameOver(gameState.winner());
        randomBiasedAI.gameOver(gameState.winner());
        System.out.println("Game Over");
    }
}

