/*
 * Decompiled with CFR 0.152.
 */
package tests;

import ai.RandomBiasedAI;
import ai.core.AI;
import ai.core.ContinuingAI;
import ai.evaluation.SimpleEvaluationFunction;
import ai.mcts.naivemcts.NaiveMCTS;
import gui.MouseController;
import gui.PhysicalGameStateMouseJFrame;
import gui.PhysicalGameStatePanel;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

public class PlayGameWithMouseTest {
    public static void main(String[] stringArray) throws Exception {
        UnitTypeTable unitTypeTable = new UnitTypeTable();
        PhysicalGameState physicalGameState = PhysicalGameState.load("maps/16x16/basesWorkers16x16.xml", unitTypeTable);
        GameState gameState = new GameState(physicalGameState, unitTypeTable);
        int n = 10000;
        int n2 = 100;
        boolean bl = false;
        PhysicalGameStatePanel physicalGameStatePanel = new PhysicalGameStatePanel(gameState);
        PhysicalGameStateMouseJFrame physicalGameStateMouseJFrame = new PhysicalGameStateMouseJFrame("Game State Visuakizer (Mouse)", 640, 640, physicalGameStatePanel);
        MouseController mouseController = new MouseController(physicalGameStateMouseJFrame);
        ContinuingAI continuingAI = new ContinuingAI(new NaiveMCTS(n2, -1, 100, 20, 0.33f, 0.0f, 0.75f, new RandomBiasedAI(), new SimpleEvaluationFunction(), true));
        long l = System.currentTimeMillis() + (long)n2;
        do {
            if (System.currentTimeMillis() >= l) {
                PlayerAction playerAction = ((AI)mouseController).getAction(0, gameState);
                PlayerAction playerAction2 = ((AI)continuingAI).getAction(1, gameState);
                gameState.issueSafe(playerAction);
                gameState.issueSafe(playerAction2);
                bl = gameState.cycle();
                physicalGameStateMouseJFrame.repaint();
                l += (long)n2;
                continue;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } while (!bl && gameState.getTime() < n);
        mouseController.gameOver(gameState.winner());
        continuingAI.gameOver(gameState.winner());
        System.out.println("Game Over");
    }
}

