/*
 * Decompiled with CFR 0.152.
 */
package tests;

import ai.RandomBiasedAI;
import ai.core.AI;
import ai.stochastic.UnitActionProbabilityDistributionAI;
import ai.stochastic.UnitActionTypeConstantDistribution;
import gui.PhysicalGameStateJFrame;
import gui.PhysicalGameStatePanel;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

public class PlayoutPolicyOptimization {
    static Random r = new Random();
    static List<Integer> maxGameLength = new ArrayList<Integer>();
    static UnitTypeTable utt = new UnitTypeTable();

    public static double computeRandomAIWinrate(double[] dArray, int n, int n2, String string) throws Exception {
        UnitActionProbabilityDistributionAI unitActionProbabilityDistributionAI;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(Paths.get(string, "maps/8x8/basesWorkers8x8A.xml").toString());
        maxGameLength.add(3000);
        arrayList.add(Paths.get(string, "maps/8x8/FourBasesWorkers8x8.xml").toString());
        maxGameLength.add(3000);
        arrayList.add(Paths.get(string, "maps/NoWhereToRun9x8.xml").toString());
        maxGameLength.add(3000);
        arrayList.add(Paths.get(string, "maps/16x16/basesWorkers16x16A.xml").toString());
        maxGameLength.add(4000);
        arrayList.add(Paths.get(string, "maps/16x16/TwoBasesBarracks16x16.xml").toString());
        maxGameLength.add(4000);
        boolean bl = false;
        UnitActionProbabilityDistributionAI unitActionProbabilityDistributionAI2 = unitActionProbabilityDistributionAI = new UnitActionProbabilityDistributionAI(new UnitActionTypeConstantDistribution(utt, dArray), utt, "uapdai1");
        RandomBiasedAI randomBiasedAI = new RandomBiasedAI();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<Thread> arrayList3 = new ArrayList<Thread>();
        for (int j = 0; j < n2; ++j) {
            Runnable runnable = () -> {
                try {
                    Object object;
                    double d = 0.5;
                    if (r.nextBoolean()) {
                        object = PlayoutPolicyOptimization.runGame(unitActionProbabilityDistributionAI2, randomBiasedAI, (String)arrayList.get(n), maxGameLength.get(n), bl, utt);
                        if (((GameState)object).winner() == 0) {
                            d = 1.0;
                        }
                        if (((GameState)object).winner() == 1) {
                            d = 0.0;
                        }
                    } else {
                        object = PlayoutPolicyOptimization.runGame(randomBiasedAI, unitActionProbabilityDistributionAI2, (String)arrayList.get(n), maxGameLength.get(n), bl, utt);
                        if (((GameState)object).winner() == 0) {
                            d = 0.0;
                        }
                        if (((GameState)object).winner() == 1) {
                            d = 1.0;
                        }
                    }
                    object = arrayList2;
                    synchronized (object) {
                        arrayList2.add(d);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            };
            Thread thread = new Thread(runnable);
            arrayList3.add(thread);
        }
        for (Thread thread : arrayList3) {
            thread.start();
        }
        for (Thread thread : arrayList3) {
            thread.join();
        }
        double d = 0.0;
        for (Double d2 : arrayList2) {
            d += d2.doubleValue();
        }
        return d /= (double)arrayList2.size();
    }

    public static GameState runGame(AI aI, AI aI2, String string, int n, boolean bl, UnitTypeTable unitTypeTable) throws Exception {
        boolean bl2;
        PhysicalGameState physicalGameState = PhysicalGameState.load(string, unitTypeTable);
        GameState gameState = new GameState(physicalGameState, unitTypeTable);
        PhysicalGameStateJFrame physicalGameStateJFrame = null;
        if (bl) {
            physicalGameStateJFrame = PhysicalGameStatePanel.newVisualizer(gameState, 640, 640, false, PhysicalGameStatePanel.COLORSCHEME_BLACK);
        }
        do {
            PlayerAction playerAction = aI.getAction(0, gameState);
            PlayerAction playerAction2 = aI2.getAction(1, gameState);
            gameState.issueSafe(playerAction);
            gameState.issueSafe(playerAction2);
            bl2 = gameState.cycle();
            if (bl) {
                physicalGameStateJFrame.repaint();
            }
            Thread.yield();
        } while (!bl2 && gameState.getTime() < n);
        aI.gameOver(gameState.winner());
        aI2.gameOver(gameState.winner());
        return gameState;
    }
}

