/*
 * Decompiled with CFR 0.152.
 */
package tests.bayesianmodels;

import ai.RandomBiasedAI;
import ai.abstraction.HeavyRush;
import ai.abstraction.LightRush;
import ai.abstraction.RangedRush;
import ai.abstraction.WorkerRush;
import ai.abstraction.pathfinding.AStarPathFinding;
import ai.core.AI;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import ai.mcts.naivemcts.NaiveMCTS;
import ai.montecarlo.lsi.LSI;
import ai.montecarlo.lsi.Sampling;
import gui.PhysicalGameStateJFrame;
import gui.PhysicalGameStatePanel;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;
import rts.PartiallyObservableGameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.Trace;
import rts.TraceEntry;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public class GenerateTrainingTraces {
    public static int DEBUG = 0;

    public static void main(String[] stringArray) throws Exception {
        RandomBiasedAI randomBiasedAI = new RandomBiasedAI();
        SimpleSqrtEvaluationFunction3 simpleSqrtEvaluationFunction3 = new SimpleSqrtEvaluationFunction3();
        UnitTypeTable unitTypeTable = new UnitTypeTable();
        int n = -1;
        int n2 = 100;
        int n3 = 1;
        int n4 = 500;
        LinkedList<AI> linkedList = new LinkedList<AI>();
        linkedList.add(new WorkerRush(unitTypeTable, new AStarPathFinding()));
        linkedList.add(new LightRush(unitTypeTable, new AStarPathFinding()));
        linkedList.add(new HeavyRush(unitTypeTable, new AStarPathFinding()));
        linkedList.add(new RangedRush(unitTypeTable, new AStarPathFinding()));
        linkedList.add(new LSI(n4, n2, 0.75, LSI.EstimateType.RANDOM_TAIL, LSI.EstimateReuseType.ALL, LSI.GenerateType.PER_AGENT, Sampling.AgentOrderingType.ENTROPY, LSI.EvaluateType.HALVING, false, LSI.RelaxationType.NONE, 2, false, randomBiasedAI, simpleSqrtEvaluationFunction3));
        linkedList.add(new NaiveMCTS(n, n4, n2, 16, 0.33f, 0.0f, 0.4f, new RandomBiasedAI(), new SimpleSqrtEvaluationFunction3(), true));
        String[] stringArray2 = new String[]{"maps/8x8/OneBaseWorker8x8.xml", "maps/8x8/TwoBasesWorkers8x8.xml", "maps/8x8/ThreeBasesWorkers8x8.xml", "maps/8x8/FourBasesWorkers8x8.xml", "maps/12x12/OneBaseWorker12x12.xml", "maps/12x12/TwoBasesWorkers12x12.xml", "maps/12x12/ThreeBasesWorkers12x12.xml", "maps/12x12/FourBasesWorkers12x12.xml"};
        PrintStream printStream = new PrintStream(new File("learningtracegeneration-" + n4 + ".txt"));
        LinkedList<PhysicalGameState> linkedList2 = new LinkedList<PhysicalGameState>();
        for (String string : stringArray2) {
            linkedList2.add(PhysicalGameState.load(string, unitTypeTable));
        }
        GenerateTrainingTraces.runExperiments(linkedList, linkedList2, unitTypeTable, n3, 3000, 300, false, printStream, -1, false, false, "learningtrace-" + n4);
    }

    public static void runExperiments(List<AI> list, List<PhysicalGameState> list2, UnitTypeTable unitTypeTable, int n, int n2, int n3, boolean bl, PrintStream printStream, int n4, boolean bl2, boolean bl3, String string) throws Exception {
        int n5;
        int[][] nArray = new int[list.size()][list.size()];
        int[][] nArray2 = new int[list.size()][list.size()];
        int[][] nArray3 = new int[list.size()][list.size()];
        double[][] dArray = new double[list.size()][list.size()];
        double[][] dArray2 = new double[list.size()][list.size()];
        double[][] dArray3 = new double[list.size()][list.size()];
        LinkedList<AI> linkedList = new LinkedList<AI>();
        for (AI aI : list) {
            linkedList.add(aI.clone());
        }
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (int j = 0; j < list.size(); ++j) {
                if (n4 != -1 && n5 != n4 && j != n4 || bl2 && n5 == j) continue;
                for (PhysicalGameState physicalGameState : list2) {
                    for (int k = 0; k < n; ++k) {
                        Object object;
                        Object object2;
                        AI aI = list.get(n5);
                        AI aI2 = (AI)linkedList.get(j);
                        long l = 0L;
                        aI.reset();
                        aI2.reset();
                        GameState gameState = new GameState(physicalGameState.clone(), unitTypeTable);
                        Trace trace = new Trace(unitTypeTable);
                        TraceEntry traceEntry = new TraceEntry(gameState.getPhysicalGameState().clone(), gameState.getTime());
                        trace.addEntry(traceEntry);
                        PhysicalGameStateJFrame physicalGameStateJFrame = null;
                        if (bl) {
                            physicalGameStateJFrame = PhysicalGameStatePanel.newVisualizer(gameState, 600, 600, bl3);
                        }
                        printStream.println("MATCH UP: " + aI + " vs " + aI2);
                        boolean bl4 = false;
                        do {
                            System.gc();
                            object2 = null;
                            object = null;
                            if (bl3) {
                                object2 = aI.getAction(0, new PartiallyObservableGameState(gameState, 0));
                                object = aI2.getAction(1, new PartiallyObservableGameState(gameState, 1));
                            } else {
                                object2 = aI.getAction(0, gameState);
                                if (DEBUG >= 1) {
                                    System.out.println("AI1 done.");
                                    printStream.flush();
                                }
                                object = aI2.getAction(1, gameState);
                                if (DEBUG >= 1) {
                                    System.out.println("AI2 done.");
                                    printStream.flush();
                                }
                            }
                            if (!((PlayerAction)object2).isEmpty() || !((PlayerAction)object).isEmpty()) {
                                traceEntry = new TraceEntry(gameState.getPhysicalGameState().clone(), gameState.getTime());
                                traceEntry.addPlayerAction(((PlayerAction)object2).clone());
                                traceEntry.addPlayerAction(((PlayerAction)object).clone());
                                trace.addEntry(traceEntry);
                            }
                            if (gameState.issueSafe((PlayerAction)object2)) {
                                l = gameState.getTime();
                            }
                            if (gameState.issueSafe((PlayerAction)object)) {
                                l = gameState.getTime();
                            }
                            bl4 = gameState.cycle();
                            if (DEBUG >= 1) {
                                System.out.println("cycle done.");
                                printStream.flush();
                            }
                            if (physicalGameStateJFrame == null) continue;
                            physicalGameStateJFrame.setStateCloning(gameState);
                            physicalGameStateJFrame.repaint();
                            try {
                                Thread.sleep(1L);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        } while (!bl4 && gameState.getTime() < n2 && (long)gameState.getTime() - l < (long)n3);
                        traceEntry = new TraceEntry(gameState.getPhysicalGameState().clone(), gameState.getTime());
                        trace.addEntry(traceEntry);
                        object2 = string + "-map" + list2.indexOf(physicalGameState) + "-AI" + n5 + "-AI" + j + "-" + k + ".xml";
                        System.out.println("Saving trace: " + (String)object2);
                        object = new XMLWriter(new FileWriter((String)object2));
                        trace.toxml((XMLWriter)object);
                        ((XMLWriter)object).flush();
                        if (physicalGameStateJFrame != null) {
                            physicalGameStateJFrame.dispose();
                        }
                        int n6 = gameState.winner();
                        printStream.println("Winner: " + n6 + "  in " + gameState.getTime() + " cycles");
                        printStream.println(aI + " : " + aI.statisticsString());
                        printStream.println(aI2 + " : " + aI2.statisticsString());
                        printStream.flush();
                        if (n6 == -1) {
                            int[] nArray4 = nArray2[n5];
                            int n7 = j;
                            nArray4[n7] = nArray4[n7] + 1;
                            double[] dArray4 = dArray2[n5];
                            int n8 = j;
                            dArray4[n8] = dArray4[n8] + (double)gameState.getTime();
                            int[] nArray5 = nArray2[j];
                            int n9 = n5;
                            nArray5[n9] = nArray5[n9] + 1;
                            double[] dArray5 = dArray2[j];
                            int n10 = n5;
                            dArray5[n10] = dArray5[n10] + (double)gameState.getTime();
                            continue;
                        }
                        if (n6 == 0) {
                            int[] nArray6 = nArray[n5];
                            int n11 = j;
                            nArray6[n11] = nArray6[n11] + 1;
                            double[] dArray6 = dArray[n5];
                            int n12 = j;
                            dArray6[n12] = dArray6[n12] + (double)gameState.getTime();
                            int[] nArray7 = nArray3[j];
                            int n13 = n5;
                            nArray7[n13] = nArray7[n13] + 1;
                            double[] dArray7 = dArray3[j];
                            int n14 = n5;
                            dArray7[n14] = dArray7[n14] + (double)gameState.getTime();
                            continue;
                        }
                        if (n6 != 1) continue;
                        int[] nArray8 = nArray3[n5];
                        int n15 = j;
                        nArray8[n15] = nArray8[n15] + 1;
                        double[] dArray8 = dArray3[n5];
                        int n16 = j;
                        dArray8[n16] = dArray8[n16] + (double)gameState.getTime();
                        int[] nArray9 = nArray[j];
                        int n17 = n5;
                        nArray9[n17] = nArray9[n17] + 1;
                        double[] dArray9 = dArray[j];
                        int n18 = n5;
                        dArray9[n18] = dArray9[n18] + (double)gameState.getTime();
                    }
                }
            }
        }
        printStream.println("Wins: ");
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (int j = 0; j < list.size(); ++j) {
                printStream.print(nArray[n5][j] + ", ");
            }
            printStream.println("");
        }
        printStream.println("Ties: ");
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (int j = 0; j < list.size(); ++j) {
                printStream.print(nArray2[n5][j] + ", ");
            }
            printStream.println("");
        }
        printStream.println("Loses: ");
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (int j = 0; j < list.size(); ++j) {
                printStream.print(nArray3[n5][j] + ", ");
            }
            printStream.println("");
        }
        printStream.println("Win average time: ");
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (int j = 0; j < list.size(); ++j) {
                if (nArray[n5][j] > 0) {
                    printStream.print(dArray[n5][j] / (double)nArray[n5][j] + ", ");
                    continue;
                }
                printStream.print("-, ");
            }
            printStream.println("");
        }
        printStream.println("Tie average time: ");
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (int j = 0; j < list.size(); ++j) {
                if (nArray2[n5][j] > 0) {
                    printStream.print(dArray2[n5][j] / (double)nArray2[n5][j] + ", ");
                    continue;
                }
                printStream.print("-, ");
            }
            printStream.println("");
        }
        printStream.println("Lose average time: ");
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (int j = 0; j < list.size(); ++j) {
                if (nArray3[n5][j] > 0) {
                    printStream.print(dArray3[n5][j] / (double)nArray3[n5][j] + ", ");
                    continue;
                }
                printStream.print("-, ");
            }
            printStream.println("");
        }
        printStream.flush();
    }
}

