/*
 * Decompiled with CFR 0.152.
 */
package tests.sockets;

import ai.PassiveAI;
import ai.RandomBiasedAI;
import ai.RandomNoAttackAI;
import ai.core.AI;
import ai.socket.IndividualSocketRewardAI;
import ai.socket.SocketAIInterface;
import ai.socket.SocketRewardAI;
import ai.socket.SocketRewardPenaltyOnInvalidActionAI;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import gui.PhysicalGameStateJFrame;
import gui.PhysicalGameStatePanel;
import java.io.FileWriter;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

public class RunClient {
    @Parameter(names={"--server-ip"}, description="The microRTS server IP")
    String serverIP = "127.0.0.1";
    @Parameter(names={"--server-port"}, description="The microRTS server port")
    int serverPort = 9898;
    @Parameter(names={"--unix-socket-path"}, description="The path to the unix domain socket file")
    String unixSocketPath = "/home/costa/Documents/work/go/src/github.com/vwxyzjn/gym-microrts/unix/u";
    @Parameter(names={"--map"}, description="Which map in the `maps` folder are you using?")
    String map = "maps/4x4/baseTwoWorkersMaxResources4x4.xml";
    @Parameter(names={"--ai1-type"}, description="The type of AI1")
    String ai1Type = "no-penalty";
    @Parameter(names={"--ai2-type"}, description="The type of AI2")
    String ai2Type = "passive";
    @Parameter(names={"--window-size"}, description="The microRTS server IP")
    int windowSize = 1;
    @Parameter(names={"--seed"}, description="The random seed")
    int seed = 3;
    @Parameter(names={"--evaluation-filename"}, description="Whether to save the evaluation results in a the supplied filename")
    String evaluationFileName = "./test.json";
    @Parameter(names={"--microrts-path"}, description="The path of microrts unzipped folder")
    String micrortsPath = "";
    PhysicalGameStateJFrame w;
    SocketAIInterface ai1;
    AI ai2;

    public static void main(String[] stringArray) throws Exception {
        RunClient runClient = new RunClient();
        JCommander.newBuilder().addObject(runClient).build().parse(stringArray);
        runClient.run();
    }

    public void run() throws Exception {
        UnitTypeTable unitTypeTable = new UnitTypeTable();
        unitTypeTable.getUnitType((String)"Worker").harvestTime = 10;
        boolean bl = false;
        boolean bl2 = true;
        switch (this.ai1Type) {
            case "penalty": {
                this.ai1 = new SocketRewardPenaltyOnInvalidActionAI(100, 0, this.serverIP, this.serverPort, 2, unitTypeTable, bl2);
                break;
            }
            case "no-penalty": {
                if (this.unixSocketPath.length() > 0) {
                    this.ai1 = new SocketRewardAI(100, 0, this.unixSocketPath, 2, unitTypeTable, bl2);
                    System.out.println("unixSocket used");
                    break;
                }
                this.ai1 = new SocketRewardAI(100, 0, this.serverIP, this.serverPort, 2, unitTypeTable, bl2);
                break;
            }
            case "no-penalty-individual": {
                if (this.unixSocketPath.length() > 0) {
                    this.ai1 = new IndividualSocketRewardAI(100, 0, this.unixSocketPath, 2, unitTypeTable, bl2, this.windowSize);
                    break;
                }
                this.ai1 = new IndividualSocketRewardAI(100, 0, this.serverIP, this.serverPort, 2, unitTypeTable, bl2, this.windowSize);
                break;
            }
            case "random-no-attack": {
                this.ai1 = new RandomNoAttackAI(this.seed);
                break;
            }
            default: {
                throw new Exception("no ai1 was chosen");
            }
        }
        switch (this.ai2Type) {
            case "passive": {
                this.ai2 = new PassiveAI();
                break;
            }
            case "random-biased": {
                this.ai2 = new RandomBiasedAI();
                break;
            }
            default: {
                throw new Exception("no ai2 was chosen");
            }
        }
        System.out.println("Socket client started");
        if (this.micrortsPath.length() != 0) {
            this.map = Paths.get(this.micrortsPath, this.map).toString();
        }
        Object object = PhysicalGameState.load(this.map, unitTypeTable);
        GameState gameState = new GameState((PhysicalGameState)object, unitTypeTable);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        do {
            boolean bl3 = true;
            boolean bl4 = true;
            int n = 2000;
            int n2 = 2000;
            this.ai1.reset();
            this.ai2.reset();
            object = PhysicalGameState.load(this.map, unitTypeTable);
            gameState = new GameState((PhysicalGameState)object, unitTypeTable);
            while (true) {
                this.ai1.computeReward(0, 1, gameState);
                if (this.ai1.getReward() == 10.0 && bl4) {
                    bl4 = false;
                    n2 = gameState.getTime();
                }
                if (gameState.getPlayer(0).getResources() == 6 && bl3) {
                    bl3 = false;
                    n = gameState.getTime();
                }
                PlayerAction playerAction = this.ai1.getAction(0, gameState);
                if (this.ai1.getRender()) {
                    if (this.w == null) {
                        this.w = PhysicalGameStatePanel.newVisualizer(gameState, 640, 640, false, PhysicalGameStatePanel.COLORSCHEME_BLACK);
                    }
                    this.w.setStateCloning(gameState);
                    this.w.repaint();
                    this.ai1.sendGameStateRGBArray(this.w);
                    continue;
                }
                if (this.ai1.getReset()) break;
                PlayerAction playerAction2 = this.ai2.getAction(1, gameState);
                gameState.issueSafe(playerAction);
                gameState.issueSafe(playerAction2);
                bl = gameState.cycle();
                if (bl) {
                    this.ai1.gameOver(gameState.winner());
                }
                try {
                    Thread.yield();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            arrayList2.add(n);
            arrayList.add(n2);
            arrayList3.add(gameState.getPlayer(0).getResources() - 5);
            this.ai2.gameOver(gameState.winner());
        } while (!this.ai1.getFinished());
        System.out.println("Socket client finished");
        if (this.w != null) {
            this.w.dispose();
        }
        if (this.evaluationFileName.length() != 0) {
            try (FileWriter fileWriter = new FileWriter(this.evaluationFileName);){
                HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
                hashMap.put("average_first_returned_resources_timestep", Double.valueOf(this.calculateAverage(arrayList2)));
                hashMap.put("first_returned_resources_timestep", arrayList2);
                hashMap.put("average_total_resources_gathered", Double.valueOf(this.calculateAverage(arrayList3)));
                hashMap.put("total_resources_gathered", arrayList3);
                hashMap.put("average_first_harvested_resources_timestep", Double.valueOf(this.calculateAverage(arrayList)));
                hashMap.put("first_harvested_resources_timestep", arrayList);
                hashMap.put("episodes_run", Integer.valueOf(arrayList2.size()));
                Gson gson = new GsonBuilder().create();
                gson.toJson(hashMap, (Appendable)fileWriter);
            }
        }
    }

    private double calculateAverage(ArrayList<Integer> arrayList) {
        Integer n = 0;
        if (!arrayList.isEmpty()) {
            for (Integer n2 : arrayList) {
                n = n + n2;
            }
            return n.doubleValue() / (double)arrayList.size();
        }
        return n.intValue();
    }
}

