/*
 * Decompiled with CFR 0.152.
 */
package tournaments;

import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.ContinuingAI;
import ai.core.InterruptibleAI;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import rts.GameState;
import rts.PartiallyObservableGameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.Trace;
import rts.TraceEntry;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public class FixedOpponentsTournament {
    public static int TIMEOUT_CHECK_TOLERANCE = 20;
    public static boolean USE_CONTINUING_ON_INTERRUPTIBLE = true;

    public static void runTournament(List<AI> list, List<AI> list2, List<String> list3, int n, int n2, int n3, int n4, long l, long l2, boolean bl, boolean bl2, boolean bl3, boolean bl4, UnitTypeTable unitTypeTable, String string, Writer writer, Writer writer2, String string2) throws Exception {
        int n5;
        int n6;
        if (writer2 != null) {
            writer2.write("FixedOpponentsTournament: Starting tournament\n");
        }
        int[][] nArray = new int[list.size()][list2.size()];
        int[][] nArray2 = new int[list.size()][list2.size()];
        int[][] nArray3 = new int[list.size()][list2.size()];
        int[][] nArray4 = new int[list2.size()][list2.size()];
        int[][] nArray5 = new int[list.size()][list2.size()];
        int[][] nArray6 = new int[list.size()][list2.size()];
        double[][] dArray = new double[list.size()][list2.size()];
        writer.write("FixedOpponentsTournament\n");
        writer.write("AIs\n");
        for (n6 = 0; n6 < list.size(); ++n6) {
            writer.write("\t" + list.get(n6).toString() + "\n");
        }
        writer.write("opponent AIs\n");
        for (n6 = 0; n6 < list2.size(); ++n6) {
            writer.write("\t" + list2.get(n6).toString() + "\n");
        }
        writer.write("maps\n");
        for (n6 = 0; n6 < list3.size(); ++n6) {
            writer.write("\t" + list3.get(n6) + "\n");
        }
        writer.write("iterations\t" + n + "\n");
        writer.write("maxGameLength\t" + n2 + "\n");
        writer.write("timeBudget\t" + n3 + "\n");
        writer.write("iterationsBudget\t" + n4 + "\n");
        writer.write("fullObservability\t" + bl + "\n");
        writer.write("timeoutCheck\t" + bl2 + "\n");
        writer.write("runGC\t" + bl3 + "\n");
        writer.write("iteration\tmap\tai1\tai2\ttime\twinner\tcrashed\ttimedout\n");
        writer.flush();
        String[] stringArray = new String[list.size()];
        boolean[][] blArray = new boolean[list.size()][list3.size()];
        for (n5 = 0; n5 < list.size(); ++n5) {
            stringArray[n5] = string2 + "/AI" + n5 + "readWriteFolder";
            File file = new File(stringArray[n5]);
            file.mkdir();
            for (int j = 0; j < list3.size(); ++j) {
                blArray[n5][j] = true;
            }
        }
        for (n5 = 0; n5 < n; ++n5) {
            for (int j = 0; j < list3.size(); ++j) {
                PhysicalGameState physicalGameState = PhysicalGameState.load(list3.get(j), unitTypeTable);
                for (int k = 0; k < list.size(); ++k) {
                    int n7 = 0;
                    while (n7 < list2.size()) {
                        Object object;
                        Object object2;
                        int n8 = 0;
                        int n9 = 0;
                        double d = 0.0;
                        double d2 = 0.0;
                        int n10 = 0;
                        int n11 = 0;
                        double d3 = 0.0;
                        double d4 = 0.0;
                        int n12 = 0;
                        int n13 = 0;
                        double d5 = 0.0;
                        double d6 = 0.0;
                        AI aI = list.get(k).clone();
                        AI aI2 = list2.get(n7).clone();
                        if (aI instanceof AIWithComputationBudget) {
                            ((AIWithComputationBudget)aI).setTimeBudget(n3);
                            ((AIWithComputationBudget)aI).setIterationsBudget(n4);
                        }
                        if (aI2 instanceof AIWithComputationBudget) {
                            ((AIWithComputationBudget)aI2).setTimeBudget(n3);
                            ((AIWithComputationBudget)aI2).setIterationsBudget(n4);
                        }
                        if (USE_CONTINUING_ON_INTERRUPTIBLE) {
                            if (aI instanceof InterruptibleAI) {
                                aI = new ContinuingAI(aI);
                            }
                            if (aI2 instanceof InterruptibleAI) {
                                aI2 = new ContinuingAI(aI2);
                            }
                        }
                        aI.reset();
                        aI2.reset();
                        GameState gameState = new GameState(physicalGameState.clone(), unitTypeTable);
                        if (writer2 != null) {
                            writer2.write("MATCH UP: " + aI + " vs " + aI2 + "\n");
                        }
                        if (bl4) {
                            long l3 = l2;
                            if (blArray[k][j]) {
                                l3 = l;
                                blArray[k][j] = false;
                            }
                            long l4 = System.currentTimeMillis();
                            aI.preGameAnalysis(gameState, l2, stringArray[k]);
                            long l5 = System.currentTimeMillis();
                            if (writer2 != null) {
                                writer2.write("preGameAnalysis player 1 took " + (l5 - l4) + "\n");
                                if (l5 - l4 > l3) {
                                    writer2.write("TIMEOUT PLAYER 1!\n");
                                }
                            }
                            long l6 = l2;
                            if (blArray[n7][j]) {
                                l6 = l;
                                blArray[n7][j] = false;
                            }
                            long l7 = System.currentTimeMillis();
                            aI2.preGameAnalysis(gameState, l6, stringArray[n7]);
                            long l8 = System.currentTimeMillis();
                            if (writer2 != null) {
                                writer2.write("preGameAnalysis player 2 took " + (l8 - l7) + "\n");
                                if (l8 - l7 > l6) {
                                    writer2.write("TIMEOUT PLAYER 2!\n");
                                }
                            }
                        }
                        boolean bl5 = false;
                        int n14 = -1;
                        int n15 = -1;
                        Trace trace = null;
                        if (string != null) {
                            trace = new Trace(unitTypeTable);
                            TraceEntry traceEntry = new TraceEntry(gameState.getPhysicalGameState().clone(), gameState.getTime());
                            trace.addEntry(traceEntry);
                        }
                        do {
                            long l9;
                            long l10;
                            long l11;
                            long l12;
                            block77: {
                                PartiallyObservableGameState partiallyObservableGameState;
                                object2 = null;
                                object = null;
                                l12 = 0L;
                                l11 = 0L;
                                l10 = 0L;
                                l9 = 0L;
                                if (bl) {
                                    if (bl3) {
                                        System.gc();
                                    }
                                    try {
                                        l12 = System.currentTimeMillis();
                                        object2 = aI.getAction(0, gameState);
                                        l10 = System.currentTimeMillis();
                                    }
                                    catch (Exception exception) {
                                        n14 = 0;
                                        break;
                                    }
                                    if (bl3) {
                                        System.gc();
                                    }
                                    try {
                                        l11 = System.currentTimeMillis();
                                        object = aI2.getAction(1, gameState);
                                        l9 = System.currentTimeMillis();
                                        break block77;
                                    }
                                    catch (Exception exception) {
                                        n14 = 1;
                                        break;
                                    }
                                }
                                if (bl3) {
                                    System.gc();
                                }
                                try {
                                    partiallyObservableGameState = new PartiallyObservableGameState(gameState, 0);
                                    l12 = System.currentTimeMillis();
                                    object2 = aI.getAction(0, partiallyObservableGameState);
                                    l10 = System.currentTimeMillis();
                                }
                                catch (Exception exception) {
                                    n14 = 0;
                                    break;
                                }
                                if (bl3) {
                                    System.gc();
                                }
                                try {
                                    partiallyObservableGameState = new PartiallyObservableGameState(gameState, 1);
                                    l11 = System.currentTimeMillis();
                                    object = aI2.getAction(1, partiallyObservableGameState);
                                    l9 = System.currentTimeMillis();
                                }
                                catch (Exception exception) {
                                    n14 = 1;
                                    break;
                                }
                            }
                            long l13 = l10 - l12;
                            long l14 = l9 - l11;
                            ++n8;
                            ++n9;
                            d += (double)l13;
                            d2 += (double)l14;
                            if (l13 > (long)n3) {
                                ++n10;
                                d3 += (double)l13;
                                if (l13 > (long)(n3 * 2)) {
                                    ++n12;
                                    d5 += (double)l13;
                                }
                            }
                            if (l14 > (long)n3) {
                                ++n11;
                                d4 += (double)l14;
                                if (l14 > (long)(n3 * 2)) {
                                    ++n13;
                                    d6 += (double)l14;
                                }
                            }
                            if (bl2) {
                                if (l13 > (long)(n3 + TIMEOUT_CHECK_TOLERANCE)) {
                                    n15 = 0;
                                    break;
                                }
                                if (l14 > (long)(n3 + TIMEOUT_CHECK_TOLERANCE)) {
                                    n15 = 1;
                                    break;
                                }
                            }
                            if (!(string == null || ((PlayerAction)object2).isEmpty() && ((PlayerAction)object).isEmpty())) {
                                TraceEntry traceEntry = new TraceEntry(gameState.getPhysicalGameState().clone(), gameState.getTime());
                                traceEntry.addPlayerAction(((PlayerAction)object2).clone());
                                traceEntry.addPlayerAction(((PlayerAction)object).clone());
                                trace.addEntry(traceEntry);
                            }
                            gameState.issueSafe((PlayerAction)object2);
                            gameState.issueSafe((PlayerAction)object);
                        } while (!(bl5 = gameState.cycle()) && gameState.getTime() < n2);
                        if (string != null) {
                            object2 = new File(string);
                            if (!((File)object2).exists()) {
                                ((File)object2).mkdirs();
                            }
                            TraceEntry traceEntry = new TraceEntry(gameState.getPhysicalGameState().clone(), gameState.getTime());
                            trace.addEntry(traceEntry);
                            ZipOutputStream zipOutputStream = null;
                            String string3 = k + "-vs-" + n7 + "-" + j + "-" + n5;
                            string3 = string3.replace("/", "");
                            string3 = string3.replace(")", "");
                            string3 = string3.replace("(", "");
                            string3 = string + "/" + string3;
                            zipOutputStream = new ZipOutputStream(new FileOutputStream(string3 + ".zip"));
                            zipOutputStream.putNextEntry(new ZipEntry("game.xml"));
                            object = new XMLWriter(new OutputStreamWriter(zipOutputStream));
                            trace.toxml((XMLWriter)object);
                            ((XMLWriter)object).flush();
                            zipOutputStream.closeEntry();
                            zipOutputStream.close();
                        }
                        int n16 = -1;
                        if (n14 != -1) {
                            n16 = 1 - n14;
                            if (n14 == 0) {
                                int[] nArray7 = nArray3[k];
                                int n17 = n7;
                                nArray7[n17] = nArray7[n17] + 1;
                            }
                            if (n14 == 1) {
                                int[] nArray8 = nArray4[k];
                                int n18 = n7;
                                nArray8[n18] = nArray8[n18] + 1;
                            }
                        } else if (n15 != -1) {
                            n16 = 1 - n15;
                            if (n15 == 0) {
                                int[] nArray9 = nArray5[k];
                                int n19 = n7;
                                nArray9[n19] = nArray9[n19] + 1;
                            }
                            if (n15 == 1) {
                                int[] nArray10 = nArray6[k];
                                int n20 = n7;
                                nArray10[n20] = nArray10[n20] + 1;
                            }
                        } else {
                            n16 = gameState.winner();
                        }
                        aI.gameOver(n16);
                        aI2.gameOver(n16);
                        writer.write(n5 + "\t" + j + "\t" + k + "\t" + n7 + "\t" + gameState.getTime() + "\t" + n16 + "\t" + n14 + "\t" + n15 + "\n");
                        writer.flush();
                        if (writer2 != null) {
                            writer2.write("Winner: " + n16 + "  in " + gameState.getTime() + " cycles\n");
                            writer2.write(aI + " : " + aI.statisticsString() + "\n");
                            writer2.write(aI2 + " : " + aI2.statisticsString() + "\n");
                            writer2.write("AI1 time usage, average:  " + d / (double)n8 + ", # times over budget: " + n10 + " (avg " + d3 / (double)n10 + ") , # times over 2*budget: " + n12 + " (avg " + d5 / (double)n12 + ")\n");
                            writer2.write("AI2 time usage, average:  " + d2 / (double)n9 + ", # times over budget: " + n11 + " (avg " + d4 / (double)n11 + ") , # times over 2*budget: " + n13 + " (avg " + d6 / (double)n13 + ")\n");
                        }
                        writer2.flush();
                        if (n16 == -1) {
                            int[] nArray11 = nArray2[k];
                            int n21 = n7;
                            nArray11[n21] = nArray11[n21] + 1;
                        } else if (n16 == 0) {
                            int[] nArray12 = nArray[k];
                            int n22 = n7;
                            nArray12[n22] = nArray12[n22] + 1;
                        } else if (n16 == 1) {
                            // empty if block
                        }
                        double[] dArray2 = dArray[k];
                        int n23 = n7++;
                        dArray2[n23] = dArray2[n23] + (double)gameState.getTime();
                    }
                }
            }
        }
        writer.write("Wins:\n");
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (int j = 0; j < list2.size(); ++j) {
                writer.write(nArray[n5][j] + "\t");
            }
            writer.write("\n");
        }
        writer.write("Ties:\n");
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (int j = 0; j < list2.size(); ++j) {
                writer.write(nArray2[n5][j] + "\t");
            }
            writer.write("\n");
        }
        writer.write("Average Game Length:\n");
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (int j = 0; j < list2.size(); ++j) {
                writer.write(dArray[n5][j] / (double)(list3.size() * n) + "\t");
            }
            writer.write("\n");
        }
        writer.write("AI crashes:\n");
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (int j = 0; j < list2.size(); ++j) {
                writer.write(nArray3[n5][j] + "\t");
            }
            writer.write("\n");
        }
        writer.write("opponent AI crashes:\n");
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (int j = 0; j < list2.size(); ++j) {
                writer.write(nArray4[n5][j] + "\t");
            }
            writer.write("\n");
        }
        writer.write("AI timeout:\n");
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (int j = 0; j < list2.size(); ++j) {
                writer.write(nArray5[n5][j] + "\t");
            }
            writer.write("\n");
        }
        writer.write("opponent AI timeout:\n");
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (int j = 0; j < list2.size(); ++j) {
                writer.write(nArray6[n5][j] + "\t");
            }
            writer.write("\n");
        }
        writer.flush();
        if (writer2 != null) {
            writer2.write("FixedOpponentsTournament: tournament ended\n");
        }
        writer2.flush();
    }
}

