/*
 * Decompiled with CFR 0.152.
 */
package tournaments;

import ai.core.AIWithComputationBudget;
import java.io.File;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class LoadTournamentAIs {
    public static List<Class> loadTournamentAIsFromFolder(String string) throws Exception {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        File file = new File(string);
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                if (!file2.getName().endsWith(".jar")) continue;
                arrayList.addAll(LoadTournamentAIs.loadTournamentAIsFromJAR(file2.getAbsolutePath()));
            }
        }
        return arrayList;
    }

    public static List<Class> loadTournamentAIsFromJAR(String string) throws Exception {
        ZipEntry zipEntry;
        URLClassLoader uRLClassLoader = URLClassLoader.newInstance(new URL[]{new File(string).toURI().toURL()}, LoadTournamentAIs.class.getClassLoader());
        ArrayList<Class> arrayList = new ArrayList<Class>();
        URL uRL = new File(string).toURI().toURL();
        ZipInputStream zipInputStream = new ZipInputStream(uRL.openStream());
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            Class<?> clazz;
            String string2 = zipEntry.getName();
            if (!string2.endsWith(".class") || Modifier.isAbstract((clazz = uRLClassLoader.loadClass(string2.substring(0, string2.length() - 6).replace('/', '.'))).getModifiers()) || !LoadTournamentAIs.isTournamentAIClass(clazz)) continue;
            arrayList.add(clazz);
        }
        return arrayList;
    }

    public static boolean isTournamentAIClass(Class clazz) {
        if (clazz == AIWithComputationBudget.class) {
            return true;
        }
        if ((clazz = clazz.getSuperclass()) != null) {
            return LoadTournamentAIs.isTournamentAIClass(clazz);
        }
        return false;
    }
}

