/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class CartesianProduct<E> {
    private final List<List<E>> domains = new ArrayList<List<E>>();

    public CartesianProduct(List<Set<E>> list) {
        if (list.size() == 0) {
            throw new IllegalArgumentException("There has to be at least one domain!");
        }
        for (Set<E> set : list) {
            this.domains.add(new ArrayList<E>(set));
        }
    }

    public List<E> element(int n) {
        LinkedList<E> linkedList = new LinkedList<E>();
        for (List<E> list : this.domains) {
            int n2 = list.size();
            int n3 = n % n2;
            n /= n2;
            linkedList.add(list.get(n3));
        }
        if (n > 0) {
            linkedList = null;
        }
        return linkedList;
    }

    public int size() {
        int n = 1;
        for (List<E> list : this.domains) {
            n *= list.size();
        }
        return n;
    }
}

