/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RunnableWithTimeOut {
    public static void runWithTimeout(final Runnable runnable, long l, TimeUnit timeUnit) throws Exception {
        RunnableWithTimeOut.runWithTimeout(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                runnable.run();
                return null;
            }
        }, l, timeUnit);
    }

    public static <T> T runWithTimeout(Callable<T> callable, long l, TimeUnit timeUnit) throws Exception {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<T> future = executorService.submit(callable);
        executorService.shutdown();
        try {
            return future.get(l, timeUnit);
        }
        catch (TimeoutException timeoutException) {
            future.cancel(true);
            throw timeoutException;
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof Exception) {
                throw executionException;
            }
            throw new IllegalStateException(throwable);
        }
    }
}

