/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class Sampler {
    static Random generator = new Random();

    public static int random(double[] dArray) {
        return generator.nextInt(dArray.length);
    }

    public static int random(List<Double> list) {
        return generator.nextInt(list.size());
    }

    public static int max(double[] dArray) throws Exception {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        double d = dArray[0];
        for (int j = 0; j < dArray.length; ++j) {
            double d2 = dArray[j];
            if (d2 == d) {
                linkedList.add(new Integer(j));
                continue;
            }
            if (!(d2 > d)) continue;
            linkedList.clear();
            linkedList.add(new Integer(j));
            d = d2;
        }
        if (linkedList.size() > 0) {
            return (Integer)linkedList.get(generator.nextInt(linkedList.size()));
        }
        throw new Exception("Input distribution empty in Sampler.max!");
    }

    public static int max(List<Double> list) throws Exception {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        double d = list.get(0);
        for (int j = 0; j < list.size(); ++j) {
            double d2 = list.get(j);
            if (d2 == d) {
                linkedList.add(new Integer(j));
                continue;
            }
            if (!(d2 > d)) continue;
            linkedList.clear();
            linkedList.add(new Integer(j));
            d = d2;
        }
        if (linkedList.size() > 0) {
            return (Integer)linkedList.get(generator.nextInt(linkedList.size()));
        }
        throw new Exception("Input distribution empty in Sampler.max!");
    }

    public static Double maxScore(double[] dArray) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        double d = dArray[0];
        for (int j = 0; j < dArray.length; ++j) {
            double d2 = dArray[j];
            if (d2 == d) {
                linkedList.add(new Integer(j));
                continue;
            }
            if (!(d2 > d)) continue;
            linkedList.clear();
            linkedList.add(new Integer(j));
            d = d2;
        }
        return d;
    }

    public static int weighted(double[] dArray) throws Exception {
        double d = 0.0;
        double d2 = 0.0;
        for (double d3 : dArray) {
            d += d3;
        }
        if (d == 0.0) {
            return Sampler.random(dArray);
        }
        double d4 = generator.nextDouble() * d;
        for (int j = 0; j < dArray.length; ++j) {
            if (!((d2 += dArray[j]) >= d4)) continue;
            return j;
        }
        throw new Exception("Input distribution empty in Sampler.weighted!");
    }

    public static Object weighted(List<Double> list, List<? extends Object> list2) throws Exception {
        double d = 0.0;
        double d2 = 0.0;
        for (double d3 : list) {
            d += d3;
        }
        if (d == 0.0) {
            return list2.get(generator.nextInt(list2.size()));
        }
        double d4 = generator.nextDouble() * d;
        for (int j = 0; j < list.size(); ++j) {
            if (!((d2 += list.get(j).doubleValue()) >= d4)) continue;
            return list2.get(j);
        }
        throw new Exception("Input distribution empty in Sampler.weighted!");
    }

    public static int explorationWeighted(double[] dArray, double d) throws Exception {
        double d2 = 0.0;
        double d3 = 1.0 - d;
        d2 = d3 != 0.0 ? 1.0 / d3 - 1.0 : 1000.0;
        double[] dArray2 = new double[dArray.length];
        for (int j = 0; j < dArray.length; ++j) {
            dArray2[j] = Math.pow(dArray[j], d2);
        }
        return Sampler.weighted(dArray2);
    }

    public static int eGreedy(List<Double> list, double d) throws Exception {
        if (generator.nextDouble() < d) {
            return Sampler.random(list);
        }
        return Sampler.max(list);
    }
}

