/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.io.Writer;

public class XMLWriter {
    private static final int tabsize = 2;
    private String lineSeparator = "\n";
    private int spaces;
    private Writer writer;

    public XMLWriter(Writer writer) {
        this.writer = writer;
        this.spaces = 0;
    }

    public XMLWriter(Writer writer, String string) {
        this.writer = writer;
        this.lineSeparator = string;
        this.spaces = 0;
    }

    public void resetTab() {
        this.spaces = 0;
    }

    public void tab() {
        this.spaces += 2;
    }

    private void untab() {
        this.spaces -= 2;
    }

    private void indent() {
        for (int j = 0; j < this.spaces; ++j) {
            try {
                this.writer.write(" ");
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void setTab(int n) {
        if (n >= 0) {
            this.spaces += n * 2;
        }
    }

    public void tag(String string, Object object) {
        this.tag(string, object.toString());
    }

    public void tag(String string, String string2) {
        this.indent();
        try {
            this.writer.write("<" + string + ">" + string2 + "</" + string + ">" + this.lineSeparator);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void tag(String string, int n) {
        this.tag(string, "" + n);
    }

    public void tag(String string, long l) {
        this.tag(string, "" + l);
    }

    public void tag(String string, double d) {
        this.tag(string, "" + d);
    }

    public void tag(String string) {
        if (string.charAt(0) == '/') {
            this.untab();
        }
        this.indent();
        try {
            this.writer.write("<" + string + ">" + this.lineSeparator);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (string.charAt(0) != '/') {
            this.tab();
        }
    }

    public void tagWithAttributes(String string, String string2) {
        if (string.charAt(0) == '/') {
            this.untab();
        }
        this.indent();
        try {
            this.writer.write("<" + string + " " + string2 + ">" + this.lineSeparator);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (string.charAt(0) != '/') {
            this.tab();
        }
    }

    public void rawXML(String string) {
        try {
            this.writer.write(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public Writer getWriter() {
        return this.writer;
    }
}

