/*
 * Decompiled with CFR 0.152.
 */
package weka;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import weka.associations.AbstractAssociator;
import weka.associations.Associator;
import weka.attributeSelection.ASEvaluation;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.clusterers.AbstractClusterer;
import weka.clusterers.Clusterer;
import weka.core.ClassDiscovery;
import weka.core.CommandlineRunnable;
import weka.core.Utils;
import weka.core.WekaPackageClassLoaderManager;
import weka.core.WekaPackageManager;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.AbstractFileSaver;
import weka.datagenerators.DataGenerator;
import weka.filters.Filter;

public class Run {
    public static List<String> findSchemeMatch(Class<?> classType, String schemeToFind, boolean matchAnywhere, boolean notJustRunnables) {
        ClassDiscovery.clearCache();
        ArrayList<String> matches = ClassDiscovery.find(schemeToFind);
        ArrayList<String> prunedMatches = new ArrayList<String>();
        for (int i2 = 0; i2 < matches.size(); ++i2) {
            if (!matches.get(i2).endsWith(schemeToFind) && !matchAnywhere) continue;
            try {
                Object scheme = WekaPackageClassLoaderManager.objectForName(matches.get(i2));
                if (classType != null && !classType.isAssignableFrom(scheme.getClass()) || !notJustRunnables && !(scheme instanceof Classifier) && !(scheme instanceof Clusterer) && !(scheme instanceof Associator) && !(scheme instanceof ASEvaluation) && !(scheme instanceof Filter) && !(scheme instanceof AbstractFileLoader) && !(scheme instanceof AbstractFileSaver) && !(scheme instanceof DataGenerator) && !(scheme instanceof CommandlineRunnable)) continue;
                prunedMatches.add(matches.get(i2));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return prunedMatches;
    }

    public static List<String> findSchemeMatch(String schemeToFind, boolean matchAnywhere) {
        return Run.findSchemeMatch(null, schemeToFind, matchAnywhere, false);
    }

    public static void main(String[] args) {
        System.setProperty("apple.awt.UIElement", "true");
        try {
            if (args.length == 0 || args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("-help")) {
                System.err.println("Usage:\n\tweka.Run [-no-scan] [-no-load] [-match-anywhere] <scheme name [scheme options]>");
                return;
            }
            boolean noScan = false;
            boolean noLoad = false;
            boolean matchAnywhere = false;
            boolean dontPromptIfMultipleMatches = false;
            if (Utils.getFlag("list-packages", args)) {
                WekaPackageManager.loadPackages(true, true, false);
                return;
            }
            int schemeIndex = 0;
            if (Utils.getFlag("no-load", args)) {
                noLoad = true;
                ++schemeIndex;
            }
            if (Utils.getFlag("no-scan", args)) {
                noScan = true;
                ++schemeIndex;
            }
            if (Utils.getFlag("match-anywhere", args)) {
                matchAnywhere = true;
                ++schemeIndex;
            }
            if (Utils.getFlag("do-not-prompt-if-multiple-matches", args)) {
                dontPromptIfMultipleMatches = true;
                ++schemeIndex;
            }
            if (!noLoad) {
                WekaPackageManager.loadPackages(false, true, false);
            }
            String schemeToRun = null;
            String[] options = null;
            if (schemeIndex >= args.length) {
                System.err.println("No scheme name given.");
                return;
            }
            schemeToRun = args[schemeIndex];
            options = new String[args.length - schemeIndex - 1];
            if (options.length > 0) {
                System.arraycopy(args, schemeIndex + 1, options, 0, options.length);
            }
            if (!noScan) {
                List<String> prunedMatches = Run.findSchemeMatch(schemeToRun, matchAnywhere);
                if (prunedMatches.size() == 0) {
                    System.err.println("Can't find scheme " + schemeToRun + ", or it is not runnable.");
                    return;
                }
                if (prunedMatches.size() > 1) {
                    if (dontPromptIfMultipleMatches) {
                        System.out.println("There are multiple matches:");
                        for (int i2 = 0; i2 < prunedMatches.size(); ++i2) {
                            System.out.println("\t" + (i2 + 1) + ") " + prunedMatches.get(i2));
                        }
                        System.out.println("\nPlease make your scheme name more specific (i.e. qualify it with more of the package name).");
                        return;
                    }
                    BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                    boolean done = false;
                    while (!done) {
                        System.out.println("Select a scheme to run, or <return> to exit:");
                        for (int i3 = 0; i3 < prunedMatches.size(); ++i3) {
                            System.out.println("\t" + (i3 + 1) + ") " + prunedMatches.get(i3));
                        }
                        System.out.print("\nEnter a number > ");
                        String choice = null;
                        int schemeNumber = 0;
                        try {
                            choice = br.readLine();
                            if (choice.equals("")) {
                                return;
                            }
                            schemeNumber = Integer.parseInt(choice);
                            if (--schemeNumber < 0 || schemeNumber >= prunedMatches.size()) continue;
                            schemeToRun = prunedMatches.get(schemeNumber);
                            done = true;
                        }
                        catch (IOException iOException) {}
                    }
                } else {
                    schemeToRun = prunedMatches.get(0);
                }
            }
            Object scheme = null;
            try {
                scheme = WekaPackageClassLoaderManager.objectForName(schemeToRun);
            }
            catch (Exception ex) {
                System.err.println(schemeToRun + " is not runnable!\n" + ex.getMessage());
                return;
            }
            ArrayList<SchemeType> types = new ArrayList<SchemeType>();
            if (scheme instanceof CommandlineRunnable) {
                types.add(SchemeType.COMMANDLINE);
            } else {
                if (scheme instanceof Classifier) {
                    types.add(SchemeType.CLASSIFIER);
                }
                if (scheme instanceof Clusterer) {
                    types.add(SchemeType.CLUSTERER);
                }
                if (scheme instanceof Associator) {
                    types.add(SchemeType.ASSOCIATOR);
                }
                if (scheme instanceof ASEvaluation) {
                    types.add(SchemeType.ATTRIBUTE_SELECTION);
                }
                if (scheme instanceof Filter) {
                    types.add(SchemeType.FILTER);
                }
                if (scheme instanceof AbstractFileLoader) {
                    types.add(SchemeType.LOADER);
                }
                if (scheme instanceof AbstractFileSaver) {
                    types.add(SchemeType.SAVER);
                }
                if (scheme instanceof DataGenerator) {
                    types.add(SchemeType.DATAGENERATOR);
                }
            }
            SchemeType selectedType = null;
            if (types.size() == 0) {
                System.err.println("" + schemeToRun + " is not runnable!");
                return;
            }
            if (types.size() == 1) {
                selectedType = (SchemeType)((Object)types.get(0));
            } else {
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                boolean done = false;
                while (!done) {
                    System.out.println("" + schemeToRun + " can be executed as any of the following:");
                    for (int i4 = 0; i4 < types.size(); ++i4) {
                        System.out.println("\t" + (i4 + 1) + ") " + types.get(i4));
                    }
                    System.out.print("\nEnter a number > ");
                    String choice = null;
                    int typeNumber = 0;
                    try {
                        choice = br.readLine();
                        if (choice.equals("")) {
                            return;
                        }
                        typeNumber = Integer.parseInt(choice);
                        if (--typeNumber < 0 || typeNumber >= types.size()) continue;
                        selectedType = (SchemeType)((Object)types.get(typeNumber));
                        done = true;
                    }
                    catch (IOException iOException) {}
                }
            }
            if (selectedType == SchemeType.CLASSIFIER) {
                AbstractClassifier.runClassifier((Classifier)scheme, options);
            } else if (selectedType == SchemeType.CLUSTERER) {
                AbstractClusterer.runClusterer((Clusterer)scheme, options);
            } else if (selectedType == SchemeType.ATTRIBUTE_SELECTION) {
                ASEvaluation.runEvaluator((ASEvaluation)scheme, options);
            } else if (selectedType == SchemeType.ASSOCIATOR) {
                AbstractAssociator.runAssociator((Associator)scheme, options);
            } else if (selectedType == SchemeType.FILTER) {
                Filter.runFilter((Filter)scheme, options);
            } else if (selectedType == SchemeType.LOADER) {
                AbstractFileLoader.runFileLoader((AbstractFileLoader)scheme, options);
            } else if (selectedType == SchemeType.SAVER) {
                AbstractFileSaver.runFileSaver((AbstractFileSaver)scheme, options);
            } else if (selectedType == SchemeType.DATAGENERATOR) {
                DataGenerator.runDataGenerator((DataGenerator)scheme, options);
            } else if (selectedType == SchemeType.COMMANDLINE) {
                ((CommandlineRunnable)scheme).run(scheme, options);
            }
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().indexOf("General options") == -1 || e.getMessage() == null) {
                e.printStackTrace();
            }
            System.err.println(e.getMessage());
        }
    }

    public static enum SchemeType {
        CLASSIFIER("classifier"),
        CLUSTERER("clusterer"),
        ASSOCIATOR("association rules"),
        ATTRIBUTE_SELECTION("attribute selection"),
        FILTER("filter"),
        LOADER("loader"),
        SAVER("saver"),
        DATAGENERATOR("data generator"),
        COMMANDLINE("general commandline runnable");

        private final String m_stringVal;

        private SchemeType(String name) {
            this.m_stringVal = name;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }
}

