/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.util.ArrayList;
import java.util.Collection;
import weka.associations.Item;

public abstract class AssociationRule
implements Comparable<AssociationRule> {
    public abstract Collection<Item> getPremise();

    public abstract Collection<Item> getConsequence();

    public abstract String getPrimaryMetricName();

    public abstract double getPrimaryMetricValue();

    public abstract double getNamedMetricValue(String var1) throws Exception;

    public abstract int getNumberOfMetricsForRule();

    public abstract String[] getMetricNamesForRule();

    public abstract double[] getMetricValuesForRule() throws Exception;

    public abstract int getPremiseSupport();

    public abstract int getConsequenceSupport();

    public abstract int getTotalSupport();

    public abstract int getTotalTransactions();

    @Override
    public int compareTo(AssociationRule other) {
        return -Double.compare(this.getPrimaryMetricValue(), other.getPrimaryMetricValue());
    }

    public boolean equals(Object other) {
        if (!(other instanceof AssociationRule)) {
            return false;
        }
        AssociationRule otherRule = (AssociationRule)other;
        boolean result = this.getPremise().equals(otherRule.getPremise()) && this.getConsequence().equals(otherRule.getConsequence()) && this.getPrimaryMetricValue() == otherRule.getPrimaryMetricValue();
        return result;
    }

    public boolean containsItems(ArrayList<Item> items, boolean useOr) {
        int numItems = items.size();
        int count = 0;
        for (Item i2 : this.getPremise()) {
            if (!items.contains(i2)) continue;
            if (useOr) {
                return true;
            }
            ++count;
        }
        for (Item i2 : this.getConsequence()) {
            if (!items.contains(i2)) continue;
            if (useOr) {
                return true;
            }
            ++count;
        }
        return !useOr && count == numItems;
    }
}

