/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.WekaEnumeration;

public class ItemSet
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = 2724000045282835791L;
    protected int[] m_items;
    protected int m_counter;
    protected int m_secondaryCounter;
    protected int m_totalTransactions;

    public ItemSet(int totalTrans) {
        this.m_totalTransactions = totalTrans;
    }

    public ItemSet(int totalTrans, int[] array) {
        this.m_totalTransactions = totalTrans;
        this.m_items = array;
        this.m_counter = 1;
    }

    public ItemSet(int[] array) {
        this.m_items = array;
        this.m_counter = 0;
    }

    public boolean containedByTreatZeroAsMissing(Instance instance) {
        if (instance instanceof SparseInstance) {
            int numInstVals = instance.numValues();
            int numItemSetVals = this.m_items.length;
            int p1 = 0;
            int p2 = 0;
            while (p1 < numInstVals || p2 < numItemSetVals) {
                int itemIndex;
                int instIndex = Integer.MAX_VALUE;
                if (p1 < numInstVals) {
                    instIndex = instance.index(p1);
                }
                if (this.m_items[itemIndex = p2++] > -1) {
                    if (itemIndex != instIndex) {
                        return false;
                    }
                    if (instance.isMissingSparse(p1)) {
                        return false;
                    }
                    if (this.m_items[itemIndex] != (int)instance.valueSparse(p1)) {
                        return false;
                    }
                    ++p1;
                    continue;
                }
                if (itemIndex < instIndex) {
                    ++p2;
                    continue;
                }
                if (itemIndex != instIndex) continue;
                ++p2;
                ++p1;
            }
        } else {
            for (int i2 = 0; i2 < instance.numAttributes(); ++i2) {
                if (this.m_items[i2] <= -1) continue;
                if (instance.isMissing(i2) || (int)instance.value(i2) == 0) {
                    return false;
                }
                if (this.m_items[i2] == (int)instance.value(i2)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean containedBy(Instance instance) {
        for (int i2 = 0; i2 < instance.numAttributes(); ++i2) {
            if (this.m_items[i2] <= -1) continue;
            if (instance.isMissing(i2)) {
                return false;
            }
            if (this.m_items[i2] == (int)instance.value(i2)) continue;
            return false;
        }
        return true;
    }

    public static ArrayList<Object> deleteItemSets(ArrayList<Object> itemSets, int minSupport, int maxSupport) {
        ArrayList<Object> newVector = new ArrayList<Object>(itemSets.size());
        for (int i2 = 0; i2 < itemSets.size(); ++i2) {
            ItemSet current = (ItemSet)itemSets.get(i2);
            if (current.m_counter < minSupport || current.m_counter > maxSupport) continue;
            newVector.add(current);
        }
        return newVector;
    }

    public boolean equals(Object itemSet) {
        if (itemSet == null || !itemSet.getClass().equals(this.getClass())) {
            return false;
        }
        if (this.m_items.length != ((ItemSet)itemSet).m_items.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.m_items.length; ++i2) {
            if (this.m_items[i2] == ((ItemSet)itemSet).m_items[i2]) continue;
            return false;
        }
        return true;
    }

    public static Hashtable<ItemSet, Integer> getHashtable(ArrayList<Object> itemSets, int initialSize) {
        Hashtable<ItemSet, Integer> hashtable = new Hashtable<ItemSet, Integer>(initialSize);
        for (int i2 = 0; i2 < itemSets.size(); ++i2) {
            ItemSet current = (ItemSet)itemSets.get(i2);
            hashtable.put(current, new Integer(current.m_counter));
        }
        return hashtable;
    }

    public int hashCode() {
        long result = 0L;
        for (int i2 = this.m_items.length - 1; i2 >= 0; --i2) {
            result += (long)(i2 * this.m_items[i2]);
        }
        return (int)result;
    }

    public static ArrayList<Object> mergeAllItemSets(ArrayList<Object> itemSets, int size, int totalTrans) {
        ArrayList<Object> newVector = new ArrayList<Object>();
        block0: for (int i2 = 0; i2 < itemSets.size(); ++i2) {
            ItemSet first = (ItemSet)itemSets.get(i2);
            for (int j = i2 + 1; j < itemSets.size(); ++j) {
                ItemSet second = (ItemSet)itemSets.get(j);
                ItemSet result = new ItemSet(totalTrans);
                result.m_items = new int[first.m_items.length];
                int numFound = 0;
                int k = 0;
                while (numFound < size) {
                    if (first.m_items[k] != second.m_items[k]) continue block0;
                    if (first.m_items[k] != -1) {
                        ++numFound;
                    }
                    result.m_items[k] = first.m_items[k];
                    ++k;
                }
                while (k < first.m_items.length && (first.m_items[k] == -1 || second.m_items[k] == -1)) {
                    result.m_items[k] = first.m_items[k] != -1 ? first.m_items[k] : second.m_items[k];
                    ++k;
                }
                if (k != first.m_items.length) continue;
                result.m_counter = 0;
                newVector.add(result);
            }
        }
        return newVector;
    }

    public static ArrayList<Object> pruneItemSets(ArrayList<Object> toPrune, Hashtable<ItemSet, Integer> kMinusOne) {
        ArrayList<Object> newVector = new ArrayList<Object>(toPrune.size());
        for (int i2 = 0; i2 < toPrune.size(); ++i2) {
            int j;
            ItemSet current = (ItemSet)toPrune.get(i2);
            for (j = 0; j < current.m_items.length; ++j) {
                if (current.m_items[j] == -1) continue;
                int help = current.m_items[j];
                current.m_items[j] = -1;
                if (kMinusOne.get(current) == null) {
                    current.m_items[j] = help;
                    break;
                }
                current.m_items[j] = help;
            }
            if (j != current.m_items.length) continue;
            newVector.add(current);
        }
        return newVector;
    }

    public static void pruneRules(ArrayList<Object>[] rules, double minConfidence) {
        ArrayList<Object> newPremises = new ArrayList<Object>(rules[0].size());
        ArrayList<Object> newConsequences = new ArrayList<Object>(rules[1].size());
        ArrayList<Object> newConf = new ArrayList<Object>(rules[2].size());
        ArrayList<Object> newLift = null;
        ArrayList<Object> newLev = null;
        ArrayList<Object> newConv = null;
        if (rules.length > 3) {
            newLift = new ArrayList<Object>(rules[3].size());
            newLev = new ArrayList<Object>(rules[4].size());
            newConv = new ArrayList<Object>(rules[5].size());
        }
        for (int i2 = 0; i2 < rules[0].size(); ++i2) {
            if ((Double)rules[2].get(i2) < minConfidence) continue;
            newPremises.add(rules[0].get(i2));
            newConsequences.add(rules[1].get(i2));
            newConf.add(rules[2].get(i2));
            if (rules.length <= 3) continue;
            newLift.add(rules[3].get(i2));
            newLev.add(rules[4].get(i2));
            newConv.add(rules[5].get(i2));
        }
        rules[0] = newPremises;
        rules[1] = newConsequences;
        rules[2] = newConf;
        if (rules.length > 3) {
            rules[3] = newLift;
            rules[4] = newLev;
            rules[5] = newConv;
        }
    }

    public static ArrayList<Object> singletons(Instances instances) throws Exception {
        ArrayList<Object> setOfItemSets = new ArrayList<Object>();
        for (int i2 = 0; i2 < instances.numAttributes(); ++i2) {
            if (instances.attribute(i2).isNumeric()) {
                throw new Exception("Can't handle numeric attributes!");
            }
            int j = 0;
            while (j < instances.attribute(i2).numValues()) {
                ItemSet current = new ItemSet(instances.numInstances());
                current.m_items = new int[instances.numAttributes()];
                for (int k = 0; k < instances.numAttributes(); ++k) {
                    current.m_items[k] = -1;
                }
                current.m_items[i2] = j++;
                setOfItemSets.add(current);
            }
        }
        return setOfItemSets;
    }

    public int support() {
        return this.m_counter;
    }

    public String toString(Instances instances) {
        StringBuffer text = new StringBuffer();
        for (int i2 = 0; i2 < instances.numAttributes(); ++i2) {
            if (this.m_items[i2] == -1) continue;
            text.append(instances.attribute(i2).name() + '=');
            text.append(instances.attribute(i2).value(this.m_items[i2]) + ' ');
        }
        text.append(this.m_counter);
        return text.toString();
    }

    public String toString(Instances instances, char outerDelim, char innerDelim) {
        StringBuffer text = new StringBuffer();
        for (int i2 = 0; i2 < instances.numAttributes(); ++i2) {
            if (this.m_items[i2] == -1) continue;
            text.append(instances.attribute(i2).name()).append('=').append(instances.attribute(i2).value(this.m_items[i2])).append(innerDelim);
        }
        int n = text.length();
        if (n > 0) {
            text.setCharAt(n - 1, outerDelim);
        } else if (outerDelim != ' ' || innerDelim != ' ') {
            text.append(outerDelim);
        }
        text.append(this.m_counter);
        return text.toString();
    }

    public void upDateCounter(Instance instance) {
        if (this.containedBy(instance)) {
            ++this.m_counter;
        }
    }

    public void updateCounterTreatZeroAsMissing(Instance instance) {
        if (this.containedByTreatZeroAsMissing(instance)) {
            ++this.m_counter;
        }
    }

    public static void upDateCounters(ArrayList<Object> itemSets, Instances instances) {
        for (int i2 = 0; i2 < instances.numInstances(); ++i2) {
            WekaEnumeration<Object> enu = new WekaEnumeration<Object>(itemSets);
            while (enu.hasMoreElements()) {
                ((ItemSet)enu.nextElement()).upDateCounter(instances.instance(i2));
            }
        }
    }

    public static void upDateCountersTreatZeroAsMissing(ArrayList<Object> itemSets, Instances instances) {
        for (int i2 = 0; i2 < instances.numInstances(); ++i2) {
            WekaEnumeration<Object> enu = new WekaEnumeration<Object>(itemSets);
            while (enu.hasMoreElements()) {
                ((ItemSet)enu.nextElement()).updateCounterTreatZeroAsMissing(instances.instance(i2));
            }
        }
    }

    public int counter() {
        return this.m_counter;
    }

    public int[] items() {
        return this.m_items;
    }

    public int itemAt(int k) {
        return this.m_items[k];
    }

    public void setCounter(int count) {
        this.m_counter = count;
    }

    public void setItem(int[] items) {
        this.m_items = items;
    }

    public void setItemAt(int value, int k) {
        this.m_items[k] = value;
    }

    public int[] getItems() {
        return this.m_items;
    }

    public int getTotalTransactions() {
        return this.m_totalTransactions;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 13477 $");
    }
}

