/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.SubsetEvaluator;
import weka.core.Capabilities;
import weka.core.ContingencyTables;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.ThreadSafe;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;

public class CfsSubsetEval
extends ASEvaluation
implements SubsetEvaluator,
ThreadSafe,
OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 747878400813276317L;
    private Instances m_trainInstances;
    private Discretize m_disTransform;
    private int m_classIndex;
    private boolean m_isNumeric;
    private int m_numAttribs;
    private int m_numInstances;
    private boolean m_missingSeparate;
    private boolean m_locallyPredictive;
    private float[][] m_corr_matrix;
    private double[] m_std_devs;
    private double m_c_Threshold;
    protected boolean m_debug;
    protected int m_numEntries;
    protected AtomicInteger m_numFilled;
    protected boolean m_preComputeCorrelationMatrix;
    protected int m_numThreads = 1;
    protected int m_poolSize = 1;
    protected transient ExecutorService m_pool = null;

    public String globalInfo() {
        return "CfsSubsetEval :\n\nEvaluates the worth of a subset of attributes by considering the individual predictive ability of each feature along with the degree of redundancy between them.\n\nSubsets of features that are highly correlated with the class while having low intercorrelation are preferred.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.PHDTHESIS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "M. A. Hall");
        result.setValue(TechnicalInformation.Field.YEAR, "1998");
        result.setValue(TechnicalInformation.Field.TITLE, "Correlation-based Feature Subset Selection for Machine Learning");
        result.setValue(TechnicalInformation.Field.SCHOOL, "University of Waikato");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Hamilton, New Zealand");
        return result;
    }

    public CfsSubsetEval() {
        this.resetOptions();
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(6);
        newVector.addElement(new Option("\tTreat missing values as a separate value.", "M", 0, "-M"));
        newVector.addElement(new Option("\tDon't include locally predictive attributes.", "L", 0, "-L"));
        newVector.addElement(new Option("\t" + this.preComputeCorrelationMatrixTipText(), "Z", 0, "-Z"));
        newVector.addElement(new Option("\t" + this.poolSizeTipText() + " (default 1)\n", "P", 1, "-P <int>"));
        newVector.addElement(new Option("\t" + this.numThreadsTipText() + " (default 1)\n", "E", 1, "-E <int>"));
        newVector.addElement(new Option("\tOutput debugging info.", "D", 0, "-D"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        this.setMissingSeparate(Utils.getFlag('M', options));
        this.setLocallyPredictive(!Utils.getFlag('L', options));
        this.setPreComputeCorrelationMatrix(Utils.getFlag('Z', options));
        String PoolSize = Utils.getOption('P', options);
        if (PoolSize.length() != 0) {
            this.setPoolSize(Integer.parseInt(PoolSize));
        } else {
            this.setPoolSize(1);
        }
        String NumThreads = Utils.getOption('E', options);
        if (NumThreads.length() != 0) {
            this.setNumThreads(Integer.parseInt(NumThreads));
        } else {
            this.setNumThreads(1);
        }
        this.setDebug(Utils.getFlag('D', options));
    }

    public String preComputeCorrelationMatrixTipText() {
        return "Precompute the full correlation matrix at the outset, rather than compute correlations lazily (as needed) during the search. Use this in conjuction with parallel processing in order to speed up a backward search.";
    }

    public void setPreComputeCorrelationMatrix(boolean p) {
        this.m_preComputeCorrelationMatrix = p;
    }

    public boolean getPreComputeCorrelationMatrix() {
        return this.m_preComputeCorrelationMatrix;
    }

    public String numThreadsTipText() {
        return "The number of threads to use, which should be >= size of thread pool.";
    }

    public int getNumThreads() {
        return this.m_numThreads;
    }

    public void setNumThreads(int nT) {
        this.m_numThreads = nT;
    }

    public String poolSizeTipText() {
        return "The size of the thread pool, for example, the number of cores in the CPU.";
    }

    public int getPoolSize() {
        return this.m_poolSize;
    }

    public void setPoolSize(int nT) {
        this.m_poolSize = nT;
    }

    public String locallyPredictiveTipText() {
        return "Identify locally predictive attributes. Iteratively adds attributes with the highest correlation with the class as long as there is not already an attribute in the subset that has a higher correlation with the attribute in question";
    }

    public void setLocallyPredictive(boolean b) {
        this.m_locallyPredictive = b;
    }

    public boolean getLocallyPredictive() {
        return this.m_locallyPredictive;
    }

    public String missingSeparateTipText() {
        return "Treat missing as a separate value. Otherwise, counts for missing values are distributed across other values in proportion to their frequency.";
    }

    public void setMissingSeparate(boolean b) {
        this.m_missingSeparate = b;
    }

    public boolean getMissingSeparate() {
        return this.m_missingSeparate;
    }

    public void setDebug(boolean d) {
        this.m_debug = d;
    }

    public boolean getDebug() {
        return this.m_debug;
    }

    public String debugTipText() {
        return "Output debugging info";
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        if (this.getMissingSeparate()) {
            options.add("-M");
        }
        if (!this.getLocallyPredictive()) {
            options.add("-L");
        }
        if (this.getPreComputeCorrelationMatrix()) {
            options.add("-Z");
        }
        options.add("-P");
        options.add("" + this.getPoolSize());
        options.add("-E");
        options.add("" + this.getNumThreads());
        if (this.getDebug()) {
            options.add("-D");
        }
        return options.toArray(new String[0]);
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildEvaluator(Instances data) throws Exception {
        int i2;
        this.getCapabilities().testWithFail(data);
        this.m_numEntries = 0;
        this.m_numFilled = new AtomicInteger();
        this.m_trainInstances = new Instances(data);
        this.m_trainInstances.deleteWithMissingClass();
        this.m_classIndex = this.m_trainInstances.classIndex();
        this.m_numAttribs = this.m_trainInstances.numAttributes();
        this.m_numInstances = this.m_trainInstances.numInstances();
        this.m_isNumeric = this.m_trainInstances.attribute(this.m_classIndex).isNumeric();
        if (!this.m_isNumeric) {
            this.m_disTransform = new Discretize();
            this.m_disTransform.setUseBetterEncoding(true);
            this.m_disTransform.setInputFormat(this.m_trainInstances);
            this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_disTransform);
            if (this.m_debug) {
                System.err.println("Finished discretizing input data");
            }
        }
        this.m_std_devs = new double[this.m_numAttribs];
        this.m_corr_matrix = new float[this.m_numAttribs][];
        for (int i22 = 0; i22 < this.m_numAttribs; ++i22) {
            this.m_corr_matrix[i22] = new float[i22 + 1];
            this.m_numEntries += i22 + 1;
        }
        this.m_numEntries -= this.m_numAttribs;
        for (i2 = 0; i2 < this.m_corr_matrix.length; ++i2) {
            this.m_corr_matrix[i2][i2] = 1.0f;
            this.m_std_devs[i2] = 1.0;
        }
        for (i2 = 0; i2 < this.m_numAttribs; ++i2) {
            for (int j = 0; j < this.m_corr_matrix[i2].length - 1; ++j) {
                this.m_corr_matrix[i2][j] = -999.0f;
            }
        }
        if (this.m_preComputeCorrelationMatrix && this.m_poolSize > 1) {
            this.m_pool = Executors.newFixedThreadPool(this.m_poolSize);
            HashSet<Future<Void>> results = new HashSet<Future<Void>>();
            int numEntriesPerThread = (this.m_numEntries + this.m_numAttribs) / this.m_numThreads;
            numEntriesPerThread = numEntriesPerThread < 1 ? 1 : numEntriesPerThread;
            int startRow = 0;
            int startCol = 0;
            int count = 0;
            for (int i3 = 0; i3 < this.m_corr_matrix.length; ++i3) {
                for (int j = 0; j < this.m_corr_matrix[i3].length; ++j) {
                    if (++count != numEntriesPerThread && (i3 != this.m_corr_matrix.length - 1 || j != this.m_corr_matrix[i3].length - 1)) continue;
                    final int sR = startRow;
                    final int sC = startCol;
                    final int eR = i3;
                    final int eC = j;
                    startRow = i3;
                    startCol = j;
                    count = 0;
                    Future<Void> future = this.m_pool.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            if (CfsSubsetEval.this.m_debug) {
                                System.err.println("Starting correlation computation task...");
                            }
                            for (int i2 = sR; i2 <= eR; ++i2) {
                                for (int j = i2 == sR ? sC : 0; j < (i2 == eR ? eC : CfsSubsetEval.this.m_corr_matrix[i2].length); ++j) {
                                    float corr;
                                    if (CfsSubsetEval.this.m_corr_matrix[i2][j] != -999.0f) continue;
                                    ((CfsSubsetEval)CfsSubsetEval.this).m_corr_matrix[i2][j] = corr = CfsSubsetEval.this.correlate(i2, j);
                                }
                            }
                            if (CfsSubsetEval.this.m_debug) {
                                System.err.println("Percentage of correlation matrix computed: " + Utils.doubleToString((double)CfsSubsetEval.this.m_numFilled.get() / (double)CfsSubsetEval.this.m_numEntries * 100.0, 2) + "%");
                            }
                            return null;
                        }
                    });
                    results.add(future);
                }
            }
            for (Future future : results) {
                future.get();
            }
            this.m_pool.shutdown();
        }
    }

    @Override
    public double evaluateSubset(BitSet subset) throws Exception {
        float corr;
        int i2;
        double num = 0.0;
        double denom = 0.0;
        for (i2 = 0; i2 < this.m_numAttribs; ++i2) {
            int smaller;
            int larger;
            if (i2 == this.m_classIndex || !subset.get(i2)) continue;
            if (i2 > this.m_classIndex) {
                larger = i2;
                smaller = this.m_classIndex;
            } else {
                smaller = i2;
                larger = this.m_classIndex;
            }
            if (this.m_corr_matrix[larger][smaller] == -999.0f) {
                this.m_corr_matrix[larger][smaller] = corr = this.correlate(i2, this.m_classIndex);
                num += this.m_std_devs[i2] * (double)corr;
                continue;
            }
            num += this.m_std_devs[i2] * (double)this.m_corr_matrix[larger][smaller];
        }
        for (i2 = 0; i2 < this.m_numAttribs; ++i2) {
            if (i2 == this.m_classIndex || !subset.get(i2)) continue;
            denom += 1.0 * this.m_std_devs[i2] * this.m_std_devs[i2];
            for (int j = 0; j < this.m_corr_matrix[i2].length - 1; ++j) {
                if (!subset.get(j)) continue;
                if (this.m_corr_matrix[i2][j] == -999.0f) {
                    this.m_corr_matrix[i2][j] = corr = this.correlate(i2, j);
                    denom += 2.0 * this.m_std_devs[i2] * this.m_std_devs[j] * (double)corr;
                    continue;
                }
                denom += 2.0 * this.m_std_devs[i2] * this.m_std_devs[j] * (double)this.m_corr_matrix[i2][j];
            }
        }
        if (denom < 0.0) {
            denom *= -1.0;
        }
        if (denom == 0.0) {
            return 0.0;
        }
        double merit = num / Math.sqrt(denom);
        if (merit < 0.0) {
            merit *= -1.0;
        }
        return merit;
    }

    private float correlate(int att1, int att2) {
        this.m_numFilled.addAndGet(1);
        if (!this.m_isNumeric) {
            return (float)this.symmUncertCorr(att1, att2);
        }
        boolean att1_is_num = this.m_trainInstances.attribute(att1).isNumeric();
        boolean att2_is_num = this.m_trainInstances.attribute(att2).isNumeric();
        if (att1_is_num && att2_is_num) {
            return (float)this.num_num(att1, att2);
        }
        if (att2_is_num) {
            return (float)this.num_nom2(att1, att2);
        }
        if (att1_is_num) {
            return (float)this.num_nom2(att2, att1);
        }
        return (float)this.nom_nom(att1, att2);
    }

    private double symmUncertCorr(int att1, int att2) {
        double corr_measure;
        int j;
        int i2;
        double sum = 0.0;
        boolean flag = false;
        double temp = 0.0;
        if (att1 == this.m_classIndex || att2 == this.m_classIndex) {
            flag = true;
        }
        int ni = this.m_trainInstances.attribute(att1).numValues() + 1;
        int nj = this.m_trainInstances.attribute(att2).numValues() + 1;
        double[][] counts = new double[ni][nj];
        double[] sumi = new double[ni];
        double[] sumj = new double[nj];
        for (i2 = 0; i2 < ni; ++i2) {
            sumi[i2] = 0.0;
            for (j = 0; j < nj; ++j) {
                sumj[j] = 0.0;
                counts[i2][j] = 0.0;
            }
        }
        for (i2 = 0; i2 < this.m_numInstances; ++i2) {
            Instance inst = this.m_trainInstances.instance(i2);
            int ii = inst.isMissing(att1) ? ni - 1 : (int)inst.value(att1);
            int jj = inst.isMissing(att2) ? nj - 1 : (int)inst.value(att2);
            double[] dArray = counts[ii];
            int n = jj;
            dArray[n] = dArray[n] + 1.0;
        }
        for (i2 = 0; i2 < ni; ++i2) {
            sumi[i2] = 0.0;
            for (j = 0; j < nj; ++j) {
                int n = i2;
                sumi[n] = sumi[n] + counts[i2][j];
                sum += counts[i2][j];
            }
        }
        for (j = 0; j < nj; ++j) {
            sumj[j] = 0.0;
            for (i2 = 0; i2 < ni; ++i2) {
                int n = j;
                sumj[n] = sumj[n] + counts[i2][j];
            }
        }
        if (!this.m_missingSeparate && sumi[ni - 1] < (double)this.m_numInstances && sumj[nj - 1] < (double)this.m_numInstances) {
            double[] i_copy = new double[sumi.length];
            double[] j_copy = new double[sumj.length];
            double[][] counts_copy = new double[sumi.length][sumj.length];
            for (i2 = 0; i2 < ni; ++i2) {
                System.arraycopy(counts[i2], 0, counts_copy[i2], 0, sumj.length);
            }
            System.arraycopy(sumi, 0, i_copy, 0, sumi.length);
            System.arraycopy(sumj, 0, j_copy, 0, sumj.length);
            double total_missing = sumi[ni - 1] + sumj[nj - 1] - counts[ni - 1][nj - 1];
            if (sumi[ni - 1] > 0.0) {
                for (j = 0; j < nj - 1; ++j) {
                    if (!(counts[ni - 1][j] > 0.0)) continue;
                    i2 = 0;
                    while (i2 < ni - 1) {
                        temp = i_copy[i2] / (sum - i_copy[ni - 1]) * counts[ni - 1][j];
                        double[] dArray = counts[i2];
                        int n = j;
                        dArray[n] = dArray[n] + temp;
                        int n2 = i2++;
                        sumi[n2] = sumi[n2] + temp;
                    }
                    counts[ni - 1][j] = 0.0;
                }
            }
            sumi[ni - 1] = 0.0;
            if (sumj[nj - 1] > 0.0) {
                for (i2 = 0; i2 < ni - 1; ++i2) {
                    if (!(counts[i2][nj - 1] > 0.0)) continue;
                    j = 0;
                    while (j < nj - 1) {
                        temp = j_copy[j] / (sum - j_copy[nj - 1]) * counts[i2][nj - 1];
                        double[] dArray = counts[i2];
                        int n = j;
                        dArray[n] = dArray[n] + temp;
                        int n3 = j++;
                        sumj[n3] = sumj[n3] + temp;
                    }
                    counts[i2][nj - 1] = 0.0;
                }
            }
            sumj[nj - 1] = 0.0;
            if (counts[ni - 1][nj - 1] > 0.0 && total_missing != sum) {
                for (i2 = 0; i2 < ni - 1; ++i2) {
                    j = 0;
                    while (j < nj - 1) {
                        temp = counts_copy[i2][j] / (sum - total_missing) * counts_copy[ni - 1][nj - 1];
                        double[] dArray = counts[i2];
                        int n = j;
                        dArray[n] = dArray[n] + temp;
                        int n4 = i2;
                        sumi[n4] = sumi[n4] + temp;
                        int n5 = j++;
                        sumj[n5] = sumj[n5] + temp;
                    }
                }
                counts[ni - 1][nj - 1] = 0.0;
            }
        }
        if (Utils.eq(corr_measure = ContingencyTables.symmetricalUncertainty(counts), 0.0)) {
            if (flag) {
                return 0.0;
            }
            return 1.0;
        }
        return corr_measure;
    }

    private double num_num(int att1, int att2) {
        double num = 0.0;
        double sx = 0.0;
        double sy = 0.0;
        double mx = this.m_trainInstances.meanOrMode(this.m_trainInstances.attribute(att1));
        double my = this.m_trainInstances.meanOrMode(this.m_trainInstances.attribute(att2));
        for (int i2 = 0; i2 < this.m_numInstances; ++i2) {
            Instance inst = this.m_trainInstances.instance(i2);
            double diff1 = inst.isMissing(att1) ? 0.0 : inst.value(att1) - mx;
            double diff2 = inst.isMissing(att2) ? 0.0 : inst.value(att2) - my;
            num += diff1 * diff2;
            sx += diff1 * diff1;
            sy += diff2 * diff2;
        }
        if (sx != 0.0 && this.m_std_devs[att1] == 1.0) {
            this.m_std_devs[att1] = Math.sqrt(sx / (double)this.m_numInstances);
        }
        if (sy != 0.0 && this.m_std_devs[att2] == 1.0) {
            this.m_std_devs[att2] = Math.sqrt(sy / (double)this.m_numInstances);
        }
        if (sx * sy > 0.0) {
            double r = num / Math.sqrt(sx * sy);
            return r < 0.0 ? -r : r;
        }
        if (att1 != this.m_classIndex && att2 != this.m_classIndex) {
            return 1.0;
        }
        return 0.0;
    }

    private double num_nom2(int att1, int att2) {
        double temp;
        Instance inst;
        int i2;
        int mx = (int)this.m_trainInstances.meanOrMode(this.m_trainInstances.attribute(att1));
        double my = this.m_trainInstances.meanOrMode(this.m_trainInstances.attribute(att2));
        double stdv_num = 0.0;
        double r = 0.0;
        int nx = !this.m_missingSeparate ? this.m_trainInstances.attribute(att1).numValues() : this.m_trainInstances.attribute(att1).numValues() + 1;
        double[] prior_nom = new double[nx];
        double[] stdvs_nom = new double[nx];
        double[] covs = new double[nx];
        for (i2 = 0; i2 < nx; ++i2) {
            prior_nom[i2] = 0.0;
            covs[i2] = 0.0;
            stdvs_nom[i2] = 0.0;
        }
        for (i2 = 0; i2 < this.m_numInstances; ++i2) {
            inst = this.m_trainInstances.instance(i2);
            int ii = inst.isMissing(att1) ? (!this.m_missingSeparate ? mx : nx - 1) : (int)inst.value(att1);
            int n = ii;
            prior_nom[n] = prior_nom[n] + 1.0;
        }
        for (int k = 0; k < this.m_numInstances; ++k) {
            inst = this.m_trainInstances.instance(k);
            double diff2 = inst.isMissing(att2) ? 0.0 : inst.value(att2) - my;
            stdv_num += diff2 * diff2;
            i2 = 0;
            while (i2 < nx) {
                temp = inst.isMissing(att1) ? (!this.m_missingSeparate ? (i2 == mx ? 1.0 : 0.0) : (i2 == nx - 1 ? 1.0 : 0.0)) : ((double)i2 == inst.value(att1) ? 1.0 : 0.0);
                double diff1 = temp - prior_nom[i2] / (double)this.m_numInstances;
                int n = i2;
                stdvs_nom[n] = stdvs_nom[n] + diff1 * diff1;
                int n2 = i2++;
                covs[n2] = covs[n2] + diff1 * diff2;
            }
        }
        temp = 0.0;
        for (i2 = 0; i2 < nx; ++i2) {
            temp += prior_nom[i2] / (double)this.m_numInstances * (stdvs_nom[i2] / (double)this.m_numInstances);
            if (stdvs_nom[i2] * stdv_num > 0.0) {
                double rr = covs[i2] / Math.sqrt(stdvs_nom[i2] * stdv_num);
                if (rr < 0.0) {
                    rr = -rr;
                }
                r += prior_nom[i2] / (double)this.m_numInstances * rr;
                continue;
            }
            if (att1 == this.m_classIndex || att2 == this.m_classIndex) continue;
            r += prior_nom[i2] / (double)this.m_numInstances * 1.0;
        }
        if (temp != 0.0 && this.m_std_devs[att1] == 1.0) {
            this.m_std_devs[att1] = Math.sqrt(temp);
        }
        if (stdv_num != 0.0 && this.m_std_devs[att2] == 1.0) {
            this.m_std_devs[att2] = Math.sqrt(stdv_num / (double)this.m_numInstances);
        }
        if (r == 0.0 && att1 != this.m_classIndex && att2 != this.m_classIndex) {
            r = 1.0;
        }
        return r;
    }

    private double nom_nom(int att1, int att2) {
        double temp1;
        double temp2;
        Instance inst;
        int j;
        int i2;
        int mx = (int)this.m_trainInstances.meanOrMode(this.m_trainInstances.attribute(att1));
        int my = (int)this.m_trainInstances.meanOrMode(this.m_trainInstances.attribute(att2));
        double r = 0.0;
        int nx = !this.m_missingSeparate ? this.m_trainInstances.attribute(att1).numValues() : this.m_trainInstances.attribute(att1).numValues() + 1;
        int ny = !this.m_missingSeparate ? this.m_trainInstances.attribute(att2).numValues() : this.m_trainInstances.attribute(att2).numValues() + 1;
        double[][] prior_nom = new double[nx][ny];
        double[] sumx = new double[nx];
        double[] sumy = new double[ny];
        double[] stdvsx = new double[nx];
        double[] stdvsy = new double[ny];
        double[][] covs = new double[nx][ny];
        for (i2 = 0; i2 < nx; ++i2) {
            stdvsx[i2] = 0.0;
            sumx[i2] = 0.0;
        }
        for (j = 0; j < ny; ++j) {
            stdvsy[j] = 0.0;
            sumy[j] = 0.0;
        }
        for (i2 = 0; i2 < nx; ++i2) {
            for (j = 0; j < ny; ++j) {
                prior_nom[i2][j] = 0.0;
                covs[i2][j] = 0.0;
            }
        }
        for (i2 = 0; i2 < this.m_numInstances; ++i2) {
            inst = this.m_trainInstances.instance(i2);
            int ii = inst.isMissing(att1) ? (!this.m_missingSeparate ? mx : nx - 1) : (int)inst.value(att1);
            int jj = inst.isMissing(att2) ? (!this.m_missingSeparate ? my : ny - 1) : (int)inst.value(att2);
            double[] dArray = prior_nom[ii];
            int n = jj;
            dArray[n] = dArray[n] + 1.0;
            int n2 = ii;
            sumx[n2] = sumx[n2] + 1.0;
            int n3 = jj;
            sumy[n3] = sumy[n3] + 1.0;
        }
        for (int z = 0; z < this.m_numInstances; ++z) {
            double diff2;
            inst = this.m_trainInstances.instance(z);
            j = 0;
            while (j < ny) {
                temp2 = inst.isMissing(att2) ? (!this.m_missingSeparate ? (j == my ? 1.0 : 0.0) : (j == ny - 1 ? 1.0 : 0.0)) : ((double)j == inst.value(att2) ? 1.0 : 0.0);
                diff2 = temp2 - sumy[j] / (double)this.m_numInstances;
                int n = j++;
                stdvsy[n] = stdvsy[n] + diff2 * diff2;
            }
            for (i2 = 0; i2 < nx; ++i2) {
                temp1 = inst.isMissing(att1) ? (!this.m_missingSeparate ? (i2 == mx ? 1.0 : 0.0) : (i2 == nx - 1 ? 1.0 : 0.0)) : ((double)i2 == inst.value(att1) ? 1.0 : 0.0);
                double diff1 = temp1 - sumx[i2] / (double)this.m_numInstances;
                int n = i2;
                stdvsx[n] = stdvsx[n] + diff1 * diff1;
                j = 0;
                while (j < ny) {
                    temp2 = inst.isMissing(att2) ? (!this.m_missingSeparate ? (j == my ? 1.0 : 0.0) : (j == ny - 1 ? 1.0 : 0.0)) : ((double)j == inst.value(att2) ? 1.0 : 0.0);
                    diff2 = temp2 - sumy[j] / (double)this.m_numInstances;
                    double[] dArray = covs[i2];
                    int n4 = j++;
                    dArray[n4] = dArray[n4] + diff1 * diff2;
                }
            }
        }
        for (i2 = 0; i2 < nx; ++i2) {
            for (j = 0; j < ny; ++j) {
                if (stdvsx[i2] * stdvsy[j] > 0.0) {
                    double rr = covs[i2][j] / Math.sqrt(stdvsx[i2] * stdvsy[j]);
                    if (rr < 0.0) {
                        rr = -rr;
                    }
                    r += prior_nom[i2][j] / (double)this.m_numInstances * rr;
                    continue;
                }
                if (att1 == this.m_classIndex || att2 == this.m_classIndex) continue;
                r += prior_nom[i2][j] / (double)this.m_numInstances * 1.0;
            }
        }
        temp1 = 0.0;
        for (i2 = 0; i2 < nx; ++i2) {
            temp1 += sumx[i2] / (double)this.m_numInstances * (stdvsx[i2] / (double)this.m_numInstances);
        }
        if (temp1 != 0.0 && this.m_std_devs[att1] == 1.0) {
            this.m_std_devs[att1] = Math.sqrt(temp1);
        }
        temp2 = 0.0;
        for (j = 0; j < ny; ++j) {
            temp2 += sumy[j] / (double)this.m_numInstances * (stdvsy[j] / (double)this.m_numInstances);
        }
        if (temp2 != 0.0 && this.m_std_devs[att2] == 1.0) {
            this.m_std_devs[att2] = Math.sqrt(temp2);
        }
        if (r == 0.0 && att1 != this.m_classIndex && att2 != this.m_classIndex) {
            r = 1.0;
        }
        return r;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.m_trainInstances == null) {
            text.append("CFS subset evaluator has not been built yet\n");
        } else {
            text.append("\tCFS Subset Evaluator\n");
            if (this.m_missingSeparate) {
                text.append("\tTreating missing values as a separate value\n");
            }
            if (this.m_locallyPredictive) {
                text.append("\tIncluding locally predictive attributes\n");
            }
        }
        return text.toString();
    }

    private void addLocallyPredictive(BitSet best_group) {
        boolean done = false;
        boolean ok = true;
        double temp_best = -1.0;
        int j = 0;
        BitSet temp_group = (BitSet)best_group.clone();
        while (!done) {
            float corr;
            int smaller;
            int larger;
            int i2;
            temp_best = -1.0;
            for (i2 = 0; i2 < this.m_numAttribs; ++i2) {
                if (i2 > this.m_classIndex) {
                    larger = i2;
                    smaller = this.m_classIndex;
                } else {
                    smaller = i2;
                    larger = this.m_classIndex;
                }
                if (temp_group.get(i2) || i2 == this.m_classIndex) continue;
                if (this.m_corr_matrix[larger][smaller] == -999.0f) {
                    this.m_corr_matrix[larger][smaller] = corr = this.correlate(i2, this.m_classIndex);
                }
                if (!((double)this.m_corr_matrix[larger][smaller] > temp_best)) continue;
                temp_best = this.m_corr_matrix[larger][smaller];
                j = i2;
            }
            if (temp_best == -1.0) {
                done = true;
                continue;
            }
            ok = true;
            temp_group.set(j);
            for (i2 = 0; i2 < this.m_numAttribs; ++i2) {
                if (i2 > j) {
                    larger = i2;
                    smaller = j;
                } else {
                    larger = j;
                    smaller = i2;
                }
                if (!best_group.get(i2)) continue;
                if (this.m_corr_matrix[larger][smaller] == -999.0f) {
                    this.m_corr_matrix[larger][smaller] = corr = this.correlate(i2, j);
                }
                if (!((double)this.m_corr_matrix[larger][smaller] > temp_best - this.m_c_Threshold)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            best_group.set(j);
        }
    }

    @Override
    public int[] postProcess(int[] attributeSet) throws Exception {
        if (this.m_debug) {
            System.err.println("Percentage of correlation matrix computed over the search: " + Utils.doubleToString((double)this.m_numFilled.get() / (double)this.m_numEntries * 100.0, 2) + "%");
        }
        int j = 0;
        if (!this.m_locallyPredictive) {
            return attributeSet;
        }
        BitSet bestGroup = new BitSet(this.m_numAttribs);
        for (int element : attributeSet) {
            bestGroup.set(element);
        }
        this.addLocallyPredictive(bestGroup);
        for (int i2 = 0; i2 < this.m_numAttribs; ++i2) {
            if (!bestGroup.get(i2)) continue;
            ++j;
        }
        int[] newSet = new int[j];
        j = 0;
        for (int i3 = 0; i3 < this.m_numAttribs; ++i3) {
            if (!bestGroup.get(i3)) continue;
            newSet[j++] = i3;
        }
        return newSet;
    }

    @Override
    public void clean() {
        if (this.m_trainInstances != null) {
            this.m_trainInstances = new Instances(this.m_trainInstances, 0);
        }
    }

    protected void resetOptions() {
        this.m_trainInstances = null;
        this.m_missingSeparate = false;
        this.m_locallyPredictive = true;
        this.m_c_Threshold = 0.0;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 11852 $");
    }

    public static void main(String[] args) {
        CfsSubsetEval.runEvaluator(new CfsSubsetEval(), args);
    }
}

