/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.core.Aggregateable;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.estimators.DiscreteEstimator;
import weka.estimators.Estimator;
import weka.estimators.KernelEstimator;
import weka.estimators.NormalEstimator;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;

public class NaiveBayes
extends AbstractClassifier
implements OptionHandler,
WeightedInstancesHandler,
TechnicalInformationHandler,
Aggregateable<NaiveBayes> {
    static final long serialVersionUID = 5995231201785697655L;
    protected Estimator[][] m_Distributions;
    protected Estimator m_ClassDistribution;
    protected boolean m_UseKernelEstimator = false;
    protected boolean m_UseDiscretization = false;
    protected int m_NumClasses;
    protected Instances m_Instances;
    protected static final double DEFAULT_NUM_PRECISION = 0.01;
    protected Discretize m_Disc = null;
    protected boolean m_displayModelInOldFormat = false;

    public String globalInfo() {
        return "Class for a Naive Bayes classifier using estimator classes. Numeric estimator precision values are chosen based on analysis of the  training data. For this reason, the classifier is not an UpdateableClassifier (which in typical usage are initialized with zero training instances) -- if you need the UpdateableClassifier functionality, use the NaiveBayesUpdateable classifier. The NaiveBayesUpdateable classifier will  use a default precision of 0.1 for numeric attributes when buildClassifier is called with zero training instances.\n\nFor more information on Naive Bayes classifiers, see\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "George H. John and Pat Langley");
        result.setValue(TechnicalInformation.Field.TITLE, "Estimating Continuous Distributions in Bayesian Classifiers");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Eleventh Conference on Uncertainty in Artificial Intelligence");
        result.setValue(TechnicalInformation.Field.YEAR, "1995");
        result.setValue(TechnicalInformation.Field.PAGES, "338-345");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann");
        result.setValue(TechnicalInformation.Field.ADDRESS, "San Mateo");
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_NumClasses = instances.numClasses();
        this.m_Instances = new Instances(instances);
        if (this.m_UseDiscretization) {
            this.m_Disc = new Discretize();
            this.m_Disc.setInputFormat(this.m_Instances);
            this.m_Instances = Filter.useFilter(this.m_Instances, this.m_Disc);
        } else {
            this.m_Disc = null;
        }
        this.m_Distributions = new Estimator[this.m_Instances.numAttributes() - 1][this.m_Instances.numClasses()];
        this.m_ClassDistribution = new DiscreteEstimator(this.m_Instances.numClasses(), true);
        int attIndex = 0;
        Enumeration<Attribute> enu = this.m_Instances.enumerateAttributes();
        while (enu.hasMoreElements()) {
            Attribute attribute = enu.nextElement();
            double numPrecision = 0.01;
            if (attribute.type() == 0) {
                this.m_Instances.sort(attribute);
                if (this.m_Instances.numInstances() > 0 && !this.m_Instances.instance(0).isMissing(attribute)) {
                    Instance currentInst;
                    double lastVal = this.m_Instances.instance(0).value(attribute);
                    double deltaSum = 0.0;
                    int distinct = 0;
                    for (int i2 = 1; i2 < this.m_Instances.numInstances() && !(currentInst = this.m_Instances.instance(i2)).isMissing(attribute); ++i2) {
                        double currentVal = currentInst.value(attribute);
                        if (currentVal == lastVal) continue;
                        deltaSum += currentVal - lastVal;
                        lastVal = currentVal;
                        ++distinct;
                    }
                    if (distinct > 0) {
                        numPrecision = deltaSum / (double)distinct;
                    }
                }
            }
            block6: for (int j = 0; j < this.m_Instances.numClasses(); ++j) {
                switch (attribute.type()) {
                    case 0: {
                        if (this.m_UseKernelEstimator) {
                            this.m_Distributions[attIndex][j] = new KernelEstimator(numPrecision);
                            continue block6;
                        }
                        this.m_Distributions[attIndex][j] = new NormalEstimator(numPrecision);
                        continue block6;
                    }
                    case 1: {
                        this.m_Distributions[attIndex][j] = new DiscreteEstimator(attribute.numValues(), true);
                        continue block6;
                    }
                    default: {
                        throw new Exception("Attribute type unknown to NaiveBayes");
                    }
                }
            }
            ++attIndex;
        }
        Enumeration<Instance> enumInsts = this.m_Instances.enumerateInstances();
        while (enumInsts.hasMoreElements()) {
            Instance instance = enumInsts.nextElement();
            this.updateClassifier(instance);
        }
        this.m_Instances = new Instances(this.m_Instances, 0);
    }

    public void updateClassifier(Instance instance) throws Exception {
        if (!instance.classIsMissing()) {
            Enumeration<Attribute> enumAtts = this.m_Instances.enumerateAttributes();
            int attIndex = 0;
            while (enumAtts.hasMoreElements()) {
                Attribute attribute = enumAtts.nextElement();
                if (!instance.isMissing(attribute)) {
                    this.m_Distributions[attIndex][(int)instance.classValue()].addValue(instance.value(attribute), instance.weight());
                }
                ++attIndex;
            }
            this.m_ClassDistribution.addValue(instance.classValue(), instance.weight());
        }
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_UseDiscretization) {
            this.m_Disc.input(instance);
            instance = this.m_Disc.output();
        }
        double[] probs = new double[this.m_NumClasses];
        for (int j = 0; j < this.m_NumClasses; ++j) {
            probs[j] = this.m_ClassDistribution.getProbability(j);
        }
        Enumeration<Attribute> enumAtts = instance.enumerateAttributes();
        int attIndex = 0;
        while (enumAtts.hasMoreElements()) {
            Attribute attribute = enumAtts.nextElement();
            if (!instance.isMissing(attribute)) {
                int j;
                double max = 0.0;
                for (j = 0; j < this.m_NumClasses; ++j) {
                    double temp = Math.max(1.0E-75, Math.pow(this.m_Distributions[attIndex][j].getProbability(instance.value(attribute)), this.m_Instances.attribute(attIndex).weight()));
                    int n = j;
                    probs[n] = probs[n] * temp;
                    if (probs[j] > max) {
                        max = probs[j];
                    }
                    if (!Double.isNaN(probs[j])) continue;
                    throw new Exception("NaN returned from estimator for attribute " + attribute.name() + ":\n" + this.m_Distributions[attIndex][j].toString());
                }
                if (max > 0.0 && max < 1.0E-75) {
                    j = 0;
                    while (j < this.m_NumClasses) {
                        int n = j++;
                        probs[n] = probs[n] * 1.0E75;
                    }
                }
            }
            ++attIndex;
        }
        Utils.normalize(probs);
        return probs;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(3);
        newVector.addElement(new Option("\tUse kernel density estimator rather than normal\n\tdistribution for numeric attributes", "K", 0, "-K"));
        newVector.addElement(new Option("\tUse supervised discretization to process numeric attributes\n", "D", 0, "-D"));
        newVector.addElement(new Option("\tDisplay model in old format (good when there are many classes)\n", "O", 0, "-O"));
        newVector.addAll(Collections.list(super.listOptions()));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        boolean k = Utils.getFlag('K', options);
        boolean d = Utils.getFlag('D', options);
        if (k && d) {
            throw new IllegalArgumentException("Can't use both kernel density estimation and discretization!");
        }
        this.setUseSupervisedDiscretization(d);
        this.setUseKernelEstimator(k);
        this.setDisplayModelInOldFormat(Utils.getFlag('O', options));
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        Collections.addAll(options, super.getOptions());
        if (this.m_UseKernelEstimator) {
            options.add("-K");
        }
        if (this.m_UseDiscretization) {
            options.add("-D");
        }
        if (this.m_displayModelInOldFormat) {
            options.add("-O");
        }
        return options.toArray(new String[0]);
    }

    public String toString() {
        if (this.m_displayModelInOldFormat) {
            return this.toStringOriginal();
        }
        StringBuffer temp = new StringBuffer();
        temp.append("Naive Bayes Classifier");
        if (this.m_Instances == null) {
            temp.append(": No model built yet.");
        } else {
            int i2;
            int i3;
            int maxWidth = 0;
            int maxAttWidth = 0;
            boolean containsKernel = false;
            for (i3 = 0; i3 < this.m_Instances.numClasses(); ++i3) {
                if (this.m_Instances.classAttribute().value(i3).length() <= maxWidth) continue;
                maxWidth = this.m_Instances.classAttribute().value(i3).length();
            }
            for (i3 = 0; i3 < this.m_Instances.numAttributes(); ++i3) {
                if (i3 == this.m_Instances.classIndex()) continue;
                Attribute a = this.m_Instances.attribute(i3);
                if (a.name().length() > maxAttWidth) {
                    maxAttWidth = this.m_Instances.attribute(i3).name().length();
                }
                if (!a.isNominal()) continue;
                for (int j = 0; j < a.numValues(); ++j) {
                    String val = a.value(j) + "  ";
                    if (val.length() <= maxAttWidth) continue;
                    maxAttWidth = val.length();
                }
            }
            for (Estimator[] m_Distribution : this.m_Distributions) {
                for (int j = 0; j < this.m_Instances.numClasses(); ++j) {
                    if (m_Distribution[0] instanceof NormalEstimator) {
                        double precision;
                        double width;
                        NormalEstimator n = (NormalEstimator)m_Distribution[j];
                        double mean = Math.log(Math.abs(n.getMean())) / Math.log(10.0);
                        double d = width = mean > (precision = Math.log(Math.abs(n.getPrecision())) / Math.log(10.0)) ? mean : precision;
                        if (width < 0.0) {
                            width = 1.0;
                        }
                        if ((int)(width += 6.0) <= maxWidth) continue;
                        maxWidth = (int)width;
                        continue;
                    }
                    if (m_Distribution[0] instanceof KernelEstimator) {
                        containsKernel = true;
                        KernelEstimator ke = (KernelEstimator)m_Distribution[j];
                        int numK = ke.getNumKernels();
                        String temps = "K" + numK + ": mean (weight)";
                        if (maxAttWidth < temps.length()) {
                            maxAttWidth = temps.length();
                        }
                        if (ke.getNumKernels() <= 0) continue;
                        double[] means = ke.getMeans();
                        double[] weights = ke.getWeights();
                        for (int k = 0; k < ke.getNumKernels(); ++k) {
                            String m = Utils.doubleToString(means[k], maxWidth, 4).trim();
                            if (maxWidth >= (m = m + " (" + Utils.doubleToString(weights[k], maxWidth, 1).trim() + ")").length()) continue;
                            maxWidth = m.length();
                        }
                        continue;
                    }
                    if (!(m_Distribution[0] instanceof DiscreteEstimator)) continue;
                    DiscreteEstimator d = (DiscreteEstimator)m_Distribution[j];
                    for (int k = 0; k < d.getNumSymbols(); ++k) {
                        String size = "" + d.getCount(k);
                        if (size.length() <= maxWidth) continue;
                        maxWidth = size.length();
                    }
                    int sum = ("" + d.getSumOfCounts()).length();
                    if (sum <= maxWidth) continue;
                    maxWidth = sum;
                }
            }
            for (i2 = 0; i2 < this.m_Instances.numClasses(); ++i2) {
                String cSize = this.m_Instances.classAttribute().value(i2);
                if (cSize.length() <= maxWidth) continue;
                maxWidth = cSize.length();
            }
            for (i2 = 0; i2 < this.m_Instances.numClasses(); ++i2) {
                String priorP = Utils.doubleToString(((DiscreteEstimator)this.m_ClassDistribution).getProbability(i2), maxWidth, 2).trim();
                priorP = "(" + priorP + ")";
                if (priorP.length() <= maxWidth) continue;
                maxWidth = priorP.length();
            }
            if (maxAttWidth < "Attribute".length()) {
                maxAttWidth = "Attribute".length();
            }
            if (maxAttWidth < "  weight sum".length()) {
                maxAttWidth = "  weight sum".length();
            }
            if (containsKernel && maxAttWidth < "  [precision]".length()) {
                maxAttWidth = "  [precision]".length();
            }
            temp.append("\n\n");
            temp.append(this.pad("Class", " ", (maxAttWidth += 2) + maxWidth + 1 - "Class".length(), true));
            temp.append("\n");
            temp.append(this.pad("Attribute", " ", maxAttWidth - "Attribute".length(), false));
            for (i2 = 0; i2 < this.m_Instances.numClasses(); ++i2) {
                String classL = this.m_Instances.classAttribute().value(i2);
                temp.append(this.pad(classL, " ", maxWidth + 1 - classL.length(), true));
            }
            temp.append("\n");
            temp.append(this.pad("", " ", maxAttWidth, true));
            for (i2 = 0; i2 < this.m_Instances.numClasses(); ++i2) {
                String priorP = Utils.doubleToString(((DiscreteEstimator)this.m_ClassDistribution).getProbability(i2), maxWidth, 2).trim();
                priorP = "(" + priorP + ")";
                temp.append(this.pad(priorP, " ", maxWidth + 1 - priorP.length(), true));
            }
            temp.append("\n");
            temp.append(this.pad("", "=", maxAttWidth + maxWidth * this.m_Instances.numClasses() + this.m_Instances.numClasses() + 1, true));
            temp.append("\n");
            int counter = 0;
            for (int i4 = 0; i4 < this.m_Instances.numAttributes(); ++i4) {
                if (i4 == this.m_Instances.classIndex()) continue;
                String attName = this.m_Instances.attribute(i4).name();
                temp.append(attName + "\n");
                if (this.m_Distributions[counter][0] instanceof NormalEstimator) {
                    String meanL = "  mean";
                    temp.append(this.pad(meanL, " ", maxAttWidth + 1 - meanL.length(), false));
                    for (int j = 0; j < this.m_Instances.numClasses(); ++j) {
                        NormalEstimator n = (NormalEstimator)this.m_Distributions[counter][j];
                        String mean = Utils.doubleToString(n.getMean(), maxWidth, 4).trim();
                        temp.append(this.pad(mean, " ", maxWidth + 1 - mean.length(), true));
                    }
                    temp.append("\n");
                    String stdDevL = "  std. dev.";
                    temp.append(this.pad(stdDevL, " ", maxAttWidth + 1 - stdDevL.length(), false));
                    for (int j = 0; j < this.m_Instances.numClasses(); ++j) {
                        NormalEstimator n = (NormalEstimator)this.m_Distributions[counter][j];
                        String stdDev = Utils.doubleToString(n.getStdDev(), maxWidth, 4).trim();
                        temp.append(this.pad(stdDev, " ", maxWidth + 1 - stdDev.length(), true));
                    }
                    temp.append("\n");
                    String weightL = "  weight sum";
                    temp.append(this.pad(weightL, " ", maxAttWidth + 1 - weightL.length(), false));
                    for (int j = 0; j < this.m_Instances.numClasses(); ++j) {
                        NormalEstimator n = (NormalEstimator)this.m_Distributions[counter][j];
                        String weight = Utils.doubleToString(n.getSumOfWeights(), maxWidth, 4).trim();
                        temp.append(this.pad(weight, " ", maxWidth + 1 - weight.length(), true));
                    }
                    temp.append("\n");
                    String precisionL = "  precision";
                    temp.append(this.pad(precisionL, " ", maxAttWidth + 1 - precisionL.length(), false));
                    for (int j = 0; j < this.m_Instances.numClasses(); ++j) {
                        NormalEstimator n = (NormalEstimator)this.m_Distributions[counter][j];
                        String precision = Utils.doubleToString(n.getPrecision(), maxWidth, 4).trim();
                        temp.append(this.pad(precision, " ", maxWidth + 1 - precision.length(), true));
                    }
                    temp.append("\n\n");
                } else if (this.m_Distributions[counter][0] instanceof DiscreteEstimator) {
                    Attribute a = this.m_Instances.attribute(i4);
                    for (int j = 0; j < a.numValues(); ++j) {
                        String val = "  " + a.value(j);
                        temp.append(this.pad(val, " ", maxAttWidth + 1 - val.length(), false));
                        for (int k = 0; k < this.m_Instances.numClasses(); ++k) {
                            DiscreteEstimator d = (DiscreteEstimator)this.m_Distributions[counter][k];
                            String count = "" + d.getCount(j);
                            temp.append(this.pad(count, " ", maxWidth + 1 - count.length(), true));
                        }
                        temp.append("\n");
                    }
                    String total = "  [total]";
                    temp.append(this.pad(total, " ", maxAttWidth + 1 - total.length(), false));
                    for (int k = 0; k < this.m_Instances.numClasses(); ++k) {
                        DiscreteEstimator d = (DiscreteEstimator)this.m_Distributions[counter][k];
                        String count = "" + d.getSumOfCounts();
                        temp.append(this.pad(count, " ", maxWidth + 1 - count.length(), true));
                    }
                    temp.append("\n\n");
                } else if (this.m_Distributions[counter][0] instanceof KernelEstimator) {
                    String kL = "  [# kernels]";
                    temp.append(this.pad(kL, " ", maxAttWidth + 1 - kL.length(), false));
                    for (int k = 0; k < this.m_Instances.numClasses(); ++k) {
                        KernelEstimator ke = (KernelEstimator)this.m_Distributions[counter][k];
                        String nk = "" + ke.getNumKernels();
                        temp.append(this.pad(nk, " ", maxWidth + 1 - nk.length(), true));
                    }
                    temp.append("\n");
                    String stdDevL = "  [std. dev]";
                    temp.append(this.pad(stdDevL, " ", maxAttWidth + 1 - stdDevL.length(), false));
                    for (int k = 0; k < this.m_Instances.numClasses(); ++k) {
                        KernelEstimator ke = (KernelEstimator)this.m_Distributions[counter][k];
                        String stdD = Utils.doubleToString(ke.getStdDev(), maxWidth, 4).trim();
                        temp.append(this.pad(stdD, " ", maxWidth + 1 - stdD.length(), true));
                    }
                    temp.append("\n");
                    String precL = "  [precision]";
                    temp.append(this.pad(precL, " ", maxAttWidth + 1 - precL.length(), false));
                    for (int k = 0; k < this.m_Instances.numClasses(); ++k) {
                        KernelEstimator ke = (KernelEstimator)this.m_Distributions[counter][k];
                        String prec = Utils.doubleToString(ke.getPrecision(), maxWidth, 4).trim();
                        temp.append(this.pad(prec, " ", maxWidth + 1 - prec.length(), true));
                    }
                    temp.append("\n");
                    int maxK = 0;
                    for (int k = 0; k < this.m_Instances.numClasses(); ++k) {
                        KernelEstimator ke = (KernelEstimator)this.m_Distributions[counter][k];
                        if (ke.getNumKernels() <= maxK) continue;
                        maxK = ke.getNumKernels();
                    }
                    for (int j = 0; j < maxK; ++j) {
                        String meanL = "  K" + (j + 1) + ": mean (weight)";
                        temp.append(this.pad(meanL, " ", maxAttWidth + 1 - meanL.length(), false));
                        for (int k = 0; k < this.m_Instances.numClasses(); ++k) {
                            KernelEstimator ke = (KernelEstimator)this.m_Distributions[counter][k];
                            double[] means = ke.getMeans();
                            double[] weights = ke.getWeights();
                            String m = "--";
                            if (ke.getNumKernels() == 0) {
                                m = "0";
                            } else if (j < ke.getNumKernels()) {
                                m = Utils.doubleToString(means[j], maxWidth, 4).trim();
                                m = m + " (" + Utils.doubleToString(weights[j], maxWidth, 1).trim() + ")";
                            }
                            temp.append(this.pad(m, " ", maxWidth + 1 - m.length(), true));
                        }
                        temp.append("\n");
                    }
                    temp.append("\n");
                }
                ++counter;
            }
        }
        return temp.toString();
    }

    protected String toStringOriginal() {
        StringBuffer text = new StringBuffer();
        text.append("Naive Bayes Classifier");
        if (this.m_Instances == null) {
            text.append(": No model built yet.");
        } else {
            try {
                for (int i2 = 0; i2 < this.m_Distributions[0].length; ++i2) {
                    text.append("\n\nClass " + this.m_Instances.classAttribute().value(i2) + ": Prior probability = " + Utils.doubleToString(this.m_ClassDistribution.getProbability(i2), 4, 2) + "\n\n");
                    Enumeration<Attribute> enumAtts = this.m_Instances.enumerateAttributes();
                    int attIndex = 0;
                    while (enumAtts.hasMoreElements()) {
                        Attribute attribute = enumAtts.nextElement();
                        if (attribute.weight() > 0.0) {
                            text.append(attribute.name() + ":  " + this.m_Distributions[attIndex][i2]);
                        }
                        ++attIndex;
                    }
                }
            }
            catch (Exception ex) {
                text.append(ex.getMessage());
            }
        }
        return text.toString();
    }

    private String pad(String source, String padChar, int length, boolean leftPad) {
        StringBuffer temp = new StringBuffer();
        if (leftPad) {
            for (int i2 = 0; i2 < length; ++i2) {
                temp.append(padChar);
            }
            temp.append(source);
        } else {
            temp.append(source);
            for (int i3 = 0; i3 < length; ++i3) {
                temp.append(padChar);
            }
        }
        return temp.toString();
    }

    public String useKernelEstimatorTipText() {
        return "Use a kernel estimator for numeric attributes rather than a normal distribution.";
    }

    public boolean getUseKernelEstimator() {
        return this.m_UseKernelEstimator;
    }

    public void setUseKernelEstimator(boolean v) {
        this.m_UseKernelEstimator = v;
        if (v) {
            this.setUseSupervisedDiscretization(false);
        }
    }

    public String useSupervisedDiscretizationTipText() {
        return "Use supervised discretization to convert numeric attributes to nominal ones.";
    }

    public boolean getUseSupervisedDiscretization() {
        return this.m_UseDiscretization;
    }

    public void setUseSupervisedDiscretization(boolean newblah) {
        this.m_UseDiscretization = newblah;
        if (newblah) {
            this.setUseKernelEstimator(false);
        }
    }

    public String displayModelInOldFormatTipText() {
        return "Use old format for model output. The old format is better when there are many class values. The new format is better when there are fewer classes and many attributes.";
    }

    public void setDisplayModelInOldFormat(boolean d) {
        this.m_displayModelInOldFormat = d;
    }

    public boolean getDisplayModelInOldFormat() {
        return this.m_displayModelInOldFormat;
    }

    public Instances getHeader() {
        return this.m_Instances;
    }

    public Estimator[][] getConditionalEstimators() {
        return this.m_Distributions;
    }

    public Estimator getClassEstimator() {
        return this.m_ClassDistribution;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 11741 $");
    }

    @Override
    public NaiveBayes aggregate(NaiveBayes toAggregate) throws Exception {
        if (this.m_UseDiscretization || toAggregate.getUseSupervisedDiscretization()) {
            throw new Exception("Unable to aggregate when supervised discretization has been turned on");
        }
        if (!this.m_Instances.equalHeaders(toAggregate.m_Instances)) {
            throw new Exception("Can't aggregate - data headers don't match: " + this.m_Instances.equalHeadersMsg(toAggregate.m_Instances));
        }
        ((Aggregateable)((Object)this.m_ClassDistribution)).aggregate(toAggregate.m_ClassDistribution);
        for (int i2 = 0; i2 < this.m_Distributions.length; ++i2) {
            for (int j = 0; j < this.m_Distributions[i2].length; ++j) {
                ((Aggregateable)((Object)this.m_Distributions[i2][j])).aggregate(toAggregate.m_Distributions[i2][j]);
            }
        }
        return this;
    }

    @Override
    public void finalizeAggregation() throws Exception {
    }

    public static void main(String[] argv) {
        NaiveBayes.runClassifier(new NaiveBayes(), argv);
    }
}

