/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.estimate;

import weka.classifiers.bayes.net.search.local.Scoreable;
import weka.core.RevisionUtils;
import weka.core.Statistics;
import weka.core.Utils;
import weka.estimators.DiscreteEstimator;
import weka.estimators.Estimator;

public class DiscreteEstimatorBayes
extends Estimator
implements Scoreable {
    static final long serialVersionUID = 4215400230843212684L;
    protected double[] m_Counts;
    protected double m_SumOfCounts;
    protected int m_nSymbols = 0;
    protected double m_fPrior = 0.0;

    public DiscreteEstimatorBayes(int nSymbols, double fPrior) {
        this.m_fPrior = fPrior;
        this.m_nSymbols = nSymbols;
        this.m_Counts = new double[this.m_nSymbols];
        for (int iSymbol = 0; iSymbol < this.m_nSymbols; ++iSymbol) {
            this.m_Counts[iSymbol] = this.m_fPrior;
        }
        this.m_SumOfCounts = this.m_fPrior * (double)this.m_nSymbols;
    }

    @Override
    public void addValue(double data, double weight) {
        int n = (int)data;
        this.m_Counts[n] = this.m_Counts[n] + weight;
        this.m_SumOfCounts += weight;
    }

    @Override
    public double getProbability(double data) {
        if (this.m_SumOfCounts == 0.0) {
            return 0.0;
        }
        return this.m_Counts[(int)data] / this.m_SumOfCounts;
    }

    public double getCount(double data) {
        if (this.m_SumOfCounts == 0.0) {
            return 0.0;
        }
        return this.m_Counts[(int)data];
    }

    public int getNumSymbols() {
        return this.m_Counts == null ? 0 : this.m_Counts.length;
    }

    @Override
    public double logScore(int nType, int nCardinality) {
        double fScore = 0.0;
        switch (nType) {
            case 0: {
                for (int iSymbol = 0; iSymbol < this.m_nSymbols; ++iSymbol) {
                    fScore += Statistics.lnGamma(this.m_Counts[iSymbol]);
                }
                fScore -= Statistics.lnGamma(this.m_SumOfCounts);
                if (this.m_fPrior == 0.0) break;
                fScore -= (double)this.m_nSymbols * Statistics.lnGamma(this.m_fPrior);
                fScore += Statistics.lnGamma((double)this.m_nSymbols * this.m_fPrior);
                break;
            }
            case 1: {
                for (int iSymbol = 0; iSymbol < this.m_nSymbols; ++iSymbol) {
                    fScore += Statistics.lnGamma(this.m_Counts[iSymbol]);
                }
                fScore -= Statistics.lnGamma(this.m_SumOfCounts);
                fScore -= (double)this.m_nSymbols * Statistics.lnGamma(1.0 / (double)(this.m_nSymbols * nCardinality));
                fScore += Statistics.lnGamma(1.0 / (double)nCardinality);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                for (int iSymbol = 0; iSymbol < this.m_nSymbols; ++iSymbol) {
                    double fP = this.getProbability(iSymbol);
                    fScore += this.m_Counts[iSymbol] * Math.log(fP);
                }
                break;
            }
        }
        return fScore;
    }

    public String toString() {
        String result = "Discrete Estimator. Counts = ";
        if (this.m_SumOfCounts > 1.0) {
            for (int i2 = 0; i2 < this.m_Counts.length; ++i2) {
                result = result + " " + Utils.doubleToString(this.m_Counts[i2], 2);
            }
            result = result + "  (Total = " + Utils.doubleToString(this.m_SumOfCounts, 2) + ")\n";
        } else {
            for (int i3 = 0; i3 < this.m_Counts.length; ++i3) {
                result = result + " " + this.m_Counts[i3];
            }
            result = result + "  (Total = " + this.m_SumOfCounts + ")\n";
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] argv) {
        try {
            int current;
            if (argv.length == 0) {
                System.out.println("Please specify a set of instances.");
                return;
            }
            int max = current = Integer.parseInt(argv[0]);
            for (int i2 = 1; i2 < argv.length; ++i2) {
                current = Integer.parseInt(argv[i2]);
                if (current <= max) continue;
                max = current;
            }
            DiscreteEstimator newEst = new DiscreteEstimator(max + 1, true);
            for (int i3 = 0; i3 < argv.length; ++i3) {
                current = Integer.parseInt(argv[i3]);
                System.out.println(newEst);
                System.out.println("Prediction for " + current + " = " + newEst.getProbability(current));
                newEst.addValue(current, 1.0);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

