/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.local;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.ParentSet;
import weka.classifiers.bayes.net.search.local.LocalScoreSearchAlgorithm;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class GeneticSearch
extends LocalScoreSearchAlgorithm {
    static final long serialVersionUID = -7037070678911459757L;
    int m_nRuns = 10;
    int m_nPopulationSize = 10;
    int m_nDescendantPopulationSize = 100;
    boolean m_bUseCrossOver = true;
    boolean m_bUseMutation = true;
    boolean m_bUseTournamentSelection = false;
    int m_nSeed = 1;
    Random m_random = null;
    boolean[] g_bIsSquare;

    @Override
    protected void search(BayesNet bayesNet, Instances instances) throws Exception {
        if (this.getDescendantPopulationSize() < this.getPopulationSize()) {
            throw new Exception("Descendant PopulationSize should be at least Population Size");
        }
        if (!this.getUseCrossOver() && !this.getUseMutation()) {
            throw new Exception("At least one of mutation or cross-over should be used");
        }
        this.m_random = new Random(this.m_nSeed);
        double fBestScore = 0.0;
        for (int iAttribute = 0; iAttribute < instances.numAttributes(); ++iAttribute) {
            fBestScore += this.calcNodeScore(iAttribute);
        }
        BayesNet bestBayesNet = new BayesNet();
        bestBayesNet.m_Instances = instances;
        bestBayesNet.initStructure();
        this.copyParentSets(bestBayesNet, bayesNet);
        BayesNetRepresentation[] population = new BayesNetRepresentation[this.getPopulationSize()];
        for (int i2 = 0; i2 < this.getPopulationSize(); ++i2) {
            population[i2] = new BayesNetRepresentation(instances.numAttributes());
            population[i2].randomInit();
            if (!(population[i2].getScore() > fBestScore)) continue;
            this.copyParentSets(bestBayesNet, bayesNet);
            fBestScore = population[i2].getScore();
        }
        for (int iRun = 0; iRun < this.m_nRuns; ++iRun) {
            BayesNetRepresentation[] descendantPopulation = new BayesNetRepresentation[this.getDescendantPopulationSize()];
            for (int i3 = 0; i3 < this.getDescendantPopulationSize(); ++i3) {
                descendantPopulation[i3] = population[this.m_random.nextInt(this.getPopulationSize())].copy();
                if (this.getUseMutation()) {
                    if (this.getUseCrossOver() && this.m_random.nextBoolean()) {
                        descendantPopulation[i3].crossOver(population[this.m_random.nextInt(this.getPopulationSize())]);
                    } else {
                        descendantPopulation[i3].mutate();
                    }
                } else {
                    descendantPopulation[i3].crossOver(population[this.m_random.nextInt(this.getPopulationSize())]);
                }
                if (!(descendantPopulation[i3].getScore() > fBestScore)) continue;
                this.copyParentSets(bestBayesNet, bayesNet);
                fBestScore = descendantPopulation[i3].getScore();
            }
            boolean[] bSelected = new boolean[this.getDescendantPopulationSize()];
            for (int i4 = 0; i4 < this.getPopulationSize(); ++i4) {
                int iSelected = 0;
                if (this.m_bUseTournamentSelection) {
                    iSelected = this.m_random.nextInt(this.getDescendantPopulationSize());
                    while (bSelected[iSelected]) {
                        iSelected = (iSelected + 1) % this.getDescendantPopulationSize();
                    }
                    int iSelected2 = this.m_random.nextInt(this.getDescendantPopulationSize());
                    while (bSelected[iSelected2]) {
                        iSelected2 = (iSelected2 + 1) % this.getDescendantPopulationSize();
                    }
                    if (descendantPopulation[iSelected2].getScore() > descendantPopulation[iSelected].getScore()) {
                        iSelected = iSelected2;
                    }
                } else {
                    while (bSelected[iSelected]) {
                        ++iSelected;
                    }
                    double fScore = descendantPopulation[iSelected].getScore();
                    for (int j = 0; j < this.getDescendantPopulationSize(); ++j) {
                        if (bSelected[j] || !(descendantPopulation[j].getScore() > fScore)) continue;
                        fScore = descendantPopulation[j].getScore();
                        iSelected = j;
                    }
                }
                population[i4] = descendantPopulation[iSelected];
                bSelected[iSelected] = true;
            }
        }
        this.copyParentSets(bayesNet, bestBayesNet);
        bestBayesNet = null;
        this.g_bIsSquare = null;
    }

    void copyParentSets(BayesNet dest, BayesNet source) {
        int nNodes = source.getNrOfNodes();
        for (int iNode = 0; iNode < nNodes; ++iNode) {
            dest.getParentSet(iNode).copy(source.getParentSet(iNode));
        }
    }

    public int getRuns() {
        return this.m_nRuns;
    }

    public void setRuns(int nRuns) {
        this.m_nRuns = nRuns;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(7);
        newVector.addElement(new Option("\tPopulation size", "L", 1, "-L <integer>"));
        newVector.addElement(new Option("\tDescendant population size", "A", 1, "-A <integer>"));
        newVector.addElement(new Option("\tNumber of runs", "U", 1, "-U <integer>"));
        newVector.addElement(new Option("\tUse mutation.\n\t(default true)", "M", 0, "-M"));
        newVector.addElement(new Option("\tUse cross-over.\n\t(default true)", "C", 0, "-C"));
        newVector.addElement(new Option("\tUse tournament selection (true) or maximum subpopulatin (false).\n\t(default false)", "O", 0, "-O"));
        newVector.addElement(new Option("\tRandom number seed", "R", 1, "-R <seed>"));
        newVector.addAll(Collections.list(super.listOptions()));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String sSeed;
        String sRuns;
        String sDescendantPopulationSize;
        String sPopulationSize = Utils.getOption('L', options);
        if (sPopulationSize.length() != 0) {
            this.setPopulationSize(Integer.parseInt(sPopulationSize));
        }
        if ((sDescendantPopulationSize = Utils.getOption('A', options)).length() != 0) {
            this.setDescendantPopulationSize(Integer.parseInt(sDescendantPopulationSize));
        }
        if ((sRuns = Utils.getOption('U', options)).length() != 0) {
            this.setRuns(Integer.parseInt(sRuns));
        }
        if ((sSeed = Utils.getOption('R', options)).length() != 0) {
            this.setSeed(Integer.parseInt(sSeed));
        }
        this.setUseMutation(Utils.getFlag('M', options));
        this.setUseCrossOver(Utils.getFlag('C', options));
        this.setUseTournamentSelection(Utils.getFlag('O', options));
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-L");
        options.add("" + this.getPopulationSize());
        options.add("-A");
        options.add("" + this.getDescendantPopulationSize());
        options.add("-U");
        options.add("" + this.getRuns());
        options.add("-R");
        options.add("" + this.getSeed());
        if (this.getUseMutation()) {
            options.add("-M");
        }
        if (this.getUseCrossOver()) {
            options.add("-C");
        }
        if (this.getUseTournamentSelection()) {
            options.add("-O");
        }
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    public boolean getUseCrossOver() {
        return this.m_bUseCrossOver;
    }

    public boolean getUseMutation() {
        return this.m_bUseMutation;
    }

    public int getDescendantPopulationSize() {
        return this.m_nDescendantPopulationSize;
    }

    public int getPopulationSize() {
        return this.m_nPopulationSize;
    }

    public void setUseCrossOver(boolean bUseCrossOver) {
        this.m_bUseCrossOver = bUseCrossOver;
    }

    public void setUseMutation(boolean bUseMutation) {
        this.m_bUseMutation = bUseMutation;
    }

    public boolean getUseTournamentSelection() {
        return this.m_bUseTournamentSelection;
    }

    public void setUseTournamentSelection(boolean bUseTournamentSelection) {
        this.m_bUseTournamentSelection = bUseTournamentSelection;
    }

    public void setDescendantPopulationSize(int iDescendantPopulationSize) {
        this.m_nDescendantPopulationSize = iDescendantPopulationSize;
    }

    public void setPopulationSize(int iPopulationSize) {
        this.m_nPopulationSize = iPopulationSize;
    }

    public int getSeed() {
        return this.m_nSeed;
    }

    public void setSeed(int nSeed) {
        this.m_nSeed = nSeed;
    }

    @Override
    public String globalInfo() {
        return "This Bayes Network learning algorithm uses genetic search for finding a well scoring Bayes network structure. Genetic search works by having a population of Bayes network structures and allow them to mutate and apply cross over to get offspring. The best network structure found during the process is returned.";
    }

    public String runsTipText() {
        return "Sets the number of generations of Bayes network structure populations.";
    }

    public String seedTipText() {
        return "Initialization value for random number generator. Setting the seed allows replicability of experiments.";
    }

    public String populationSizeTipText() {
        return "Sets the size of the population of network structures that is selected each generation.";
    }

    public String descendantPopulationSizeTipText() {
        return "Sets the size of the population of descendants that is created each generation.";
    }

    public String useMutationTipText() {
        return "Determines whether mutation is allowed. Mutation flips a bit in the bit representation of the network structure. At least one of mutation or cross-over should be used.";
    }

    public String useCrossOverTipText() {
        return "Determines whether cross-over is allowed. Cross over combined the bit representations of network structure by taking a random first k bits of oneand adding the remainder of the other. At least one of mutation or cross-over should be used.";
    }

    public String useTournamentSelectionTipText() {
        return "Determines the method of selecting a population. When set to true, tournament selection is used (pick two at random and the highest is allowed to continue). When set to false, the top scoring network structures are selected.";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 11247 $");
    }

    class BayesNetRepresentation
    implements RevisionHandler {
        int m_nNodes = 0;
        boolean[] m_bits;
        double m_fScore = 0.0;

        public double getScore() {
            return this.m_fScore;
        }

        BayesNetRepresentation(int nNodes) {
            this.m_nNodes = nNodes;
        }

        public void randomInit() {
            do {
                this.m_bits = new boolean[this.m_nNodes * this.m_nNodes];
                for (int i2 = 0; i2 < this.m_nNodes; ++i2) {
                    int iPos;
                    while (this.isSquare(iPos = GeneticSearch.this.m_random.nextInt(this.m_nNodes * this.m_nNodes))) {
                    }
                    this.m_bits[iPos] = true;
                }
            } while (this.hasCycles());
            this.calcScore();
        }

        void calcScore() {
            ParentSet parentSet;
            int iNode;
            for (iNode = 0; iNode < this.m_nNodes; ++iNode) {
                parentSet = GeneticSearch.this.m_BayesNet.getParentSet(iNode);
                while (parentSet.getNrOfParents() > 0) {
                    parentSet.deleteLastParent(GeneticSearch.this.m_BayesNet.m_Instances);
                }
            }
            for (iNode = 0; iNode < this.m_nNodes; ++iNode) {
                parentSet = GeneticSearch.this.m_BayesNet.getParentSet(iNode);
                for (int iNode2 = 0; iNode2 < this.m_nNodes; ++iNode2) {
                    if (!this.m_bits[iNode2 + iNode * this.m_nNodes]) continue;
                    parentSet.addParent(iNode2, GeneticSearch.this.m_BayesNet.m_Instances);
                }
            }
            this.m_fScore = 0.0;
            for (iNode = 0; iNode < this.m_nNodes; ++iNode) {
                this.m_fScore += GeneticSearch.this.calcNodeScore(iNode);
            }
        }

        public boolean hasCycles() {
            boolean[] bDone = new boolean[this.m_nNodes];
            for (int iNode = 0; iNode < this.m_nNodes; ++iNode) {
                boolean bFound = false;
                for (int iNode2 = 0; !bFound && iNode2 < this.m_nNodes; ++iNode2) {
                    if (bDone[iNode2]) continue;
                    boolean bHasNoParents = true;
                    for (int iParent = 0; iParent < this.m_nNodes; ++iParent) {
                        if (!this.m_bits[iParent + iNode2 * this.m_nNodes] || bDone[iParent]) continue;
                        bHasNoParents = false;
                    }
                    if (!bHasNoParents) continue;
                    bDone[iNode2] = true;
                    bFound = true;
                }
                if (bFound) continue;
                return true;
            }
            return false;
        }

        BayesNetRepresentation copy() {
            BayesNetRepresentation b = new BayesNetRepresentation(this.m_nNodes);
            b.m_bits = new boolean[this.m_bits.length];
            for (int i2 = 0; i2 < this.m_nNodes * this.m_nNodes; ++i2) {
                b.m_bits[i2] = this.m_bits[i2];
            }
            b.m_fScore = this.m_fScore;
            return b;
        }

        void mutate() {
            while (true) {
                int iBit;
                if (this.isSquare(iBit = GeneticSearch.this.m_random.nextInt(this.m_nNodes * this.m_nNodes))) {
                    continue;
                }
                boolean bl = this.m_bits[iBit] = !this.m_bits[iBit];
                if (!this.hasCycles()) break;
            }
            this.calcScore();
        }

        void crossOver(BayesNetRepresentation other) {
            boolean[] bits = new boolean[this.m_bits.length];
            for (int i2 = 0; i2 < this.m_bits.length; ++i2) {
                bits[i2] = this.m_bits[i2];
            }
            int iCrossOverPoint = this.m_bits.length;
            do {
                int i3;
                for (i3 = iCrossOverPoint; i3 < this.m_bits.length; ++i3) {
                    this.m_bits[i3] = bits[i3];
                }
                for (i3 = iCrossOverPoint = GeneticSearch.this.m_random.nextInt(this.m_bits.length); i3 < this.m_bits.length; ++i3) {
                    this.m_bits[i3] = other.m_bits[i3];
                }
            } while (this.hasCycles());
            this.calcScore();
        }

        boolean isSquare(int nNum) {
            if (GeneticSearch.this.g_bIsSquare == null || GeneticSearch.this.g_bIsSquare.length < nNum) {
                GeneticSearch.this.g_bIsSquare = new boolean[this.m_nNodes * this.m_nNodes];
                for (int i2 = 0; i2 < this.m_nNodes; ++i2) {
                    GeneticSearch.this.g_bIsSquare[i2 * this.m_nNodes + i2] = true;
                }
            }
            return GeneticSearch.this.g_bIsSquare[nNum];
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 11247 $");
        }
    }
}

