/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import java.io.Serializable;
import weka.classifiers.evaluation.Prediction;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class NominalPrediction
implements Prediction,
Serializable,
RevisionHandler {
    static final long serialVersionUID = -8871333992740492788L;
    private double[] m_Distribution;
    private double m_Actual = MISSING_VALUE;
    private double m_Predicted = MISSING_VALUE;
    private double m_Weight = 1.0;

    public NominalPrediction(double actual, double[] distribution) {
        this(actual, distribution, 1.0);
    }

    public NominalPrediction(double actual, double[] distribution, double weight) {
        if (distribution == null) {
            throw new NullPointerException("Null distribution in NominalPrediction.");
        }
        this.m_Actual = actual;
        this.m_Distribution = (double[])distribution.clone();
        this.m_Weight = weight;
        this.updatePredicted();
    }

    public double[] distribution() {
        return this.m_Distribution;
    }

    @Override
    public double actual() {
        return this.m_Actual;
    }

    @Override
    public double predicted() {
        return this.m_Predicted;
    }

    @Override
    public double weight() {
        return this.m_Weight;
    }

    public double margin() {
        if (this.m_Actual == MISSING_VALUE || this.m_Predicted == MISSING_VALUE) {
            return MISSING_VALUE;
        }
        double probActual = this.m_Distribution[(int)this.m_Actual];
        double probNext = 0.0;
        for (int i2 = 0; i2 < this.m_Distribution.length; ++i2) {
            if ((double)i2 == this.m_Actual || !(this.m_Distribution[i2] > probNext)) continue;
            probNext = this.m_Distribution[i2];
        }
        return probActual - probNext;
    }

    public static double[] makeDistribution(double predictedClass, int numClasses) {
        double[] dist = new double[numClasses];
        if (predictedClass == MISSING_VALUE) {
            return dist;
        }
        dist[(int)predictedClass] = 1.0;
        return dist;
    }

    public static double[] makeUniformDistribution(int numClasses) {
        double[] dist = new double[numClasses];
        for (int i2 = 0; i2 < numClasses; ++i2) {
            dist[i2] = 1.0 / (double)numClasses;
        }
        return dist;
    }

    private void updatePredicted() {
        int predictedClass = -1;
        double bestProb = 0.0;
        for (int i2 = 0; i2 < this.m_Distribution.length; ++i2) {
            if (!(this.m_Distribution[i2] > bestProb)) continue;
            predictedClass = i2;
            bestProb = this.m_Distribution[i2];
        }
        this.m_Predicted = predictedClass != -1 ? (double)predictedClass : MISSING_VALUE;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("NOM: ").append(this.actual()).append(" ").append(this.predicted());
        sb.append(' ').append(this.weight());
        double[] dist = this.distribution();
        for (int i2 = 0; i2 < dist.length; ++i2) {
            sb.append(' ').append(dist[i2]);
        }
        return sb.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

