/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import weka.core.Attribute;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.matrix.Matrix;

public class RegressionAnalysis {
    public static double calculateSSR(Instances data, Attribute chosen, double slope, double intercept) throws Exception {
        double ssr = 0.0;
        for (int i2 = 0; i2 < data.numInstances(); ++i2) {
            double yHat = slope * data.instance(i2).value(chosen) + intercept;
            double resid = data.instance(i2).value(data.classIndex()) - yHat;
            ssr += resid * resid;
        }
        return ssr;
    }

    public static double calculateRSquared(Instances data, double ssr) throws Exception {
        double yMean = data.meanOrMode(data.classIndex());
        double tss = 0.0;
        for (int i2 = 0; i2 < data.numInstances(); ++i2) {
            tss += (data.instance(i2).value(data.classIndex()) - yMean) * (data.instance(i2).value(data.classIndex()) - yMean);
        }
        double rsq = 1.0 - ssr / tss;
        return rsq;
    }

    public static double calculateAdjRSquared(double rsq, int n, int k) {
        if (n < 1 || k < 2 || n == k) {
            System.err.println("Cannot calculate Adjusted R^2.");
            return Double.NaN;
        }
        return 1.0 - (1.0 - rsq) * (double)(n - 1) / (double)(n - k);
    }

    public static double calculateFStat(double rsq, int n, int k) {
        if (n < 1 || k < 2 || n == k) {
            System.err.println("Cannot calculate F-stat.");
            return Double.NaN;
        }
        double numerator = rsq / (double)(k - 1);
        double denominator = (1.0 - rsq) / (double)(n - k);
        return numerator / denominator;
    }

    public static double[] calculateStdErrorOfCoef(Instances data, Attribute chosen, double slope, double intercept, int df) throws Exception {
        double ssr = RegressionAnalysis.calculateSSR(data, chosen, slope, intercept);
        double mse = ssr / (double)df;
        double[][] array = new double[data.numInstances()][2];
        for (int i2 = 0; i2 < data.numInstances(); ++i2) {
            array[i2][0] = data.instance(i2).value(chosen);
            array[i2][1] = 1.0;
        }
        Matrix X = new Matrix(array);
        Matrix Xt = X.transpose();
        Matrix XtX = Xt.times(X);
        Matrix inverse = XtX.inverse();
        Matrix cov = inverse.times(mse);
        double[] result = new double[2];
        for (int i3 = 0; i3 < 2; ++i3) {
            result[i3] = Math.sqrt(cov.get(i3, i3));
        }
        return result;
    }

    public static double[] calculateStdErrorOfCoef(Instances data, boolean[] selected, double ssr, int n, int k) throws Exception {
        double[][] array = new double[n][k];
        int column = 0;
        for (int j = 0; j < data.numAttributes(); ++j) {
            if (data.classIndex() == j || !selected[j]) continue;
            for (int i2 = 0; i2 < n; ++i2) {
                array[i2][column] = data.instance(i2).value(j);
            }
            ++column;
        }
        for (int i3 = 0; i3 < n; ++i3) {
            array[i3][k - 1] = 1.0;
        }
        Matrix X = new Matrix(array);
        Matrix Xt = X.transpose();
        Matrix XtX = Xt.times(X);
        Matrix inverse = XtX.inverse();
        double mse = ssr / (double)(n - k);
        Matrix cov = inverse.times(mse);
        double[] result = new double[k];
        for (int i4 = 0; i4 < k; ++i4) {
            result[i4] = Math.sqrt(cov.get(i4, i4));
        }
        return result;
    }

    public static double[] calculateTStats(double[] coef, double[] stderror, int k) {
        double[] result = new double[k];
        for (int i2 = 0; i2 < k; ++i2) {
            result[i2] = coef[i2] / stderror[i2];
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: ? $");
    }
}

