/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation.output.prediction;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.misc.InputMappedClassifier;
import weka.core.BatchPredictor;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.Utils;
import weka.core.WekaException;
import weka.core.converters.ConverterUtils;

public abstract class AbstractOutput
implements Serializable,
OptionHandler {
    private static final long serialVersionUID = 752696986017306241L;
    protected Instances m_Header = null;
    protected StringBuffer m_Buffer = null;
    protected StringBuffer m_FileBuffer;
    protected boolean m_OutputDistribution = false;
    protected Range m_Attributes = null;
    protected int m_NumDecimals = 3;
    protected File m_OutputFile = new File(".");
    protected boolean m_SuppressOutput = false;

    public AbstractOutput() {
        this.m_FileBuffer = new StringBuffer();
    }

    public abstract String globalInfo();

    public abstract String getDisplay();

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe range of attributes to print in addition to the classification.\n\t(default: none)", "p", 1, "-p <range>"));
        result.addElement(new Option("\tWhether to turn on the output of the class distribution.\n\tOnly for nominal class attributes.\n\t(default: off)", "distribution", 0, "-distribution"));
        result.addElement(new Option("\tThe number of digits after the decimal point.\n\t(default: " + this.getDefaultNumDecimals() + ")", "decimals", 1, "-decimals <num>"));
        result.addElement(new Option("\tThe file to store the output in, instead of outputting it on stdout.\n\tGets ignored if the supplied path is a directory.\n\t(default: .)", "file", 1, "-file <path>"));
        result.addElement(new Option("\tIn case the data gets stored in a file, then this flag can be used\n\tto suppress the regular output.\n\t(default: not suppressed)", "suppress", 0, "-suppress"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setAttributes(Utils.getOption("p", options));
        this.setOutputDistribution(Utils.getFlag("distribution", options));
        String tmpStr = Utils.getOption("decimals", options);
        if (tmpStr.length() > 0) {
            this.setNumDecimals(Integer.parseInt(tmpStr));
        } else {
            this.setNumDecimals(this.getDefaultNumDecimals());
        }
        tmpStr = Utils.getOption("file", options);
        if (tmpStr.length() > 0) {
            this.setOutputFile(new File(tmpStr));
        } else {
            this.setOutputFile(new File("."));
        }
        this.setSuppressOutput(Utils.getFlag("suppress", options));
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getAttributes().length() > 0) {
            result.add("-p");
            result.add(this.getAttributes());
        }
        if (this.getOutputDistribution()) {
            result.add("-distribution");
        }
        if (this.getNumDecimals() != this.getDefaultNumDecimals()) {
            result.add("-decimals");
            result.add("" + this.getNumDecimals());
        }
        if (!this.getOutputFile().isDirectory()) {
            result.add("-file");
            result.add(this.getOutputFile().getAbsolutePath());
            if (this.getSuppressOutput()) {
                result.add("-suppress");
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public void setHeader(Instances value) {
        if (value != null) {
            this.m_Header = new Instances(value, 0);
        }
    }

    public Instances getHeader() {
        return this.m_Header;
    }

    public void setBuffer(StringBuffer value) {
        this.m_Buffer = value;
    }

    public StringBuffer getBuffer() {
        return this.m_Buffer;
    }

    public void setAttributes(String value) {
        this.m_Attributes = value.length() == 0 ? null : new Range(value);
    }

    public String getAttributes() {
        if (this.m_Attributes == null) {
            return "";
        }
        return this.m_Attributes.getRanges();
    }

    public String attributesTipText() {
        return "The indices of the attributes to print in addition.";
    }

    public void setOutputDistribution(boolean value) {
        this.m_OutputDistribution = value;
    }

    public boolean getOutputDistribution() {
        return this.m_OutputDistribution;
    }

    public String outputDistributionTipText() {
        return "Whether to ouput the class distribution as well (only nominal class attributes).";
    }

    public int getDefaultNumDecimals() {
        return 3;
    }

    public void setNumDecimals(int value) {
        if (value >= 0) {
            this.m_NumDecimals = value;
        } else {
            System.err.println("Number of decimals cannot be negative (provided: " + value + ")!");
        }
    }

    public int getNumDecimals() {
        return this.m_NumDecimals;
    }

    public String numDecimalsTipText() {
        return "The number of digits to output after the decimal point.";
    }

    public void setOutputFile(File value) {
        this.m_OutputFile = value;
    }

    public File getOutputFile() {
        return this.m_OutputFile;
    }

    public String outputFileTipText() {
        return "The file to write the generated output to (disabled if path is a directory).";
    }

    public void setSuppressOutput(boolean value) {
        this.m_SuppressOutput = value;
    }

    public boolean getSuppressOutput() {
        return this.m_SuppressOutput;
    }

    public String suppressOutputTipText() {
        return "Whether to suppress the regular output when storing the output in a file.";
    }

    protected String checkBasic() {
        if (this.m_Buffer == null) {
            return "Buffer is null!";
        }
        if (this.m_Header == null) {
            return "No dataset structure provided!";
        }
        if (this.m_Attributes != null) {
            this.m_Attributes.setUpper(this.m_Header.numAttributes() - 1);
        }
        return null;
    }

    public boolean generatesOutput() {
        return this.m_OutputFile.isDirectory() || !this.m_OutputFile.isDirectory() && !this.m_SuppressOutput;
    }

    protected void append(String s) {
        if (this.generatesOutput()) {
            this.m_Buffer.append(s);
        }
        if (!this.m_OutputFile.isDirectory()) {
            this.m_FileBuffer.append(s);
        }
    }

    protected String checkHeader() {
        return this.checkBasic();
    }

    protected abstract void doPrintHeader();

    public void printHeader() {
        String error = this.checkHeader();
        if (error != null) {
            throw new IllegalStateException(error);
        }
        this.doPrintHeader();
    }

    protected abstract void doPrintClassification(Classifier var1, Instance var2, int var3) throws Exception;

    protected abstract void doPrintClassification(double[] var1, Instance var2, int var3) throws Exception;

    protected Instance preProcessInstance(Instance inst, Instance withMissing, Classifier classifier) throws Exception {
        if (classifier instanceof InputMappedClassifier) {
            inst = (Instance)inst.copy();
            inst = ((InputMappedClassifier)classifier).constructMappedInstance(inst);
            int mappedClass = ((InputMappedClassifier)classifier).getMappedClassIndex();
            withMissing.setMissing(mappedClass);
        } else {
            withMissing.setMissing(withMissing.classIndex());
        }
        return inst;
    }

    public void printClassification(Classifier classifier, Instance inst, int index) throws Exception {
        String error = this.checkBasic();
        if (error != null) {
            throw new WekaException(error);
        }
        this.doPrintClassification(classifier, inst, index);
    }

    public void printClassification(double[] dist, Instance inst, int index) throws Exception {
        String error = this.checkBasic();
        if (error != null) {
            throw new WekaException(error);
        }
        this.doPrintClassification(dist, inst, index);
    }

    public void printClassifications(Classifier classifier, ConverterUtils.DataSource testset) throws Exception {
        int i2 = 0;
        testset.reset();
        if (classifier instanceof BatchPredictor && ((BatchPredictor)((Object)classifier)).implementsMoreEfficientBatchPrediction()) {
            Instances test = testset.getDataSet(this.m_Header.classIndex());
            double[][] predictions = ((BatchPredictor)((Object)classifier)).distributionsForInstances(test);
            for (i2 = 0; i2 < test.numInstances(); ++i2) {
                this.printClassification(predictions[i2], test.instance(i2), i2);
            }
        } else {
            Instances test = testset.getStructure(this.m_Header.classIndex());
            while (testset.hasMoreElements(test)) {
                Instance inst = testset.nextElement(test);
                this.doPrintClassification(classifier, inst, i2);
                ++i2;
            }
        }
    }

    public void printClassifications(Classifier classifier, Instances testset) throws Exception {
        if (classifier instanceof BatchPredictor && ((BatchPredictor)((Object)classifier)).implementsMoreEfficientBatchPrediction()) {
            double[][] predictions = ((BatchPredictor)((Object)classifier)).distributionsForInstances(testset);
            for (int i2 = 0; i2 < testset.numInstances(); ++i2) {
                this.printClassification(predictions[i2], testset.instance(i2), i2);
            }
        } else {
            for (int i3 = 0; i3 < testset.numInstances(); ++i3) {
                this.doPrintClassification(classifier, testset.instance(i3), i3);
            }
        }
    }

    protected abstract void doPrintFooter();

    public void printFooter() throws Exception {
        String error = this.checkBasic();
        if (error != null) {
            throw new WekaException(error);
        }
        this.doPrintFooter();
        if (!this.m_OutputFile.isDirectory()) {
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(this.m_OutputFile));
                writer.write(this.m_FileBuffer.toString());
                writer.newLine();
                writer.flush();
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void print(Classifier classifier, ConverterUtils.DataSource testset) throws Exception {
        this.printHeader();
        this.printClassifications(classifier, testset);
        this.printFooter();
    }

    public void print(Classifier classifier, Instances testset) throws Exception {
        this.printHeader();
        this.printClassifications(classifier, testset);
        this.printFooter();
    }

    public static AbstractOutput fromCommandline(String cmdline) {
        AbstractOutput result;
        try {
            String[] options = Utils.splitOptions(cmdline);
            String classname = options[0];
            options[0] = "";
            result = (AbstractOutput)Utils.forName(AbstractOutput.class, classname, options);
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }
}

