/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class VotedPerceptron
extends AbstractClassifier
implements OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -1072429260104568698L;
    private int m_MaxK = 10000;
    private int m_NumIterations = 1;
    private double m_Exponent = 1.0;
    private int m_K = 0;
    private int[] m_Additions = null;
    private boolean[] m_IsAddition = null;
    private int[] m_Weights = null;
    private Instances m_Train = null;
    private int m_Seed = 1;
    private NominalToBinary m_NominalToBinary;
    private ReplaceMissingValues m_ReplaceMissingValues;

    public String globalInfo() {
        return "Implementation of the voted perceptron algorithm by Freund and Schapire. Globally replaces all missing values, and transforms nominal attributes into binary ones.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Y. Freund and R. E. Schapire");
        result.setValue(TechnicalInformation.Field.TITLE, "Large margin classification using the perceptron algorithm");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "11th Annual Conference on Computational Learning Theory");
        result.setValue(TechnicalInformation.Field.YEAR, "1998");
        result.setValue(TechnicalInformation.Field.PAGES, "209-217");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "ACM Press");
        result.setValue(TechnicalInformation.Field.ADDRESS, "New York, NY");
        return result;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(4);
        newVector.addElement(new Option("\tThe number of iterations to be performed.\n\t(default 1)", "I", 1, "-I <int>"));
        newVector.addElement(new Option("\tThe exponent for the polynomial kernel.\n\t(default 1)", "E", 1, "-E <double>"));
        newVector.addElement(new Option("\tThe seed for the random number generation.\n\t(default 1)", "S", 1, "-S <int>"));
        newVector.addElement(new Option("\tThe maximum number of alterations allowed.\n\t(default 10000)", "M", 1, "-M <int>"));
        newVector.addAll(Collections.list(super.listOptions()));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String iterationsString = Utils.getOption('I', options);
        this.m_NumIterations = iterationsString.length() != 0 ? Integer.parseInt(iterationsString) : 1;
        String exponentsString = Utils.getOption('E', options);
        this.m_Exponent = exponentsString.length() != 0 ? new Double(exponentsString) : 1.0;
        String seedString = Utils.getOption('S', options);
        this.m_Seed = seedString.length() != 0 ? Integer.parseInt(seedString) : 1;
        String alterationsString = Utils.getOption('M', options);
        this.m_MaxK = alterationsString.length() != 0 ? Integer.parseInt(alterationsString) : 10000;
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-I");
        options.add("" + this.m_NumIterations);
        options.add("-E");
        options.add("" + this.m_Exponent);
        options.add("-S");
        options.add("" + this.m_Seed);
        options.add("-M");
        options.add("" + this.m_MaxK);
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.BINARY_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    @Override
    public void buildClassifier(Instances insts) throws Exception {
        this.getCapabilities().testWithFail(insts);
        insts = new Instances(insts);
        insts.deleteWithMissingClass();
        this.m_Train = new Instances(insts);
        this.m_ReplaceMissingValues = new ReplaceMissingValues();
        this.m_ReplaceMissingValues.setInputFormat(this.m_Train);
        this.m_Train = Filter.useFilter(this.m_Train, this.m_ReplaceMissingValues);
        this.m_NominalToBinary = new NominalToBinary();
        this.m_NominalToBinary.setInputFormat(this.m_Train);
        this.m_Train = Filter.useFilter(this.m_Train, this.m_NominalToBinary);
        this.m_Train.randomize(new Random(this.m_Seed));
        this.m_Additions = new int[this.m_MaxK + 1];
        this.m_IsAddition = new boolean[this.m_MaxK + 1];
        this.m_Weights = new int[this.m_MaxK + 1];
        this.m_K = 0;
        block0: for (int it = 0; it < this.m_NumIterations; ++it) {
            for (int i2 = 0; i2 < this.m_Train.numInstances(); ++i2) {
                int classValue;
                Instance inst = this.m_Train.instance(i2);
                if (inst.classIsMissing()) continue;
                int prediction = this.makePrediction(this.m_K, inst);
                if (prediction == (classValue = (int)inst.classValue())) {
                    int n = this.m_K;
                    this.m_Weights[n] = this.m_Weights[n] + 1;
                } else {
                    this.m_IsAddition[this.m_K] = classValue == 1;
                    this.m_Additions[this.m_K] = i2;
                    int n = ++this.m_K;
                    this.m_Weights[n] = this.m_Weights[n] + 1;
                }
                if (this.m_K == this.m_MaxK) break block0;
            }
        }
    }

    @Override
    public double[] distributionForInstance(Instance inst) throws Exception {
        this.m_ReplaceMissingValues.input(inst);
        this.m_ReplaceMissingValues.batchFinished();
        inst = this.m_ReplaceMissingValues.output();
        this.m_NominalToBinary.input(inst);
        this.m_NominalToBinary.batchFinished();
        inst = this.m_NominalToBinary.output();
        double output = 0.0;
        double sumSoFar = 0.0;
        if (this.m_K > 0) {
            for (int i2 = 0; i2 <= this.m_K; ++i2) {
                output = sumSoFar < 0.0 ? (output -= (double)this.m_Weights[i2]) : (output += (double)this.m_Weights[i2]);
                if (this.m_IsAddition[i2]) {
                    sumSoFar += this.innerProduct(this.m_Train.instance(this.m_Additions[i2]), inst);
                    continue;
                }
                sumSoFar -= this.innerProduct(this.m_Train.instance(this.m_Additions[i2]), inst);
            }
        }
        double[] result = new double[2];
        result[1] = 1.0 / (1.0 + Math.exp(-output));
        result[0] = 1.0 - result[1];
        return result;
    }

    public String toString() {
        return "VotedPerceptron: Number of perceptrons=" + this.m_K;
    }

    public String maxKTipText() {
        return "The maximum number of alterations to the perceptron.";
    }

    public int getMaxK() {
        return this.m_MaxK;
    }

    public void setMaxK(int v) {
        this.m_MaxK = v;
    }

    public String numIterationsTipText() {
        return "Number of iterations to be performed.";
    }

    public int getNumIterations() {
        return this.m_NumIterations;
    }

    public void setNumIterations(int v) {
        this.m_NumIterations = v;
    }

    public String exponentTipText() {
        return "Exponent for the polynomial kernel.";
    }

    public double getExponent() {
        return this.m_Exponent;
    }

    public void setExponent(double v) {
        this.m_Exponent = v;
    }

    public String seedTipText() {
        return "Seed for the random number generator.";
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public void setSeed(int v) {
        this.m_Seed = v;
    }

    private double innerProduct(Instance i1, Instance i2) throws Exception {
        double result = 0.0;
        int n1 = i1.numValues();
        int n2 = i2.numValues();
        int classIndex = this.m_Train.classIndex();
        int p1 = 0;
        int p2 = 0;
        while (p1 < n1 && p2 < n2) {
            int ind2;
            int ind1 = i1.index(p1);
            if (ind1 == (ind2 = i2.index(p2))) {
                if (ind1 != classIndex) {
                    result += i1.valueSparse(p1) * i2.valueSparse(p2);
                }
                ++p1;
                ++p2;
                continue;
            }
            if (ind1 > ind2) {
                ++p2;
                continue;
            }
            ++p1;
        }
        result += 1.0;
        if (this.m_Exponent != 1.0) {
            return Math.pow(result, this.m_Exponent);
        }
        return result;
    }

    private int makePrediction(int k, Instance inst) throws Exception {
        double result = 0.0;
        for (int i2 = 0; i2 < k; ++i2) {
            if (this.m_IsAddition[i2]) {
                result += this.innerProduct(this.m_Train.instance(this.m_Additions[i2]), inst);
                continue;
            }
            result -= this.innerProduct(this.m_Train.instance(this.m_Additions[i2]), inst);
        }
        if (result < 0.0) {
            return 0;
        }
        return 1;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10141 $");
    }

    public static void main(String[] argv) {
        VotedPerceptron.runClassifier(new VotedPerceptron(), argv);
    }
}

