/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.functions.SMOreg;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.functions.supportVector.SMOset;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class RegOptimizer
implements OptionHandler,
Serializable,
RevisionHandler {
    private static final long serialVersionUID = -2198266997254461814L;
    public double[] m_alpha;
    public double[] m_alphaStar;
    protected double m_b;
    protected double m_epsilon = 0.001;
    protected double m_C = 1.0;
    protected double[] m_target;
    protected Instances m_data;
    protected Kernel m_kernel;
    protected int m_classIndex = -1;
    protected int m_nInstances = -1;
    protected Random m_random = new Random(this.m_nSeed);
    protected int m_nSeed = 1;
    protected SMOset m_supportVectors;
    protected long m_nEvals = 0L;
    protected int m_nCacheHits = -1;
    protected double[] m_weights;
    protected double[] m_sparseWeights;
    protected int[] m_sparseIndices;
    protected boolean m_bModelBuilt = false;
    protected SMOreg m_SVM = null;

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe epsilon parameter in epsilon-insensitive loss function.\n\t(default 1.0e-3)", "L", 1, "-L <double>"));
        result.addElement(new Option("\tThe random number seed.\n\t(default 1)", "W", 1, "-W <double>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('L', options);
        if (tmpStr.length() != 0) {
            this.setEpsilonParameter(Double.parseDouble(tmpStr));
        } else {
            this.setEpsilonParameter(0.001);
        }
        tmpStr = Utils.getOption('W', options);
        if (tmpStr.length() != 0) {
            this.setSeed(Integer.parseInt(tmpStr));
        } else {
            this.setSeed(1);
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-L");
        result.add("" + this.getEpsilonParameter());
        result.add("-W");
        result.add("" + this.getSeed());
        return result.toArray(new String[result.size()]);
    }

    public boolean modelBuilt() {
        return this.m_bModelBuilt;
    }

    public void setSMOReg(SMOreg value) {
        this.m_SVM = value;
    }

    public long getKernelEvaluations() {
        return this.m_nEvals;
    }

    public int getCacheHits() {
        return this.m_nCacheHits;
    }

    protected void init(Instances data) throws Exception {
        if (this.m_SVM == null) {
            throw new Exception("SVM not initialized in optimizer. Use RegOptimizer.setSVMReg()");
        }
        this.m_C = this.m_SVM.getC();
        this.m_data = data;
        this.m_classIndex = data.classIndex();
        this.m_nInstances = data.numInstances();
        this.m_kernel = Kernel.makeCopy(this.m_SVM.getKernel());
        this.m_kernel.buildKernel(data);
        this.m_target = new double[this.m_nInstances];
        for (int i2 = 0; i2 < this.m_nInstances; ++i2) {
            this.m_target[i2] = data.instance(i2).classValue();
        }
        this.m_random = new Random(this.m_nSeed);
        this.m_alpha = new double[this.m_target.length];
        this.m_alphaStar = new double[this.m_target.length];
        this.m_supportVectors = new SMOset(this.m_nInstances);
        this.m_b = 0.0;
        this.m_nEvals = 0L;
        this.m_nCacheHits = -1;
    }

    protected void wrapUp() throws Exception {
        this.m_target = null;
        this.m_nEvals = this.m_kernel.numEvals();
        this.m_nCacheHits = this.m_kernel.numCacheHits();
        if (this.m_SVM.getKernel() instanceof PolyKernel && ((PolyKernel)this.m_SVM.getKernel()).getExponent() == 1.0) {
            double[] weights = new double[this.m_data.numAttributes()];
            int k = this.m_supportVectors.getNext(-1);
            while (k != -1) {
                for (int j = 0; j < weights.length; ++j) {
                    if (j == this.m_classIndex) continue;
                    int n = j;
                    weights[n] = weights[n] + (this.m_alpha[k] - this.m_alphaStar[k]) * this.m_data.instance(k).value(j);
                }
                k = this.m_supportVectors.getNext(k);
            }
            this.m_weights = weights;
            this.m_alpha = null;
            this.m_alphaStar = null;
            this.m_kernel = null;
        } else {
            this.m_kernel.clean();
        }
        this.m_bModelBuilt = true;
    }

    protected double getScore() throws Exception {
        double res = 0.0;
        double t = 0.0;
        double t2 = 0.0;
        for (int i2 = 0; i2 < this.m_nInstances; ++i2) {
            for (int j = 0; j < this.m_nInstances; ++j) {
                t += (this.m_alpha[i2] - this.m_alphaStar[i2]) * (this.m_alpha[j] - this.m_alphaStar[j]) * this.m_kernel.eval(i2, j, this.m_data.instance(i2));
            }
            t2 += this.m_target[i2] * (this.m_alpha[i2] - this.m_alphaStar[i2]) - this.m_epsilon * (this.m_alpha[i2] + this.m_alphaStar[i2]);
        }
        return res += -0.5 * t + t2;
    }

    public void buildClassifier(Instances data) throws Exception {
        throw new Exception("Don't call this directly, use subclass instead");
    }

    protected double SVMOutput(int index) throws Exception {
        double result = -this.m_b;
        int i2 = this.m_supportVectors.getNext(-1);
        while (i2 != -1) {
            result += (this.m_alpha[i2] - this.m_alphaStar[i2]) * this.m_kernel.eval(index, i2, this.m_data.instance(index));
            i2 = this.m_supportVectors.getNext(i2);
        }
        return result;
    }

    public double SVMOutput(Instance inst) throws Exception {
        double result = -this.m_b;
        if (this.m_weights != null) {
            for (int i2 = 0; i2 < inst.numValues(); ++i2) {
                if (inst.index(i2) == this.m_classIndex) continue;
                result += this.m_weights[inst.index(i2)] * inst.valueSparse(i2);
            }
        } else {
            int i3 = this.m_supportVectors.getNext(-1);
            while (i3 != -1) {
                result += (this.m_alpha[i3] - this.m_alphaStar[i3]) * this.m_kernel.eval(-1, i3, inst);
                i3 = this.m_supportVectors.getNext(i3);
            }
        }
        return result;
    }

    public String seedTipText() {
        return "Seed for random number generator.";
    }

    public int getSeed() {
        return this.m_nSeed;
    }

    public void setSeed(int value) {
        this.m_nSeed = value;
    }

    public String epsilonParameterTipText() {
        return "The epsilon parameter of the epsilon insensitive loss function.(default 0.001).";
    }

    public double getEpsilonParameter() {
        return this.m_epsilon;
    }

    public void setEpsilonParameter(double v) {
        this.m_epsilon = v;
    }

    public String toString() {
        int i2;
        StringBuffer text = new StringBuffer();
        text.append("SMOreg\n\n");
        if (this.m_weights != null) {
            text.append("weights (not support vectors):\n");
            for (i2 = 0; i2 < this.m_data.numAttributes(); ++i2) {
                if (i2 == this.m_classIndex) continue;
                text.append((this.m_weights[i2] >= 0.0 ? " + " : " - ") + Utils.doubleToString(Math.abs(this.m_weights[i2]), 12, 4) + " * ");
                if (this.m_SVM.getFilterType().getSelectedTag().getID() == 1) {
                    text.append("(standardized) ");
                } else if (this.m_SVM.getFilterType().getSelectedTag().getID() == 0) {
                    text.append("(normalized) ");
                }
                text.append(this.m_data.attribute(i2).name() + "\n");
            }
        } else {
            text.append("Support vectors:\n");
            for (i2 = 0; i2 < this.m_nInstances; ++i2) {
                if (this.m_alpha[i2] > 0.0) {
                    text.append("+" + this.m_alpha[i2] + " * k[" + i2 + "]\n");
                }
                if (!(this.m_alphaStar[i2] > 0.0)) continue;
                text.append("-" + this.m_alphaStar[i2] + " * k[" + i2 + "]\n");
            }
        }
        text.append((this.m_b <= 0.0 ? " + " : " - ") + Utils.doubleToString(Math.abs(this.m_b), 12, 4) + "\n\n");
        text.append("\n\nNumber of kernel evaluations: " + this.m_nEvals);
        if (this.m_nCacheHits >= 0 && this.m_nEvals > 0L) {
            double hitRatio = 1.0 - (double)this.m_nEvals * 1.0 / (double)((long)this.m_nCacheHits + this.m_nEvals);
            text.append(" (" + Utils.doubleToString(hitRatio * 100.0, 7, 3).trim() + "% cached)");
        }
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 12533 $");
    }
}

