/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.lazy.kstar;

import java.io.Serializable;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class KStarCache
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -7693632394267140678L;
    CacheTable m_Cache = new CacheTable();

    public void store(double key, double value, double pmiss) {
        if (!this.m_Cache.containsKey(key)) {
            this.m_Cache.insert(key, value, pmiss);
        }
    }

    public boolean containsKey(double key) {
        return this.m_Cache.containsKey(key);
    }

    public TableEntry getCacheValues(double key) {
        if (this.m_Cache.containsKey(key)) {
            return this.m_Cache.getEntry(key);
        }
        return null;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10153 $");
    }

    public class TableEntry
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = 4057602386766259138L;
        public int hash;
        public double key;
        public double value;
        public double pmiss;
        public TableEntry next = null;

        public TableEntry(int hash, double key, double value, double pmiss, TableEntry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.pmiss = pmiss;
            this.next = next;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 10153 $");
        }
    }

    public class CacheTable
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = -8086106452588253423L;
        private TableEntry[] m_Table;
        private int m_Count;
        private int m_Threshold;
        private final float m_LoadFactor;
        private final double EPSILON = 1.0E-5;

        public CacheTable(int size, float loadFactor) {
            this.m_Table = new TableEntry[size];
            this.m_LoadFactor = loadFactor;
            this.m_Threshold = (int)((float)size * loadFactor);
            this.m_Count = 0;
        }

        public CacheTable() {
            this(101, 0.75f);
        }

        public boolean containsKey(double key) {
            TableEntry[] table = this.m_Table;
            int hash = this.hashCode(key);
            int index = (hash & Integer.MAX_VALUE) % table.length;
            TableEntry e = table[index];
            while (e != null) {
                if (e.hash == hash && Math.abs(e.key - key) < 1.0E-5) {
                    return true;
                }
                e = e.next;
            }
            return false;
        }

        public void insert(double key, double value, double pmiss) {
            TableEntry ne;
            TableEntry[] table = this.m_Table;
            int hash = this.hashCode(key);
            int index = (hash & Integer.MAX_VALUE) % table.length;
            TableEntry e = table[index];
            while (e != null) {
                if (e.hash == hash && Math.abs(e.key - key) < 1.0E-5) {
                    return;
                }
                e = e.next;
            }
            table[index] = ne = new TableEntry(hash, key, value, pmiss, table[index]);
            ++this.m_Count;
            if (this.m_Count >= this.m_Threshold) {
                this.rehash();
            }
        }

        public TableEntry getEntry(double key) {
            TableEntry[] table = this.m_Table;
            int hash = this.hashCode(key);
            int index = (hash & Integer.MAX_VALUE) % table.length;
            TableEntry e = table[index];
            while (e != null) {
                if (e.hash == hash && Math.abs(e.key - key) < 1.0E-5) {
                    return e;
                }
                e = e.next;
            }
            return null;
        }

        public int size() {
            return this.m_Count;
        }

        public boolean isEmpty() {
            return this.m_Count == 0;
        }

        public void clear() {
            TableEntry[] table = this.m_Table;
            int index = table.length;
            while (--index >= 0) {
                table[index] = null;
            }
            this.m_Count = 0;
        }

        private void rehash() {
            int oldCapacity = this.m_Table.length;
            TableEntry[] oldTable = this.m_Table;
            int newCapacity = oldCapacity * 2 + 1;
            TableEntry[] newTable = new TableEntry[newCapacity];
            this.m_Threshold = (int)((float)newCapacity * this.m_LoadFactor);
            this.m_Table = newTable;
            int i2 = oldCapacity;
            while (i2-- > 0) {
                TableEntry old = oldTable[i2];
                while (old != null) {
                    TableEntry e = old;
                    old = old.next;
                    int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                    e.next = newTable[index];
                    newTable[index] = e;
                }
            }
        }

        private int hashCode(double key) {
            long bits = Double.doubleToLongBits(key);
            return (int)(bits ^ bits >> 32);
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 10153 $");
        }
    }
}

