/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.ConditionalDensityEstimator;
import weka.classifiers.IntervalEstimator;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.trees.J48;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializedObject;
import weka.core.TechnicalInformation;
import weka.core.Utils;
import weka.estimators.UnivariateDensityEstimator;
import weka.estimators.UnivariateEqualFrequencyHistogramEstimator;
import weka.estimators.UnivariateIntervalEstimator;
import weka.estimators.UnivariateQuantileEstimator;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Discretize;

public class RegressionByDiscretization
extends SingleClassifierEnhancer
implements IntervalEstimator,
ConditionalDensityEstimator {
    static final long serialVersionUID = 5066426153134050378L;
    protected Discretize m_Discretizer = new Discretize();
    protected int m_NumBins = 10;
    protected double[] m_ClassMeans;
    protected int[] m_ClassCounts;
    protected boolean m_DeleteEmptyBins;
    protected int[] m_OldIndexToNewIndex;
    protected Instances m_DiscretizedHeader = null;
    protected boolean m_UseEqualFrequency = false;
    protected boolean m_MinimizeAbsoluteError = false;
    protected UnivariateDensityEstimator m_Estimator = new UnivariateEqualFrequencyHistogramEstimator();
    protected double[] m_OriginalTargetValues = null;
    protected int[] m_NewTargetValues = null;

    public String globalInfo() {
        return "A regression scheme that employs any classifier on a copy of the data that has the class attribute discretized. The predicted value is the expected value of the mean class value for each discretized interval (based on the predicted probabilities for each interval). This class now also supports conditional density estimation by building a univariate density estimator from the target values in the training data, weighted by the class probabilities. \n\nFor more information on this process, see\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Eibe Frank and Remco R. Bouckaert");
        result.setValue(TechnicalInformation.Field.TITLE, "Conditional Density Estimation with Class Probability Estimators");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "First Asian Conference on Machine Learning");
        result.setValue(TechnicalInformation.Field.YEAR, "2009");
        result.setValue(TechnicalInformation.Field.PAGES, "65-81");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Springer Verlag");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Berlin");
        return result;
    }

    @Override
    protected String defaultClassifierString() {
        return "weka.classifiers.trees.J48";
    }

    public RegressionByDiscretization() {
        this.m_Classifier = new J48();
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAllClasses();
        result.disableAllClassDependencies();
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.setMinimumNumberInstances(2);
        return result;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        int i2;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_Discretizer.setIgnoreClass(true);
        this.m_Discretizer.setAttributeIndices("" + (instances.classIndex() + 1));
        this.m_Discretizer.setBins(this.getNumBins());
        this.m_Discretizer.setUseEqualFrequency(this.getUseEqualFrequency());
        this.m_Discretizer.setInputFormat(instances);
        Instances newTrain = Filter.useFilter(instances, this.m_Discretizer);
        this.m_OldIndexToNewIndex = null;
        if (this.m_DeleteEmptyBins) {
            int numNonEmptyClasses = 0;
            boolean[] notEmptyClass = new boolean[newTrain.numClasses()];
            for (int i3 = 0; i3 < newTrain.numInstances(); ++i3) {
                if (notEmptyClass[(int)newTrain.instance(i3).classValue()]) continue;
                ++numNonEmptyClasses;
                notEmptyClass[(int)newTrain.instance((int)i3).classValue()] = true;
            }
            ArrayList<String> newClassVals = new ArrayList<String>(numNonEmptyClasses);
            this.m_OldIndexToNewIndex = new int[newTrain.numClasses()];
            for (int i4 = 0; i4 < newTrain.numClasses(); ++i4) {
                if (!notEmptyClass[i4]) continue;
                this.m_OldIndexToNewIndex[i4] = newClassVals.size();
                newClassVals.add(newTrain.classAttribute().value(i4));
            }
            Attribute newClass = new Attribute(newTrain.classAttribute().name(), newClassVals);
            ArrayList<Attribute> newAttributes = new ArrayList<Attribute>(newTrain.numAttributes());
            for (int i5 = 0; i5 < newTrain.numAttributes(); ++i5) {
                if (i5 != newTrain.classIndex()) {
                    newAttributes.add((Attribute)newTrain.attribute(i5).copy());
                    continue;
                }
                newAttributes.add(newClass);
            }
            Instances newTrainTransformed = new Instances(newTrain.relationName(), newAttributes, newTrain.numInstances());
            newTrainTransformed.setClassIndex(newTrain.classIndex());
            for (int i6 = 0; i6 < newTrain.numInstances(); ++i6) {
                Instance inst = newTrain.instance(i6);
                newTrainTransformed.add(inst);
                newTrainTransformed.lastInstance().setClassValue(this.m_OldIndexToNewIndex[(int)inst.classValue()]);
            }
            newTrain = newTrainTransformed;
        }
        this.m_OriginalTargetValues = new double[instances.numInstances()];
        this.m_NewTargetValues = new int[instances.numInstances()];
        for (int i7 = 0; i7 < this.m_OriginalTargetValues.length; ++i7) {
            this.m_OriginalTargetValues[i7] = instances.instance(i7).classValue();
            this.m_NewTargetValues[i7] = (int)newTrain.instance(i7).classValue();
        }
        this.m_DiscretizedHeader = new Instances(newTrain, 0);
        int numClasses = newTrain.numClasses();
        this.m_ClassMeans = new double[numClasses];
        this.m_ClassCounts = new int[numClasses];
        for (i2 = 0; i2 < instances.numInstances(); ++i2) {
            int classVal;
            Instance inst = newTrain.instance(i2);
            if (inst.classIsMissing()) continue;
            int n = classVal = (int)inst.classValue();
            this.m_ClassCounts[n] = this.m_ClassCounts[n] + 1;
            int n2 = classVal;
            this.m_ClassMeans[n2] = this.m_ClassMeans[n2] + instances.instance(i2).classValue();
        }
        for (i2 = 0; i2 < numClasses; ++i2) {
            if (this.m_ClassCounts[i2] <= 0) continue;
            int n = i2;
            this.m_ClassMeans[n] = this.m_ClassMeans[n] / (double)this.m_ClassCounts[i2];
        }
        if (this.m_Debug) {
            System.out.println("Bin Means");
            System.out.println("==========");
            for (i2 = 0; i2 < this.m_ClassMeans.length; ++i2) {
                System.out.println(this.m_ClassMeans[i2]);
            }
            System.out.println();
        }
        this.m_Classifier.buildClassifier(newTrain);
    }

    protected UnivariateDensityEstimator getDensityEstimator(Instance instance, boolean print) throws Exception {
        UnivariateDensityEstimator e = (UnivariateDensityEstimator)new SerializedObject(this.m_Estimator).getObject();
        if (e instanceof UnivariateEqualFrequencyHistogramEstimator) {
            ((UnivariateEqualFrequencyHistogramEstimator)e).setNumBins(this.getNumBins());
            for (int i2 = 0; i2 < this.m_OriginalTargetValues.length; ++i2) {
                e.addValue(this.m_OriginalTargetValues[i2], 1.0);
            }
            ((UnivariateEqualFrequencyHistogramEstimator)e).initializeStatistics();
            ((UnivariateEqualFrequencyHistogramEstimator)e).setUpdateWeightsOnly(true);
        }
        this.m_Discretizer.input(instance);
        this.m_Discretizer.batchFinished();
        Instance newInstance = this.m_Discretizer.output();
        if (this.m_OldIndexToNewIndex != null) {
            newInstance.setClassValue(this.m_OldIndexToNewIndex[(int)newInstance.classValue()]);
        }
        newInstance.setDataset(this.m_DiscretizedHeader);
        double[] probs = this.m_Classifier.distributionForInstance(newInstance);
        for (int i3 = 0; i3 < this.m_OriginalTargetValues.length; ++i3) {
            e.addValue(this.m_OriginalTargetValues[i3], probs[this.m_NewTargetValues[i3]] * (double)this.m_OriginalTargetValues.length / (double)this.m_ClassCounts[this.m_NewTargetValues[i3]]);
        }
        return e;
    }

    @Override
    public double[][] predictIntervals(Instance instance, double confidenceLevel) throws Exception {
        UnivariateIntervalEstimator e = (UnivariateIntervalEstimator)((Object)this.getDensityEstimator(instance, false));
        return e.predictIntervals(confidenceLevel);
    }

    @Override
    public double logDensity(Instance instance, double value) throws Exception {
        UnivariateDensityEstimator e = this.getDensityEstimator(instance, true);
        return e.logDensity(value);
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        this.m_Discretizer.input(instance);
        this.m_Discretizer.batchFinished();
        Instance newInstance = this.m_Discretizer.output();
        if (this.m_OldIndexToNewIndex != null) {
            newInstance.setClassValue(this.m_OldIndexToNewIndex[(int)newInstance.classValue()]);
        }
        newInstance.setDataset(this.m_DiscretizedHeader);
        double[] probs = this.m_Classifier.distributionForInstance(newInstance);
        if (!this.m_MinimizeAbsoluteError) {
            double prediction = 0.0;
            double probSum = 0.0;
            for (int j = 0; j < probs.length; ++j) {
                prediction += probs[j] * this.m_ClassMeans[j];
                probSum += probs[j];
            }
            return prediction / probSum;
        }
        UnivariateQuantileEstimator e = (UnivariateQuantileEstimator)((Object)this.getDensityEstimator(instance, true));
        return e.predictQuantile(0.5);
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(5);
        newVector.addElement(new Option("\tNumber of bins for equal-width discretization\n\t(default 10).\n", "B", 1, "-B <int>"));
        newVector.addElement(new Option("\tWhether to delete empty bins after discretization\n\t(default false).\n", "E", 0, "-E"));
        newVector.addElement(new Option("\tWhether to minimize absolute error, rather than squared error.\n\t(default false).\n", "A", 0, "-A"));
        newVector.addElement(new Option("\tUse equal-frequency instead of equal-width discretization.", "F", 0, "-F"));
        newVector.addElement(new Option("\tThe density estimator to use (including parameters).", "K", 1, "-K <estimator name and parameters"));
        newVector.addAll(Collections.list(super.listOptions()));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String binsString = Utils.getOption('B', options);
        if (binsString.length() != 0) {
            this.setNumBins(Integer.parseInt(binsString));
        } else {
            this.setNumBins(10);
        }
        this.setDeleteEmptyBins(Utils.getFlag('E', options));
        this.setUseEqualFrequency(Utils.getFlag('F', options));
        this.setMinimizeAbsoluteError(Utils.getFlag('A', options));
        String tmpStr = Utils.getOption('K', options);
        String[] tmpOptions = Utils.splitOptions(tmpStr);
        if (tmpOptions.length != 0) {
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.setEstimator((UnivariateDensityEstimator)Utils.forName(UnivariateDensityEstimator.class, tmpStr, tmpOptions));
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-B");
        options.add("" + this.getNumBins());
        if (this.getDeleteEmptyBins()) {
            options.add("-E");
        }
        if (this.getUseEqualFrequency()) {
            options.add("-F");
        }
        if (this.getMinimizeAbsoluteError()) {
            options.add("-A");
        }
        options.add("-K");
        if (this.getEstimator() instanceof OptionHandler) {
            options.add("" + this.getEstimator().getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)this.getEstimator())).getOptions()));
        } else {
            options.add("" + this.getEstimator().getClass().getName());
        }
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    public String numBinsTipText() {
        return "Number of bins for discretization.";
    }

    public int getNumBins() {
        return this.m_NumBins;
    }

    public void setNumBins(int numBins) {
        this.m_NumBins = numBins;
    }

    public String deleteEmptyBinsTipText() {
        return "Whether to delete empty bins after discretization.";
    }

    public boolean getDeleteEmptyBins() {
        return this.m_DeleteEmptyBins;
    }

    public void setDeleteEmptyBins(boolean b) {
        this.m_DeleteEmptyBins = b;
    }

    public String minimizeAbsoluteErrorTipText() {
        return "Whether to minimize absolute error.";
    }

    public boolean getMinimizeAbsoluteError() {
        return this.m_MinimizeAbsoluteError;
    }

    public void setMinimizeAbsoluteError(boolean b) {
        this.m_MinimizeAbsoluteError = b;
    }

    public String useEqualFrequencyTipText() {
        return "If set to true, equal-frequency binning will be used instead of equal-width binning.";
    }

    public boolean getUseEqualFrequency() {
        return this.m_UseEqualFrequency;
    }

    public void setUseEqualFrequency(boolean newUseEqualFrequency) {
        this.m_UseEqualFrequency = newUseEqualFrequency;
    }

    public String estimatorTipText() {
        return "The density estimator to use.";
    }

    public UnivariateDensityEstimator getEstimator() {
        return this.m_Estimator;
    }

    public void setEstimator(UnivariateDensityEstimator estimator) {
        this.m_Estimator = estimator;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append("Regression by discretization");
        if (this.m_ClassMeans == null) {
            text.append(": No model built yet.");
        } else {
            text.append("\n\nClass attribute discretized into " + this.m_ClassMeans.length + " values\n");
            text.append("\nClassifier spec: " + this.getClassifierSpec() + "\n");
            text.append(this.m_Classifier.toString());
        }
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 11326 $");
    }

    public static void main(String[] argv) {
        RegressionByDiscretization.runClassifier(new RegressionByDiscretization(), argv);
    }
}

