/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.pmml.consumer;

import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.classifiers.pmml.consumer.PMMLClassifier;
import weka.core.Attribute;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.pmml.Array;
import weka.core.pmml.MiningSchema;

public class TreeModel
extends PMMLClassifier
implements Drawable {
    private static final long serialVersionUID = -2065158088298753129L;
    protected MiningFunction m_functionType = MiningFunction.CLASSIFICATION;
    protected MissingValueStrategy m_missingValueStrategy = MissingValueStrategy.NONE;
    protected double m_missingValuePenalty = Utils.missingValue();
    protected NoTrueChildStrategy m_noTrueChildStrategy = NoTrueChildStrategy.RETURNNULLPREDICTION;
    protected SplitCharacteristic m_splitCharacteristic = SplitCharacteristic.MULTISPLIT;
    protected TreeNode m_root;

    public TreeModel(Element model, Instances dataDictionary, MiningSchema miningSchema) throws Exception {
        super(dataDictionary, miningSchema);
        String splitC;
        String missingP;
        String missingVS;
        String fn;
        if (!this.getPMMLVersion().equals("3.2")) {
            // empty if block
        }
        if ((fn = model.getAttribute("functionName")).equals("regression")) {
            this.m_functionType = MiningFunction.REGRESSION;
        }
        if ((missingVS = model.getAttribute("missingValueStrategy")) != null && missingVS.length() > 0) {
            for (MissingValueStrategy m : MissingValueStrategy.values()) {
                if (!m.toString().equals(missingVS)) continue;
                this.m_missingValueStrategy = m;
                break;
            }
        }
        if ((missingP = model.getAttribute("missingValuePenalty")) != null && missingP.length() > 0) {
            try {
                this.m_missingValuePenalty = Double.parseDouble(missingP);
            }
            catch (NumberFormatException ex) {
                System.err.println("[TreeModel] WARNING: couldn't parse supplied missingValuePenalty as a number");
            }
        }
        if ((splitC = model.getAttribute("splitCharacteristic")) != null && splitC.length() > 0) {
            for (SplitCharacteristic s : SplitCharacteristic.values()) {
                if (!s.toString().equals(splitC)) continue;
                this.m_splitCharacteristic = s;
                break;
            }
        }
        NodeList children = model.getChildNodes();
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            String tagName;
            Node child = children.item(i2);
            if (child.getNodeType() != 1 || !(tagName = ((Element)child).getTagName()).equals("Node")) continue;
            this.m_root = new TreeNode((Element)child, miningSchema);
            break;
        }
    }

    @Override
    public double[] distributionForInstance(Instance inst) throws Exception {
        if (!this.m_initialized) {
            this.mapToMiningSchema(inst.dataset());
        }
        double[] preds = null;
        preds = this.m_miningSchema.getFieldsAsInstances().classAttribute().isNumeric() ? new double[1] : new double[this.m_miningSchema.getFieldsAsInstances().classAttribute().numValues()];
        double[] incoming = this.m_fieldsMap.instanceToSchema(inst, this.m_miningSchema);
        preds = this.m_root.score(incoming, this.m_miningSchema.getFieldsAsInstances().classAttribute());
        return preds;
    }

    public String toString() {
        StringBuffer temp = new StringBuffer();
        temp.append("PMML version " + this.getPMMLVersion());
        if (!this.getCreatorApplication().equals("?")) {
            temp.append("\nApplication: " + this.getCreatorApplication());
        }
        temp.append("\nPMML Model: TreeModel");
        temp.append("\n\n");
        temp.append(this.m_miningSchema);
        temp.append("Split-type: " + (Object)((Object)this.m_splitCharacteristic) + "\n");
        temp.append("No true child strategy: " + (Object)((Object)this.m_noTrueChildStrategy) + "\n");
        temp.append("Missing value strategy: " + (Object)((Object)this.m_missingValueStrategy) + "\n");
        temp.append(this.m_root.toString());
        return temp.toString();
    }

    @Override
    public String graph() throws Exception {
        StringBuffer text = new StringBuffer();
        text.append("digraph PMMTree {\n");
        this.m_root.dumpGraph(text);
        text.append("}\n");
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10153 $");
    }

    @Override
    public int graphType() {
        return 1;
    }

    static enum SplitCharacteristic {
        BINARYSPLIT("binarySplit"),
        MULTISPLIT("multiSplit");

        private final String m_stringVal;

        private SplitCharacteristic(String name) {
            this.m_stringVal = name;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }

    static enum NoTrueChildStrategy {
        RETURNNULLPREDICTION("returnNullPrediction"),
        RETURNLASTPREDICTION("returnLastPrediction");

        private final String m_stringVal;

        private NoTrueChildStrategy(String name) {
            this.m_stringVal = name;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }

    static enum MissingValueStrategy {
        LASTPREDICTION("lastPrediction"),
        NULLPREDICTION("nullPrediction"),
        DEFAULTCHILD("defaultChild"),
        WEIGHTEDCONFIDENCE("weightedConfidence"),
        AGGREGATENODES("aggregateNodes"),
        NONE("none");

        private final String m_stringVal;

        private MissingValueStrategy(String name) {
            this.m_stringVal = name;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }

    static enum MiningFunction {
        CLASSIFICATION,
        REGRESSION;

    }

    class TreeNode
    implements Serializable {
        private static final long serialVersionUID = 3011062274167063699L;
        private String m_ID = "" + this.hashCode();
        private String m_scoreString;
        private int m_scoreIndex = -1;
        private double m_scoreNumeric = Utils.missingValue();
        private double m_recordCount = Utils.missingValue();
        private String m_defaultChildID;
        private TreeNode m_defaultChild;
        private final ArrayList<ScoreDistribution> m_scoreDistributions = new ArrayList();
        private final Predicate m_predicate;
        private final ArrayList<TreeNode> m_childNodes = new ArrayList();

        protected TreeNode(Element nodeE, MiningSchema miningSchema) throws Exception {
            String defaultC;
            String recordC;
            String scoreS;
            Attribute classAtt = miningSchema.getFieldsAsInstances().classAttribute();
            String id = nodeE.getAttribute("id");
            if (id != null && id.length() > 0) {
                this.m_ID = id;
            }
            if ((scoreS = nodeE.getAttribute("score")) != null && scoreS.length() > 0) {
                this.m_scoreString = scoreS;
                if (classAtt.isNumeric()) {
                    try {
                        this.m_scoreNumeric = Double.parseDouble(scoreS);
                    }
                    catch (NumberFormatException ex) {
                        throw new Exception("[TreeNode] class is numeric but unable to parse score " + this.m_scoreString + " as a number!");
                    }
                } else {
                    this.m_scoreIndex = classAtt.indexOfValue(this.m_scoreString);
                    if (this.m_scoreIndex < 0) {
                        throw new Exception("[TreeNode] can't find match for predicted value " + this.m_scoreString + " in class attribute!");
                    }
                }
            }
            if ((recordC = nodeE.getAttribute("recordCount")) != null && recordC.length() > 0) {
                this.m_recordCount = Double.parseDouble(recordC);
            }
            if ((defaultC = nodeE.getAttribute("defaultChild")) != null && defaultC.length() > 0) {
                this.m_defaultChildID = defaultC;
            }
            if (TreeModel.this.m_functionType == MiningFunction.CLASSIFICATION) {
                this.getScoreDistributions(nodeE, miningSchema);
            }
            this.m_predicate = Predicate.getPredicate(nodeE, miningSchema);
            this.getChildNodes(nodeE, miningSchema);
            if (this.m_defaultChildID != null) {
                for (TreeNode t : this.m_childNodes) {
                    if (!t.getID().equals(this.m_defaultChildID)) continue;
                    this.m_defaultChild = t;
                    break;
                }
            }
        }

        private void getChildNodes(Element nodeE, MiningSchema miningSchema) throws Exception {
            NodeList children = nodeE.getChildNodes();
            for (int i2 = 0; i2 < children.getLength(); ++i2) {
                String tagName;
                Node child = children.item(i2);
                if (child.getNodeType() != 1 || !(tagName = ((Element)child).getTagName()).equals("Node")) continue;
                TreeNode tempN = new TreeNode((Element)child, miningSchema);
                this.m_childNodes.add(tempN);
            }
        }

        private void getScoreDistributions(Element nodeE, MiningSchema miningSchema) throws Exception {
            NodeList scoreChildren = nodeE.getChildNodes();
            for (int i2 = 0; i2 < scoreChildren.getLength(); ++i2) {
                String tagName;
                Node child = scoreChildren.item(i2);
                if (child.getNodeType() != 1 || !(tagName = ((Element)child).getTagName()).equals("ScoreDistribution")) continue;
                ScoreDistribution newDist = new ScoreDistribution((Element)child, miningSchema, this.m_recordCount);
                this.m_scoreDistributions.add(newDist);
            }
            if (Utils.isMissingValue(this.m_recordCount)) {
                double baseCount = 0.0;
                for (ScoreDistribution s : this.m_scoreDistributions) {
                    baseCount += s.getRecordCount();
                }
                for (ScoreDistribution s : this.m_scoreDistributions) {
                    s.deriveConfidenceValue(baseCount);
                }
            }
        }

        protected String getScore() {
            return this.m_scoreString;
        }

        protected double getScoreNumeric() {
            return this.m_scoreNumeric;
        }

        protected String getID() {
            return this.m_ID;
        }

        protected Predicate getPredicate() {
            return this.m_predicate;
        }

        protected double getRecordCount() {
            return this.m_recordCount;
        }

        protected void dumpGraph(StringBuffer text) throws Exception {
            text.append("N" + this.m_ID + " ");
            if (this.m_scoreString != null) {
                text.append("[label=\"score=" + this.m_scoreString);
            }
            if (this.m_scoreDistributions.size() > 0 && this.m_childNodes.size() == 0) {
                text.append("\\n");
                for (ScoreDistribution s : this.m_scoreDistributions) {
                    text.append(s + "\\n");
                }
            }
            text.append("\"");
            if (this.m_childNodes.size() == 0) {
                text.append(" shape=box style=filled");
            }
            text.append("]\n");
            for (TreeNode c : this.m_childNodes) {
                text.append("N" + this.m_ID + "->N" + c.getID());
                text.append(" [label=\"" + c.getPredicate().toString(0, true));
                text.append("\"]\n");
                c.dumpGraph(text);
            }
        }

        public String toString() {
            StringBuffer text = new StringBuffer();
            this.dumpTree(0, text);
            return text.toString();
        }

        protected void dumpTree(int level, StringBuffer text) {
            if (this.m_childNodes.size() > 0) {
                for (int i2 = 0; i2 < this.m_childNodes.size(); ++i2) {
                    text.append("\n");
                    TreeNode child = this.m_childNodes.get(i2);
                    text.append(child.getPredicate().toString(level, false));
                    child.dumpTree(level + 1, text);
                }
            } else {
                text.append(": ");
                if (!Utils.isMissingValue(this.m_scoreNumeric)) {
                    text.append(this.m_scoreNumeric);
                } else {
                    text.append(this.m_scoreString + " ");
                    if (this.m_scoreDistributions.size() > 0) {
                        text.append("[");
                        for (ScoreDistribution s : this.m_scoreDistributions) {
                            text.append(s);
                        }
                        text.append("]");
                    } else {
                        text.append(this.m_scoreString);
                    }
                }
            }
        }

        protected double[] score(double[] instance, Attribute classAtt) throws Exception {
            double[] preds = null;
            preds = classAtt.isNumeric() ? new double[1] : new double[classAtt.numValues()];
            if (this.m_childNodes.size() == 0) {
                this.doLeaf(classAtt, preds);
            } else {
                switch (TreeModel.this.m_missingValueStrategy) {
                    case NONE: {
                        preds = this.missingValueStrategyNone(instance, classAtt);
                        break;
                    }
                    case LASTPREDICTION: {
                        preds = this.missingValueStrategyLastPrediction(instance, classAtt);
                        break;
                    }
                    case DEFAULTCHILD: {
                        preds = this.missingValueStrategyDefaultChild(instance, classAtt);
                        break;
                    }
                    default: {
                        throw new Exception("[TreeModel] not implemented!");
                    }
                }
            }
            return preds;
        }

        protected void doLeaf(Attribute classAtt, double[] preds) throws Exception {
            if (classAtt.isNumeric()) {
                preds[0] = this.m_scoreNumeric;
            } else if (this.m_scoreDistributions.size() == 0) {
                preds[this.m_scoreIndex] = 1.0;
            } else {
                for (ScoreDistribution s : this.m_scoreDistributions) {
                    preds[s.getClassLabelIndex()] = s.getConfidence();
                }
            }
        }

        protected void doNoTrueChild(Attribute classAtt, double[] preds) throws Exception {
            if (TreeModel.this.m_noTrueChildStrategy == NoTrueChildStrategy.RETURNNULLPREDICTION) {
                for (int i2 = 0; i2 < classAtt.numValues(); ++i2) {
                    preds[i2] = Utils.missingValue();
                }
            } else {
                this.doLeaf(classAtt, preds);
            }
        }

        protected double[] missingValueStrategyWeightedConfidence(double[] instance, Attribute classAtt) throws Exception {
            if (classAtt.isNumeric()) {
                throw new Exception("[TreeNode] missing value strategy weighted confidence, but class is numeric!");
            }
            double[] preds = null;
            TreeNode trueNode = null;
            boolean strategyInvoked = false;
            int nodeCount = 0;
            for (TreeNode c : this.m_childNodes) {
                if (c.getPredicate().evaluate(instance) == Predicate.Eval.TRUE) {
                    if (trueNode == null) {
                        trueNode = c;
                    }
                    ++nodeCount;
                    continue;
                }
                if (c.getPredicate().evaluate(instance) != Predicate.Eval.UNKNOWN) continue;
                strategyInvoked = true;
                ++nodeCount;
            }
            if (strategyInvoked) {
                double[][] dists = new double[nodeCount][];
                double[] weights = new double[nodeCount];
                int count = 0;
                for (TreeNode c : this.m_childNodes) {
                    if (c.getPredicate().evaluate(instance) != Predicate.Eval.TRUE && c.getPredicate().evaluate(instance) != Predicate.Eval.UNKNOWN) continue;
                    weights[count] = c.getRecordCount();
                    if (Utils.isMissingValue(weights[count])) {
                        throw new Exception("[TreeNode] weighted confidence missing value strategy invoked, but no record count defined for node " + c.getID());
                    }
                    dists[count++] = c.score(instance, classAtt);
                }
                preds = new double[classAtt.numValues()];
                for (int i2 = 0; i2 < classAtt.numValues(); ++i2) {
                    for (int j = 0; j < nodeCount; ++j) {
                        int n = i2;
                        preds[n] = preds[n] + weights[j] / this.m_recordCount * dists[j][i2];
                    }
                }
            } else if (trueNode != null) {
                preds = trueNode.score(instance, classAtt);
            } else {
                this.doNoTrueChild(classAtt, preds);
            }
            return preds;
        }

        protected double[] freqCountsForAggNodesStrategy(double[] instance, Attribute classAtt) throws Exception {
            double[] counts = new double[classAtt.numValues()];
            if (this.m_childNodes.size() > 0) {
                for (TreeNode c : this.m_childNodes) {
                    if (c.getPredicate().evaluate(instance) != Predicate.Eval.TRUE && c.getPredicate().evaluate(instance) != Predicate.Eval.UNKNOWN) continue;
                    double[] temp = c.freqCountsForAggNodesStrategy(instance, classAtt);
                    for (int i2 = 0; i2 < classAtt.numValues(); ++i2) {
                        int n = i2;
                        counts[n] = counts[n] + temp[i2];
                    }
                }
            } else {
                if (this.m_scoreDistributions.size() == 0) {
                    throw new Exception("[TreeModel] missing value strategy aggregate nodes: no score distributions at leaf " + this.m_ID);
                }
                for (ScoreDistribution s : this.m_scoreDistributions) {
                    counts[s.getClassLabelIndex()] = s.getRecordCount();
                }
            }
            return counts;
        }

        protected double[] missingValueStrategyAggregateNodes(double[] instance, Attribute classAtt) throws Exception {
            if (classAtt.isNumeric()) {
                throw new Exception("[TreeNode] missing value strategy aggregate nodes, but class is numeric!");
            }
            double[] preds = null;
            TreeNode trueNode = null;
            boolean strategyInvoked = false;
            for (TreeNode c : this.m_childNodes) {
                if (c.getPredicate().evaluate(instance) == Predicate.Eval.TRUE) {
                    if (trueNode != null) continue;
                    trueNode = c;
                    continue;
                }
                if (c.getPredicate().evaluate(instance) != Predicate.Eval.UNKNOWN) continue;
                strategyInvoked = true;
            }
            if (strategyInvoked) {
                double[] aggregatedCounts = this.freqCountsForAggNodesStrategy(instance, classAtt);
                Utils.normalize(aggregatedCounts);
                preds = aggregatedCounts;
            } else if (trueNode != null) {
                preds = trueNode.score(instance, classAtt);
            } else {
                this.doNoTrueChild(classAtt, preds);
            }
            return preds;
        }

        protected double[] missingValueStrategyDefaultChild(double[] instance, Attribute classAtt) throws Exception {
            double[] preds = null;
            boolean strategyInvoked = false;
            for (TreeNode c : this.m_childNodes) {
                if (c.getPredicate().evaluate(instance) == Predicate.Eval.TRUE) {
                    preds = c.score(instance, classAtt);
                    break;
                }
                if (c.getPredicate().evaluate(instance) != Predicate.Eval.UNKNOWN) continue;
                strategyInvoked = true;
            }
            if (preds == null) {
                if (!strategyInvoked) {
                    this.doNoTrueChild(classAtt, preds);
                } else if (this.m_defaultChild != null) {
                    preds = this.m_defaultChild.score(instance, classAtt);
                } else {
                    throw new Exception("[TreeNode] missing value strategy is defaultChild, but no default child has been specified in node " + this.m_ID);
                }
            }
            return preds;
        }

        protected double[] missingValueStrategyLastPrediction(double[] instance, Attribute classAtt) throws Exception {
            double[] preds = null;
            boolean strategyInvoked = false;
            for (TreeNode c : this.m_childNodes) {
                if (c.getPredicate().evaluate(instance) == Predicate.Eval.TRUE) {
                    preds = c.score(instance, classAtt);
                    break;
                }
                if (c.getPredicate().evaluate(instance) != Predicate.Eval.UNKNOWN) continue;
                strategyInvoked = true;
            }
            if (preds == null) {
                preds = new double[classAtt.numValues()];
                if (!strategyInvoked) {
                    this.doNoTrueChild(classAtt, preds);
                } else {
                    this.doLeaf(classAtt, preds);
                }
            }
            return preds;
        }

        protected double[] missingValueStrategyNullPrediction(double[] instance, Attribute classAtt) throws Exception {
            double[] preds = null;
            boolean strategyInvoked = false;
            for (TreeNode c : this.m_childNodes) {
                if (c.getPredicate().evaluate(instance) == Predicate.Eval.TRUE) {
                    preds = c.score(instance, classAtt);
                    break;
                }
                if (c.getPredicate().evaluate(instance) != Predicate.Eval.UNKNOWN) continue;
                strategyInvoked = true;
            }
            if (preds == null) {
                preds = new double[classAtt.numValues()];
                if (!strategyInvoked) {
                    this.doNoTrueChild(classAtt, preds);
                } else {
                    for (int i2 = 0; i2 < classAtt.numValues(); ++i2) {
                        preds[i2] = Utils.missingValue();
                    }
                }
            }
            return preds;
        }

        protected double[] missingValueStrategyNone(double[] instance, Attribute classAtt) throws Exception {
            double[] preds = null;
            for (TreeNode c : this.m_childNodes) {
                if (c.getPredicate().evaluate(instance) != Predicate.Eval.TRUE) continue;
                preds = c.score(instance, classAtt);
                break;
            }
            if (preds == null) {
                preds = new double[classAtt.numValues()];
                this.doNoTrueChild(classAtt, preds);
            }
            return preds;
        }
    }

    static class SimpleSetPredicate
    extends Predicate {
        private static final long serialVersionUID = -2711995401345708486L;
        int m_fieldIndex = -1;
        String m_fieldName;
        boolean m_isNominal = false;
        Attribute m_nominalLookup;
        BooleanOperator m_operator = BooleanOperator.IS_IN;
        Array m_set;

        public SimpleSetPredicate(Element setP, MiningSchema miningSchema) throws Exception {
            Instances totalStructure = miningSchema.getFieldsAsInstances();
            String fieldS = setP.getAttribute("field");
            Attribute att = totalStructure.attribute(fieldS);
            if (att == null) {
                throw new Exception("[SimplePredicate] unable to find field " + fieldS + " in the incoming instance structure!");
            }
            int index = -1;
            for (int i2 = 0; i2 < totalStructure.numAttributes(); ++i2) {
                if (!totalStructure.attribute(i2).name().equals(fieldS)) continue;
                index = i2;
                this.m_fieldName = totalStructure.attribute(i2).name();
                break;
            }
            this.m_fieldIndex = index;
            if (att.isNominal()) {
                this.m_isNominal = true;
                this.m_nominalLookup = att;
            }
            NodeList children = setP.getChildNodes();
            for (int i3 = 0; i3 < children.getLength(); ++i3) {
                Node child = children.item(i3);
                if (child.getNodeType() != 1 || !Array.isArray((Element)child)) continue;
                this.m_set = Array.create((Element)child);
                break;
            }
            if (this.m_set == null) {
                throw new Exception("[SimpleSetPredictate] couldn't find an array containing the set values!");
            }
            if (this.m_set.getType() == Array.ArrayType.STRING && !this.m_isNominal) {
                throw new Exception("[SimpleSetPredicate] referenced field " + totalStructure.attribute(this.m_fieldIndex).name() + " is numeric but array type is string!");
            }
            if (this.m_set.getType() != Array.ArrayType.STRING && this.m_isNominal) {
                throw new Exception("[SimpleSetPredicate] referenced field " + totalStructure.attribute(this.m_fieldIndex).name() + " is nominal but array type is numeric!");
            }
        }

        @Override
        public Predicate.Eval evaluate(double[] input) {
            return this.m_operator.evaluate(input, this.m_fieldIndex, this.m_set, this.m_nominalLookup);
        }

        public String toString() {
            StringBuffer temp = new StringBuffer();
            temp.append(this.m_fieldName + " " + this.m_operator.toString() + " ");
            temp.append(this.m_set.toString());
            return temp.toString();
        }

        static enum BooleanOperator {
            IS_IN("isIn"){

                @Override
                Predicate.Eval evaluate(double[] input, int fieldIndex, Array set, Attribute nominalLookup) {
                    if (set.getType() == Array.ArrayType.STRING) {
                        String value = "";
                        if (!Utils.isMissingValue(input[fieldIndex])) {
                            value = nominalLookup.value((int)input[fieldIndex]);
                        }
                        return Predicate.booleanToEval(Utils.isMissingValue(input[fieldIndex]), set.contains(value));
                    }
                    if (set.getType() == Array.ArrayType.NUM || set.getType() == Array.ArrayType.REAL) {
                        return Predicate.booleanToEval(Utils.isMissingValue(input[fieldIndex]), set.contains(input[fieldIndex]));
                    }
                    return Predicate.booleanToEval(Utils.isMissingValue(input[fieldIndex]), set.contains((int)input[fieldIndex]));
                }
            }
            ,
            IS_NOT_IN("isNotIn"){

                @Override
                Predicate.Eval evaluate(double[] input, int fieldIndex, Array set, Attribute nominalLookup) {
                    Predicate.Eval result = IS_IN.evaluate(input, fieldIndex, set, nominalLookup);
                    if (result == Predicate.Eval.FALSE) {
                        result = Predicate.Eval.TRUE;
                    } else if (result == Predicate.Eval.TRUE) {
                        result = Predicate.Eval.FALSE;
                    }
                    return result;
                }
            };

            private final String m_stringVal;

            abstract Predicate.Eval evaluate(double[] var1, int var2, Array var3, Attribute var4);

            private BooleanOperator(String name) {
                this.m_stringVal = name;
            }

            public String toString() {
                return this.m_stringVal;
            }
        }
    }

    static class CompoundPredicate
    extends Predicate {
        private static final long serialVersionUID = -3332091529764559077L;
        ArrayList<Predicate> m_components = new ArrayList();
        BooleanOperator m_booleanOperator;

        public CompoundPredicate(Element compoundP, MiningSchema miningSchema) throws Exception {
            String booleanOpp = compoundP.getAttribute("booleanOperator");
            for (BooleanOperator b : BooleanOperator.values()) {
                if (!b.toString().equals(booleanOpp)) continue;
                this.m_booleanOperator = b;
            }
            NodeList children = compoundP.getChildNodes();
            for (int i2 = 0; i2 < children.getLength(); ++i2) {
                Node child = children.item(i2);
                if (child.getNodeType() != 1) continue;
                String tagName = ((Element)child).getTagName();
                if (tagName.equals("True")) {
                    this.m_components.add(new True());
                    continue;
                }
                if (tagName.equals("False")) {
                    this.m_components.add(new False());
                    continue;
                }
                if (tagName.equals("SimplePredicate")) {
                    this.m_components.add(new SimplePredicate((Element)child, miningSchema));
                    continue;
                }
                if (tagName.equals("CompoundPredicate")) {
                    this.m_components.add(new CompoundPredicate((Element)child, miningSchema));
                    continue;
                }
                this.m_components.add(new SimpleSetPredicate((Element)child, miningSchema));
            }
        }

        @Override
        public Predicate.Eval evaluate(double[] input) {
            return this.m_booleanOperator.evaluate(this.m_components, input);
        }

        public String toString() {
            return this.toString(0, false);
        }

        @Override
        public String toString(int level, boolean cr) {
            StringBuffer text = new StringBuffer();
            for (int j = 0; j < level; ++j) {
                text.append("|   ");
            }
            text.append("Compound [" + this.m_booleanOperator.toString() + "]");
            if (cr) {
                text.append("\\n");
            } else {
                text.append("\n");
            }
            for (int i2 = 0; i2 < this.m_components.size(); ++i2) {
                text.append(this.m_components.get(i2).toString(level, cr).replace(":", ""));
                if (i2 == this.m_components.size() - 1) continue;
                if (cr) {
                    text.append("\\n");
                    continue;
                }
                text.append("\n");
            }
            return text.toString();
        }

        static enum BooleanOperator {
            OR("or"){

                @Override
                Predicate.Eval evaluate(ArrayList<Predicate> constituents, double[] input) {
                    Predicate.Eval currentStatus = Predicate.Eval.FALSE;
                    for (Predicate p : constituents) {
                        Predicate.Eval temp = p.evaluate(input);
                        if (temp == Predicate.Eval.TRUE) {
                            currentStatus = temp;
                            break;
                        }
                        if (temp != Predicate.Eval.UNKNOWN) continue;
                        currentStatus = temp;
                    }
                    return currentStatus;
                }
            }
            ,
            AND("and"){

                @Override
                Predicate.Eval evaluate(ArrayList<Predicate> constituents, double[] input) {
                    Predicate.Eval currentStatus = Predicate.Eval.TRUE;
                    for (Predicate p : constituents) {
                        Predicate.Eval temp = p.evaluate(input);
                        if (temp == Predicate.Eval.FALSE) {
                            currentStatus = temp;
                            break;
                        }
                        if (temp != Predicate.Eval.UNKNOWN) continue;
                        currentStatus = temp;
                    }
                    return currentStatus;
                }
            }
            ,
            XOR("xor"){

                @Override
                Predicate.Eval evaluate(ArrayList<Predicate> constituents, double[] input) {
                    Predicate.Eval currentStatus = constituents.get(0).evaluate(input);
                    if (currentStatus != Predicate.Eval.UNKNOWN) {
                        for (int i2 = 1; i2 < constituents.size(); ++i2) {
                            Predicate.Eval temp = constituents.get(i2).evaluate(input);
                            if (temp == Predicate.Eval.UNKNOWN) {
                                currentStatus = temp;
                                break;
                            }
                            currentStatus = currentStatus != temp ? Predicate.Eval.TRUE : Predicate.Eval.FALSE;
                        }
                    }
                    return currentStatus;
                }
            }
            ,
            SURROGATE("surrogate"){

                @Override
                Predicate.Eval evaluate(ArrayList<Predicate> constituents, double[] input) {
                    Predicate.Eval currentStatus = constituents.get(0).evaluate(input);
                    int i2 = 1;
                    while (currentStatus == Predicate.Eval.UNKNOWN) {
                        currentStatus = constituents.get(i2).evaluate(input);
                    }
                    if (currentStatus == Predicate.Eval.UNKNOWN) {
                        currentStatus = Predicate.Eval.FALSE;
                    }
                    return currentStatus;
                }
            };

            private final String m_stringVal;

            abstract Predicate.Eval evaluate(ArrayList<Predicate> var1, double[] var2);

            private BooleanOperator(String name) {
                this.m_stringVal = name;
            }

            public String toString() {
                return this.m_stringVal;
            }
        }
    }

    static class SimplePredicate
    extends Predicate {
        private static final long serialVersionUID = -6156684285069327400L;
        int m_fieldIndex = -1;
        String m_fieldName;
        boolean m_isNominal;
        String m_nominalValue;
        double m_value;
        Operator m_operator;

        public SimplePredicate(Element simpleP, MiningSchema miningSchema) throws Exception {
            Instances totalStructure = miningSchema.getFieldsAsInstances();
            String fieldS = simpleP.getAttribute("field");
            Attribute att = totalStructure.attribute(fieldS);
            if (att == null) {
                throw new Exception("[SimplePredicate] unable to find field " + fieldS + " in the incoming instance structure!");
            }
            int index = -1;
            for (int i2 = 0; i2 < totalStructure.numAttributes(); ++i2) {
                if (!totalStructure.attribute(i2).name().equals(fieldS)) continue;
                index = i2;
                this.m_fieldName = totalStructure.attribute(i2).name();
                break;
            }
            this.m_fieldIndex = index;
            if (att.isNominal()) {
                this.m_isNominal = true;
            }
            String oppS = simpleP.getAttribute("operator");
            for (Operator o : Operator.values()) {
                if (!o.toString().equals(oppS)) continue;
                this.m_operator = o;
                break;
            }
            if (this.m_operator != Operator.ISMISSING && this.m_operator != Operator.ISNOTMISSING) {
                String valueS = simpleP.getAttribute("value");
                if (att.isNumeric()) {
                    this.m_value = Double.parseDouble(valueS);
                } else {
                    this.m_nominalValue = valueS;
                    this.m_value = att.indexOfValue(valueS);
                    if (this.m_value < 0.0) {
                        throw new Exception("[SimplePredicate] can't find value " + valueS + " in nominal attribute " + att.name());
                    }
                }
            }
        }

        @Override
        public Predicate.Eval evaluate(double[] input) {
            return this.m_operator.evaluate(input, this.m_value, this.m_fieldIndex);
        }

        public String toString() {
            StringBuffer temp = new StringBuffer();
            temp.append(this.m_fieldName + " " + this.m_operator.shortName());
            if (this.m_operator != Operator.ISMISSING && this.m_operator != Operator.ISNOTMISSING) {
                temp.append(" " + (this.m_isNominal ? this.m_nominalValue : "" + this.m_value));
            }
            return temp.toString();
        }

        static enum Operator {
            EQUAL("equal"){

                @Override
                Predicate.Eval evaluate(double[] input, double value, int fieldIndex) {
                    return Predicate.booleanToEval(Utils.isMissingValue(input[fieldIndex]), Utils.eq(input[fieldIndex], value));
                }

                @Override
                String shortName() {
                    return "==";
                }
            }
            ,
            NOTEQUAL("notEqual"){

                @Override
                Predicate.Eval evaluate(double[] input, double value, int fieldIndex) {
                    return Predicate.booleanToEval(Utils.isMissingValue(input[fieldIndex]), input[fieldIndex] != value);
                }

                @Override
                String shortName() {
                    return "!=";
                }
            }
            ,
            LESSTHAN("lessThan"){

                @Override
                Predicate.Eval evaluate(double[] input, double value, int fieldIndex) {
                    return Predicate.booleanToEval(Utils.isMissingValue(input[fieldIndex]), input[fieldIndex] < value);
                }

                @Override
                String shortName() {
                    return "<";
                }
            }
            ,
            LESSOREQUAL("lessOrEqual"){

                @Override
                Predicate.Eval evaluate(double[] input, double value, int fieldIndex) {
                    return Predicate.booleanToEval(Utils.isMissingValue(input[fieldIndex]), input[fieldIndex] <= value);
                }

                @Override
                String shortName() {
                    return "<=";
                }
            }
            ,
            GREATERTHAN("greaterThan"){

                @Override
                Predicate.Eval evaluate(double[] input, double value, int fieldIndex) {
                    return Predicate.booleanToEval(Utils.isMissingValue(input[fieldIndex]), input[fieldIndex] > value);
                }

                @Override
                String shortName() {
                    return ">";
                }
            }
            ,
            GREATEROREQUAL("greaterOrEqual"){

                @Override
                Predicate.Eval evaluate(double[] input, double value, int fieldIndex) {
                    return Predicate.booleanToEval(Utils.isMissingValue(input[fieldIndex]), input[fieldIndex] >= value);
                }

                @Override
                String shortName() {
                    return ">=";
                }
            }
            ,
            ISMISSING("isMissing"){

                @Override
                Predicate.Eval evaluate(double[] input, double value, int fieldIndex) {
                    return Predicate.booleanToEval(false, Utils.isMissingValue(input[fieldIndex]));
                }

                @Override
                String shortName() {
                    return this.toString();
                }
            }
            ,
            ISNOTMISSING("isNotMissing"){

                @Override
                Predicate.Eval evaluate(double[] input, double value, int fieldIndex) {
                    return Predicate.booleanToEval(false, !Utils.isMissingValue(input[fieldIndex]));
                }

                @Override
                String shortName() {
                    return this.toString();
                }
            };

            private final String m_stringVal;

            abstract Predicate.Eval evaluate(double[] var1, double var2, int var4);

            abstract String shortName();

            private Operator(String name) {
                this.m_stringVal = name;
            }

            public String toString() {
                return this.m_stringVal;
            }
        }
    }

    static class False
    extends Predicate {
        private static final long serialVersionUID = -3647261386442860365L;

        False() {
        }

        @Override
        public Predicate.Eval evaluate(double[] input) {
            return Predicate.Eval.FALSE;
        }

        public String toString() {
            return "False: ";
        }
    }

    static class True
    extends Predicate {
        private static final long serialVersionUID = 1817942234610531627L;

        True() {
        }

        @Override
        public Predicate.Eval evaluate(double[] input) {
            return Predicate.Eval.TRUE;
        }

        public String toString() {
            return "True: ";
        }
    }

    static abstract class Predicate
    implements Serializable {
        private static final long serialVersionUID = 1035344165452733887L;

        Predicate() {
        }

        abstract Eval evaluate(double[] var1);

        protected String toString(int level, boolean cr) {
            return this.toString(level);
        }

        protected String toString(int level) {
            StringBuffer text = new StringBuffer();
            for (int j = 0; j < level; ++j) {
                text.append("|   ");
            }
            return text.append(this.toString()).toString();
        }

        static Eval booleanToEval(boolean missing, boolean result) {
            if (missing) {
                return Eval.UNKNOWN;
            }
            if (result) {
                return Eval.TRUE;
            }
            return Eval.FALSE;
        }

        static Predicate getPredicate(Element nodeE, MiningSchema miningSchema) throws Exception {
            Predicate result = null;
            NodeList children = nodeE.getChildNodes();
            for (int i2 = 0; i2 < children.getLength(); ++i2) {
                Node child = children.item(i2);
                if (child.getNodeType() != 1) continue;
                String tagName = ((Element)child).getTagName();
                if (tagName.equals("True")) {
                    result = new True();
                    break;
                }
                if (tagName.equals("False")) {
                    result = new False();
                    break;
                }
                if (tagName.equals("SimplePredicate")) {
                    result = new SimplePredicate((Element)child, miningSchema);
                    break;
                }
                if (tagName.equals("CompoundPredicate")) {
                    result = new CompoundPredicate((Element)child, miningSchema);
                    break;
                }
                if (!tagName.equals("SimpleSetPredicate")) continue;
                result = new SimpleSetPredicate((Element)child, miningSchema);
                break;
            }
            if (result == null) {
                throw new Exception("[Predicate] unknown or missing predicate type in node");
            }
            return result;
        }

        static enum Eval {
            TRUE,
            FALSE,
            UNKNOWN;

        }
    }

    static class ScoreDistribution
    implements Serializable {
        private static final long serialVersionUID = -123506262094299933L;
        private final String m_classLabel;
        private int m_classLabelIndex = -1;
        private final double m_recordCount;
        private double m_confidence = Utils.missingValue();

        protected ScoreDistribution(Element scoreE, MiningSchema miningSchema, double baseCount) throws Exception {
            this.m_classLabel = scoreE.getAttribute("value");
            Attribute classAtt = miningSchema.getFieldsAsInstances().classAttribute();
            if (classAtt == null || classAtt.indexOfValue(this.m_classLabel) < 0) {
                throw new Exception("[ScoreDistribution] class attribute not set or class value " + this.m_classLabel + " not found!");
            }
            this.m_classLabelIndex = classAtt.indexOfValue(this.m_classLabel);
            String recordC = scoreE.getAttribute("recordCount");
            this.m_recordCount = Double.parseDouble(recordC);
            String confidence = scoreE.getAttribute("confidence");
            if (confidence != null && confidence.length() > 0) {
                this.m_confidence = Double.parseDouble(confidence);
            } else if (!Utils.isMissingValue(baseCount) && baseCount > 0.0) {
                this.m_confidence = this.m_recordCount / baseCount;
            }
        }

        void deriveConfidenceValue(double baseCount) {
            if (Utils.isMissingValue(this.m_confidence) && !Utils.isMissingValue(baseCount) && baseCount > 0.0) {
                this.m_confidence = this.m_recordCount / baseCount;
            }
        }

        String getClassLabel() {
            return this.m_classLabel;
        }

        int getClassLabelIndex() {
            return this.m_classLabelIndex;
        }

        double getRecordCount() {
            return this.m_recordCount;
        }

        double getConfidence() {
            return this.m_confidence;
        }

        public String toString() {
            return this.m_classLabel + ": " + this.m_recordCount + " (" + Utils.doubleToString(this.m_confidence, 2) + ") ";
        }
    }
}

