/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.Serializable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class DecisionTableHashKey
implements Serializable,
RevisionHandler {
    static final long serialVersionUID = 5674163500154964602L;
    private double[] attributes;
    private boolean[] missing;
    private int key;

    public DecisionTableHashKey(Instance t, int numAtts, boolean ignoreClass) throws Exception {
        int cindex = t.classIndex();
        this.key = -999;
        this.attributes = new double[numAtts];
        this.missing = new boolean[numAtts];
        for (int i2 = 0; i2 < numAtts; ++i2) {
            if (i2 == cindex && !ignoreClass) {
                this.missing[i2] = true;
                continue;
            }
            this.missing[i2] = t.isMissing(i2);
            if (this.missing[i2]) continue;
            this.attributes[i2] = t.value(i2);
        }
    }

    public String toString(Instances t, int maxColWidth) {
        int cindex = t.classIndex();
        StringBuffer text = new StringBuffer();
        for (int i2 = 0; i2 < this.attributes.length; ++i2) {
            if (i2 == cindex) continue;
            if (this.missing[i2]) {
                text.append("?");
                for (int j = 0; j < maxColWidth; ++j) {
                    text.append(" ");
                }
                continue;
            }
            String ss = t.attribute(i2).value((int)this.attributes[i2]);
            StringBuffer sb = new StringBuffer(ss);
            for (int j = 0; j < maxColWidth - ss.length() + 1; ++j) {
                sb.append(" ");
            }
            text.append(sb);
        }
        return text.toString();
    }

    public DecisionTableHashKey(double[] t) {
        int l = t.length;
        this.key = -999;
        this.attributes = new double[l];
        this.missing = new boolean[l];
        for (int i2 = 0; i2 < l; ++i2) {
            if (t[i2] == Double.MAX_VALUE) {
                this.missing[i2] = true;
                continue;
            }
            this.missing[i2] = false;
            this.attributes[i2] = t[i2];
        }
    }

    public int hashCode() {
        int hv = 0;
        if (this.key != -999) {
            return this.key;
        }
        for (int i2 = 0; i2 < this.attributes.length; ++i2) {
            if (this.missing[i2]) {
                hv += i2 * 13;
                continue;
            }
            hv = (int)((double)hv + (double)(i2 * 5) * (this.attributes[i2] + 1.0));
        }
        if (this.key == -999) {
            this.key = hv;
        }
        return hv;
    }

    public boolean equals(Object b) {
        if (b == null || !b.getClass().equals(this.getClass())) {
            return false;
        }
        boolean ok = true;
        if (b instanceof DecisionTableHashKey) {
            DecisionTableHashKey n = (DecisionTableHashKey)b;
            for (int i2 = 0; i2 < this.attributes.length; ++i2) {
                boolean l = n.missing[i2];
                if (this.missing[i2] || l) {
                    if ((!this.missing[i2] || l) && (this.missing[i2] || !l)) continue;
                    ok = false;
                } else {
                    if (this.attributes[i2] == n.attributes[i2]) continue;
                    ok = false;
                }
                break;
            }
        } else {
            return false;
        }
        return ok;
    }

    public void print_hash_code() {
        System.out.println("Hash val: " + this.hashCode());
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

