/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules.part;

import java.io.Serializable;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.EntropySplitCrit;
import weka.classifiers.trees.j48.ModelSelection;
import weka.classifiers.trees.j48.NoSplit;
import weka.core.ContingencyTables;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class ClassifierDecList
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = 7284358349711992497L;
    protected int m_minNumObj;
    protected static EntropySplitCrit m_splitCrit = new EntropySplitCrit();
    protected ModelSelection m_toSelectModel;
    protected ClassifierSplitModel m_localModel;
    protected ClassifierDecList[] m_sons;
    protected boolean m_isLeaf;
    protected boolean m_isEmpty;
    protected Instances m_train;
    protected Distribution m_test;
    protected int indeX;

    public ClassifierDecList(ModelSelection toSelectLocModel, int minNum) {
        this.m_toSelectModel = toSelectLocModel;
        this.m_minNumObj = minNum;
    }

    public void buildRule(Instances data) throws Exception {
        this.buildDecList(data, false);
        this.cleanup(new Instances(data, 0));
    }

    public void buildDecList(Instances data, boolean leaf) throws Exception {
        this.m_train = null;
        this.m_test = null;
        this.m_isLeaf = false;
        this.m_isEmpty = false;
        this.m_sons = null;
        this.indeX = 0;
        double sumOfWeights = data.sumOfWeights();
        NoSplit noSplit = new NoSplit(new Distribution(data));
        this.m_localModel = leaf ? noSplit : this.m_toSelectModel.selectModel(data);
        if (this.m_localModel.numSubsets() > 1) {
            int ind;
            Instances[] localInstances = this.m_localModel.split(data);
            data = null;
            this.m_sons = new ClassifierDecList[this.m_localModel.numSubsets()];
            int i2 = 0;
            do {
                ++i2;
                ind = this.chooseIndex();
                if (ind == -1) {
                    for (int j = 0; j < this.m_sons.length; ++j) {
                        if (this.m_sons[j] != null) continue;
                        this.m_sons[j] = this.getNewDecList(localInstances[j], true);
                    }
                    if (i2 < 2) {
                        this.m_localModel = noSplit;
                        this.m_isLeaf = true;
                        this.m_sons = null;
                        if (Utils.eq(sumOfWeights, 0.0)) {
                            this.m_isEmpty = true;
                        }
                        return;
                    }
                    ind = 0;
                    break;
                }
                this.m_sons[ind] = this.getNewDecList(localInstances[ind], false);
            } while (i2 < this.m_sons.length && this.m_sons[ind].m_isLeaf);
            this.indeX = this.chooseLastIndex();
        } else {
            this.m_isLeaf = true;
            if (Utils.eq(sumOfWeights, 0.0)) {
                this.m_isEmpty = true;
            }
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        double maxProb = -1.0;
        int maxIndex = 0;
        for (int j = 0; j < instance.numClasses(); ++j) {
            double currentProb = this.getProbs(j, instance, 1.0);
            if (!Utils.gr(currentProb, maxProb)) continue;
            maxIndex = j;
            maxProb = currentProb;
        }
        if (Utils.eq(maxProb, 0.0)) {
            return -1.0;
        }
        return maxIndex;
    }

    public final double[] distributionForInstance(Instance instance) throws Exception {
        double[] doubles = new double[instance.numClasses()];
        for (int i2 = 0; i2 < doubles.length; ++i2) {
            doubles[i2] = this.getProbs(i2, instance, 1.0);
        }
        return doubles;
    }

    public double weight(Instance instance) throws Exception {
        if (this.m_isLeaf) {
            return 1.0;
        }
        int subset = this.m_localModel.whichSubset(instance);
        if (subset == -1) {
            return this.m_localModel.weights(instance)[this.indeX] * this.m_sons[this.indeX].weight(instance);
        }
        if (subset == this.indeX) {
            return this.m_sons[this.indeX].weight(instance);
        }
        return 0.0;
    }

    public final void cleanup(Instances justHeaderInfo) {
        this.m_train = justHeaderInfo;
        this.m_test = null;
        if (!this.m_isLeaf) {
            for (ClassifierDecList m_son : this.m_sons) {
                if (m_son == null) continue;
                m_son.cleanup(justHeaderInfo);
            }
        }
    }

    public String toString() {
        try {
            StringBuffer text = new StringBuffer();
            if (this.m_isLeaf) {
                text.append(": ");
                text.append(this.m_localModel.dumpLabel(0, this.m_train) + "\n");
            } else {
                this.dumpDecList(text);
            }
            return text.toString();
        }
        catch (Exception e) {
            return "Can't print rule.";
        }
    }

    protected ClassifierDecList getNewDecList(Instances train, boolean leaf) throws Exception {
        ClassifierDecList newDecList = new ClassifierDecList(this.m_toSelectModel, this.m_minNumObj);
        newDecList.buildDecList(train, leaf);
        return newDecList;
    }

    public final int chooseIndex() {
        int minIndex = -1;
        double min = Double.MAX_VALUE;
        for (int i2 = 0; i2 < this.m_sons.length; ++i2) {
            double estimated;
            if (this.son(i2) != null) continue;
            if (Utils.sm(this.localModel().distribution().perBag(i2), this.m_minNumObj)) {
                estimated = Double.MAX_VALUE;
            } else {
                estimated = 0.0;
                for (int j = 0; j < this.localModel().distribution().numClasses(); ++j) {
                    estimated -= m_splitCrit.lnFunc(this.localModel().distribution().perClassPerBag(i2, j));
                }
                estimated += m_splitCrit.lnFunc(this.localModel().distribution().perBag(i2));
                estimated /= this.localModel().distribution().perBag(i2) * ContingencyTables.log2;
            }
            if (Utils.smOrEq(estimated, 0.0)) {
                return i2;
            }
            if (!Utils.sm(estimated, min)) continue;
            min = estimated;
            minIndex = i2;
        }
        return minIndex;
    }

    public final int chooseLastIndex() {
        int minIndex = 0;
        double min = Double.MAX_VALUE;
        if (!this.m_isLeaf) {
            for (int i2 = 0; i2 < this.m_sons.length; ++i2) {
                double estimated;
                if (this.son(i2) == null || !Utils.grOrEq(this.localModel().distribution().perBag(i2), this.m_minNumObj) || !Utils.sm(estimated = this.son(i2).getSizeOfBranch(), min)) continue;
                min = estimated;
                minIndex = i2;
            }
        }
        return minIndex;
    }

    protected double getSizeOfBranch() {
        if (this.m_isLeaf) {
            return -this.localModel().distribution().total();
        }
        return this.son(this.indeX).getSizeOfBranch();
    }

    private void dumpDecList(StringBuffer text) throws Exception {
        text.append(this.m_localModel.leftSide(this.m_train));
        text.append(this.m_localModel.rightSide(this.indeX, this.m_train));
        if (this.m_sons[this.indeX].m_isLeaf) {
            text.append(": ");
            text.append(this.m_localModel.dumpLabel(this.indeX, this.m_train) + "\n");
        } else {
            text.append(" AND\n");
            this.m_sons[this.indeX].dumpDecList(text);
        }
    }

    private double getProbs(int classIndex, Instance instance, double weight) throws Exception {
        if (this.m_isLeaf) {
            return weight * this.localModel().classProb(classIndex, instance, -1);
        }
        int treeIndex = this.localModel().whichSubset(instance);
        if (treeIndex == -1) {
            double[] weights = this.localModel().weights(instance);
            return this.son(this.indeX).getProbs(classIndex, instance, weights[this.indeX] * weight);
        }
        if (treeIndex == this.indeX) {
            return this.son(this.indeX).getProbs(classIndex, instance, weight);
        }
        return 0.0;
    }

    protected ClassifierSplitModel localModel() {
        return this.m_localModel;
    }

    protected ClassifierDecList son(int index) {
        return this.m_sons[index];
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10153 $");
    }
}

