/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.ht;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import weka.classifiers.trees.ht.SplitMetric;
import weka.classifiers.trees.ht.WeightMass;

public class GiniSplitMetric
extends SplitMetric
implements Serializable {
    private static final long serialVersionUID = -2037586582742660298L;

    @Override
    public double evaluateSplit(Map<String, WeightMass> preDist, List<Map<String, WeightMass>> postDist) {
        double totalWeight = 0.0;
        double[] distWeights = new double[postDist.size()];
        for (int i2 = 0; i2 < postDist.size(); ++i2) {
            distWeights[i2] = SplitMetric.sum(postDist.get(i2));
            totalWeight += distWeights[i2];
        }
        double gini = 0.0;
        for (int i3 = 0; i3 < postDist.size(); ++i3) {
            gini += distWeights[i3] / totalWeight * GiniSplitMetric.gini(postDist.get(i3), distWeights[i3]);
        }
        return 1.0 - gini;
    }

    protected static double gini(Map<String, WeightMass> dist, double sumOfWeights) {
        double gini = 1.0;
        for (Map.Entry<String, WeightMass> e : dist.entrySet()) {
            double frac = e.getValue().m_weight / sumOfWeights;
            gini -= frac * frac;
        }
        return gini;
    }

    public static double gini(Map<String, WeightMass> dist) {
        return GiniSplitMetric.gini(dist, SplitMetric.sum(dist));
    }

    @Override
    public double getMetricRange(Map<String, WeightMass> preDist) {
        return 1.0;
    }
}

