/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import java.util.Enumeration;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.ModelSelection;
import weka.classifiers.trees.j48.NBTreeNoSplit;
import weka.classifiers.trees.j48.NBTreeSplit;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class NBTreeModelSelection
extends ModelSelection {
    private static final long serialVersionUID = 990097748931976704L;
    protected final int m_minNoObj;
    protected Instances m_allData;

    public NBTreeModelSelection(int minNoObj, Instances allData) {
        this.m_minNoObj = minNoObj;
        this.m_allData = allData;
    }

    public void cleanup() {
        this.m_allData = null;
    }

    @Override
    public final ClassifierSplitModel selectModel(Instances data) {
        double globalErrors = 0.0;
        NBTreeSplit bestModel = null;
        NBTreeNoSplit noSplitModel = null;
        int validModels = 0;
        try {
            int i2;
            noSplitModel = new NBTreeNoSplit();
            noSplitModel.buildClassifier(data);
            if (data.numInstances() < 5) {
                return noSplitModel;
            }
            globalErrors = noSplitModel.getErrors();
            if (globalErrors == 0.0) {
                return noSplitModel;
            }
            Distribution checkDistribution = new Distribution(data);
            if (Utils.sm(checkDistribution.total(), this.m_minNoObj) || Utils.eq(checkDistribution.total(), checkDistribution.perClass(checkDistribution.maxClass()))) {
                return noSplitModel;
            }
            if (this.m_allData != null) {
                Attribute attribute;
                Enumeration<Attribute> enu = data.enumerateAttributes();
                while (enu.hasMoreElements() && !(attribute = enu.nextElement()).isNumeric() && !Utils.sm(attribute.numValues(), 0.3 * (double)this.m_allData.numInstances())) {
                }
            }
            NBTreeSplit[] currentModel = new NBTreeSplit[data.numAttributes()];
            double sumOfWeights = data.sumOfWeights();
            for (i2 = 0; i2 < data.numAttributes(); ++i2) {
                if (i2 != data.classIndex()) {
                    currentModel[i2] = new NBTreeSplit(i2, this.m_minNoObj, sumOfWeights);
                    currentModel[i2].setGlobalModel(noSplitModel);
                    currentModel[i2].buildClassifier(data);
                    if (!currentModel[i2].checkModel()) continue;
                    ++validModels;
                    continue;
                }
                currentModel[i2] = null;
            }
            if (validModels == 0) {
                return noSplitModel;
            }
            double minResult = globalErrors;
            for (i2 = 0; i2 < data.numAttributes(); ++i2) {
                if (i2 == data.classIndex() || !currentModel[i2].checkModel() || !(currentModel[i2].getErrors() < minResult)) continue;
                bestModel = currentModel[i2];
                minResult = currentModel[i2].getErrors();
            }
            if ((globalErrors - minResult) / globalErrors < 0.05) {
                return noSplitModel;
            }
            return bestModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public final ClassifierSplitModel selectModel(Instances train, Instances test) {
        return this.selectModel(train);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10531 $");
    }
}

