/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.m5;

import java.io.Serializable;
import weka.classifiers.trees.m5.Impurity;
import weka.classifiers.trees.m5.SplitEvaluate;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public final class YongSplitInfo
implements Cloneable,
Serializable,
SplitEvaluate,
RevisionHandler {
    private static final long serialVersionUID = 1864267581079767881L;
    private int number;
    private int first;
    private int last;
    private int position;
    private double maxImpurity;
    private double leftAve;
    private double rightAve;
    private int splitAttr;
    private double splitValue;

    public YongSplitInfo(int low, int high, int attr) {
        this.number = high - low + 1;
        this.first = low;
        this.last = high;
        this.position = -1;
        this.maxImpurity = -1.0E20;
        this.splitAttr = attr;
        this.splitValue = 0.0;
    }

    @Override
    public final SplitEvaluate copy() throws Exception {
        YongSplitInfo s = (YongSplitInfo)this.clone();
        return s;
    }

    public final void initialize(int low, int high, int attr) {
        this.number = high - low + 1;
        this.first = low;
        this.last = high;
        this.position = -1;
        this.maxImpurity = -1.0E20;
        this.splitAttr = attr;
        this.splitValue = 0.0;
    }

    public final String toString(Instances inst) {
        StringBuffer text = new StringBuffer();
        text.append("Print SplitInfo:\n");
        text.append("    Instances:\t\t" + this.number + " (" + this.first + "-" + this.position + "," + (this.position + 1) + "-" + this.last + ")\n");
        text.append("    Maximum Impurity Reduction:\t" + Utils.doubleToString(this.maxImpurity, 1, 4) + "\n");
        text.append("    Left average:\t" + this.leftAve + "\n");
        text.append("    Right average:\t" + this.rightAve + "\n");
        if (this.maxImpurity > 0.0) {
            text.append("    Splitting function:\t" + inst.attribute(this.splitAttr).name() + " = " + this.splitValue + "\n");
        } else {
            text.append("    Splitting function:\tnull\n");
        }
        return text.toString();
    }

    @Override
    public final void attrSplit(int attr, Instances inst) throws Exception {
        int low = 0;
        int high = inst.numInstances() - 1;
        this.initialize(low, high, attr);
        if (this.number < 4) {
            return;
        }
        int len = high - low + 1 < 5 ? 1 : (high - low + 1) / 5;
        this.position = low;
        int part = low + len - 1;
        Impurity imp = new Impurity(part, attr, inst, 5);
        for (int i2 = low + len; i2 <= high - len - 1; ++i2) {
            imp.incremental(inst.instance(i2).classValue(), 1);
            if (Utils.eq(inst.instance(i2 + 1).value(attr), inst.instance(i2).value(attr)) || !(imp.impurity > this.maxImpurity)) continue;
            this.maxImpurity = imp.impurity;
            this.splitValue = (inst.instance(i2).value(attr) + inst.instance(i2 + 1).value(attr)) * 0.5;
            this.leftAve = imp.sl / imp.nl;
            this.rightAve = imp.sr / imp.nr;
            this.position = i2;
        }
    }

    @Override
    public double maxImpurity() {
        return this.maxImpurity;
    }

    @Override
    public int splitAttr() {
        return this.splitAttr;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public double splitValue() {
        return this.splitValue;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 11269 $");
    }
}

