/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.clusterers.RandomizableClusterer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class FarthestFirst
extends RandomizableClusterer
implements TechnicalInformationHandler {
    static final long serialVersionUID = 7499838100631329509L;
    protected Instances m_instances;
    protected ReplaceMissingValues m_ReplaceMissingFilter;
    protected int m_NumClusters = 2;
    protected Instances m_ClusterCentroids;
    private double[] m_Min;
    private double[] m_Max;

    public String globalInfo() {
        return "Cluster data using the FarthestFirst algorithm.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString() + "\n\nNotes:\n- works as a fast simple approximate clusterer\n- modelled after SimpleKMeans, might be a useful initializer for it";
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Hochbaum and Shmoys");
        result.setValue(TechnicalInformation.Field.YEAR, "1985");
        result.setValue(TechnicalInformation.Field.TITLE, "A best possible heuristic for the k-center problem");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Mathematics of Operations Research");
        result.setValue(TechnicalInformation.Field.VOLUME, "10");
        result.setValue(TechnicalInformation.Field.NUMBER, "2");
        result.setValue(TechnicalInformation.Field.PAGES, "180-184");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.INPROCEEDINGS);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Sanjoy Dasgupta");
        additional.setValue(TechnicalInformation.Field.TITLE, "Performance Guarantees for Hierarchical Clustering");
        additional.setValue(TechnicalInformation.Field.BOOKTITLE, "15th Annual Conference on Computational Learning Theory");
        additional.setValue(TechnicalInformation.Field.YEAR, "2002");
        additional.setValue(TechnicalInformation.Field.PAGES, "351-363");
        additional.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        return result;
    }

    @Override
    public void buildClusterer(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_ReplaceMissingFilter = new ReplaceMissingValues();
        this.m_ReplaceMissingFilter.setInputFormat(data);
        this.m_instances = Filter.useFilter(data, this.m_ReplaceMissingFilter);
        this.initMinMax(this.m_instances);
        this.m_ClusterCentroids = new Instances(this.m_instances, this.m_NumClusters);
        int n = this.m_instances.numInstances();
        Random r = new Random(this.getSeed());
        boolean[] selected = new boolean[n];
        double[] minDistance = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            minDistance[i2] = Double.MAX_VALUE;
        }
        int firstI = r.nextInt(n);
        this.m_ClusterCentroids.add(this.m_instances.instance(firstI));
        selected[firstI] = true;
        this.updateMinDistance(minDistance, selected, this.m_instances, this.m_instances.instance(firstI));
        if (this.m_NumClusters > n) {
            this.m_NumClusters = n;
        }
        for (int i3 = 1; i3 < this.m_NumClusters; ++i3) {
            int nextI = this.farthestAway(minDistance, selected);
            this.m_ClusterCentroids.add(this.m_instances.instance(nextI));
            selected[nextI] = true;
            this.updateMinDistance(minDistance, selected, this.m_instances, this.m_instances.instance(nextI));
        }
        this.m_instances = new Instances(this.m_instances, 0);
    }

    protected void updateMinDistance(double[] minDistance, boolean[] selected, Instances data, Instance center) {
        for (int i2 = 0; i2 < selected.length; ++i2) {
            double d;
            if (selected[i2] || !((d = this.distance(center, data.instance(i2))) < minDistance[i2])) continue;
            minDistance[i2] = d;
        }
    }

    protected int farthestAway(double[] minDistance, boolean[] selected) {
        double maxDistance = -1.0;
        int maxI = -1;
        for (int i2 = 0; i2 < selected.length; ++i2) {
            if (selected[i2] || !(maxDistance < minDistance[i2])) continue;
            maxDistance = minDistance[i2];
            maxI = i2;
        }
        return maxI;
    }

    protected void initMinMax(Instances data) {
        int i2;
        this.m_Min = new double[data.numAttributes()];
        this.m_Max = new double[data.numAttributes()];
        for (i2 = 0; i2 < data.numAttributes(); ++i2) {
            this.m_Max[i2] = Double.NaN;
            this.m_Min[i2] = Double.NaN;
        }
        for (i2 = 0; i2 < data.numInstances(); ++i2) {
            this.updateMinMax(data.instance(i2));
        }
    }

    private void updateMinMax(Instance instance) {
        for (int j = 0; j < instance.numAttributes(); ++j) {
            if (Double.isNaN(this.m_Min[j])) {
                this.m_Min[j] = instance.value(j);
                this.m_Max[j] = instance.value(j);
                continue;
            }
            if (instance.value(j) < this.m_Min[j]) {
                this.m_Min[j] = instance.value(j);
                continue;
            }
            if (!(instance.value(j) > this.m_Max[j])) continue;
            this.m_Max[j] = instance.value(j);
        }
    }

    protected int clusterProcessedInstance(Instance instance) {
        double minDist = Double.MAX_VALUE;
        int bestCluster = 0;
        for (int i2 = 0; i2 < this.m_NumClusters; ++i2) {
            double dist = this.distance(instance, this.m_ClusterCentroids.instance(i2));
            if (!(dist < minDist)) continue;
            minDist = dist;
            bestCluster = i2;
        }
        return bestCluster;
    }

    @Override
    public int clusterInstance(Instance instance) throws Exception {
        this.m_ReplaceMissingFilter.input(instance);
        this.m_ReplaceMissingFilter.batchFinished();
        Instance inst = this.m_ReplaceMissingFilter.output();
        return this.clusterProcessedInstance(inst);
    }

    protected double distance(Instance first, Instance second) {
        double distance = 0.0;
        int p1 = 0;
        int p2 = 0;
        while (p1 < first.numValues() || p2 < second.numValues()) {
            double diff;
            int firstI = p1 >= first.numValues() ? this.m_instances.numAttributes() : first.index(p1);
            int secondI = p2 >= second.numValues() ? this.m_instances.numAttributes() : second.index(p2);
            if (firstI == this.m_instances.classIndex()) {
                ++p1;
                continue;
            }
            if (secondI == this.m_instances.classIndex()) {
                ++p2;
                continue;
            }
            if (firstI == secondI) {
                diff = this.difference(firstI, first.valueSparse(p1), second.valueSparse(p2));
                ++p1;
                ++p2;
            } else if (firstI > secondI) {
                diff = this.difference(secondI, 0.0, second.valueSparse(p2));
                ++p2;
            } else {
                diff = this.difference(firstI, first.valueSparse(p1), 0.0);
                ++p1;
            }
            distance += diff * diff;
        }
        return Math.sqrt(distance / (double)this.m_instances.numAttributes());
    }

    protected double difference(int index, double val1, double val2) {
        switch (this.m_instances.attribute(index).type()) {
            case 1: {
                if (Utils.isMissingValue(val1) || Utils.isMissingValue(val2) || (int)val1 != (int)val2) {
                    return 1.0;
                }
                return 0.0;
            }
            case 0: {
                if (Utils.isMissingValue(val1) || Utils.isMissingValue(val2)) {
                    if (Utils.isMissingValue(val1) && Utils.isMissingValue(val2)) {
                        return 1.0;
                    }
                    double diff = Utils.isMissingValue(val2) ? this.norm(val1, index) : this.norm(val2, index);
                    if (diff < 0.5) {
                        diff = 1.0 - diff;
                    }
                    return diff;
                }
                return this.norm(val1, index) - this.norm(val2, index);
            }
        }
        return 0.0;
    }

    protected double norm(double x, int i2) {
        if (Double.isNaN(this.m_Min[i2]) || Utils.eq(this.m_Max[i2], this.m_Min[i2])) {
            return 0.0;
        }
        return (x - this.m_Min[i2]) / (this.m_Max[i2] - this.m_Min[i2]);
    }

    @Override
    public int numberOfClusters() throws Exception {
        return this.m_NumClusters;
    }

    public Instances getClusterCentroids() {
        return this.m_ClusterCentroids;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tnumber of clusters. (default = 2).", "N", 1, "-N <num>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    public String numClustersTipText() {
        return "set number of clusters";
    }

    public void setNumClusters(int n) throws Exception {
        if (n < 0) {
            throw new Exception("Number of clusters must be > 0");
        }
        this.m_NumClusters = n;
    }

    public int getNumClusters() {
        return this.m_NumClusters;
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String optionString = Utils.getOption('N', options);
        if (optionString.length() != 0) {
            this.setNumClusters(Integer.parseInt(optionString));
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-N");
        result.add("" + this.getNumClusters());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public String toString() {
        StringBuffer temp = new StringBuffer();
        temp.append("\nFarthestFirst\n==============\n");
        temp.append("\nCluster centroids:\n");
        for (int i2 = 0; i2 < this.m_NumClusters; ++i2) {
            temp.append("\nCluster " + i2 + "\n\t");
            for (int j = 0; j < this.m_ClusterCentroids.numAttributes(); ++j) {
                if (this.m_ClusterCentroids.attribute(j).isNominal()) {
                    temp.append(" " + this.m_ClusterCentroids.attribute(j).value((int)this.m_ClusterCentroids.instance(i2).value(j)));
                    continue;
                }
                temp.append(" " + this.m_ClusterCentroids.instance(i2).value(j));
            }
        }
        temp.append("\n\n");
        return temp.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10453 $");
    }

    public static void main(String[] argv) {
        FarthestFirst.runClusterer(new FarthestFirst(), argv);
    }
}

