/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.util.Enumeration;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.UnassignedClassException;
import weka.core.UnassignedDatasetException;
import weka.core.Utils;

public abstract class AbstractInstance
implements Instance,
Serializable,
RevisionHandler {
    static final long serialVersionUID = 1482635194499365155L;
    protected Instances m_Dataset;
    protected double[] m_AttValues;
    protected double m_Weight;
    public static int s_numericAfterDecimalPoint = 6;

    @Override
    public Attribute attribute(int index) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.attribute(index);
    }

    @Override
    public Attribute attributeSparse(int indexOfIndex) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.attribute(this.index(indexOfIndex));
    }

    @Override
    public Attribute classAttribute() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.classAttribute();
    }

    @Override
    public int classIndex() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.classIndex();
    }

    @Override
    public boolean classIsMissing() {
        int classIndex = this.classIndex();
        if (classIndex < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        return this.isMissing(classIndex);
    }

    @Override
    public double classValue() {
        int classIndex = this.classIndex();
        if (classIndex < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        return this.value(classIndex);
    }

    @Override
    public Instances dataset() {
        return this.m_Dataset;
    }

    @Override
    public void deleteAttributeAt(int position) {
        if (this.m_Dataset != null) {
            throw new RuntimeException("Instance has access to a dataset!");
        }
        this.forceDeleteAttributeAt(position);
    }

    @Override
    public Enumeration<Attribute> enumerateAttributes() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.enumerateAttributes();
    }

    @Override
    public boolean equalHeaders(Instance inst) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.equalHeaders(inst.dataset());
    }

    @Override
    public String equalHeadersMsg(Instance inst) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.equalHeadersMsg(inst.dataset());
    }

    @Override
    public boolean hasMissingValue() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        int classIndex = this.classIndex();
        for (int i2 = 0; i2 < this.numValues(); ++i2) {
            if (this.index(i2) == classIndex || !this.isMissingSparse(i2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void insertAttributeAt(int position) {
        if (this.m_Dataset != null) {
            throw new RuntimeException("Instance has accesss to a dataset!");
        }
        if (position < 0 || position > this.numAttributes()) {
            throw new IllegalArgumentException("Can't insert attribute: index out of range");
        }
        this.forceInsertAttributeAt(position);
    }

    @Override
    public boolean isMissing(int attIndex) {
        return Utils.isMissingValue(this.value(attIndex));
    }

    @Override
    public boolean isMissingSparse(int indexOfIndex) {
        return Utils.isMissingValue(this.valueSparse(indexOfIndex));
    }

    @Override
    public boolean isMissing(Attribute att) {
        return this.isMissing(att.index());
    }

    @Override
    public int numClasses() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.numClasses();
    }

    @Override
    public void setClassMissing() {
        int classIndex = this.classIndex();
        if (classIndex < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        this.setMissing(classIndex);
    }

    @Override
    public void setClassValue(double value) {
        int classIndex = this.classIndex();
        if (classIndex < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        this.setValue(classIndex, value);
    }

    @Override
    public final void setClassValue(String value) {
        int classIndex = this.classIndex();
        if (classIndex < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        this.setValue(classIndex, value);
    }

    @Override
    public final void setDataset(Instances instances) {
        this.m_Dataset = instances;
    }

    @Override
    public final void setMissing(int attIndex) {
        this.setValue(attIndex, Utils.missingValue());
    }

    @Override
    public final void setMissing(Attribute att) {
        this.setMissing(att.index());
    }

    @Override
    public final void setValue(int attIndex, String value) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        if (!this.attribute(attIndex).isNominal() && !this.attribute(attIndex).isString()) {
            throw new IllegalArgumentException("Attribute neither nominal nor string!");
        }
        int valIndex = this.attribute(attIndex).indexOfValue(value);
        if (valIndex == -1) {
            if (this.attribute(attIndex).isNominal()) {
                throw new IllegalArgumentException("Value not defined for given nominal attribute!");
            }
            this.attribute(attIndex).forceAddValue(value);
            valIndex = this.attribute(attIndex).indexOfValue(value);
        }
        this.setValue(attIndex, (double)valIndex);
    }

    @Override
    public final void setValue(Attribute att, double value) {
        this.setValue(att.index(), value);
    }

    @Override
    public final void setValue(Attribute att, String value) {
        if (!att.isNominal() && !att.isString()) {
            throw new IllegalArgumentException("Attribute neither nominal nor string!");
        }
        int valIndex = att.indexOfValue(value);
        if (valIndex == -1) {
            if (att.isNominal()) {
                throw new IllegalArgumentException("Value not defined for given nominal attribute!");
            }
            att.forceAddValue(value);
            valIndex = att.indexOfValue(value);
        }
        this.setValue(att.index(), (double)valIndex);
    }

    @Override
    public final void setWeight(double weight) {
        this.m_Weight = weight;
    }

    @Override
    public final Instances relationalValue(int attIndex) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.relationalValue(this.m_Dataset.attribute(attIndex));
    }

    @Override
    public final Instances relationalValue(Attribute att) {
        int attIndex = att.index();
        if (att.isRelationValued()) {
            if (this.isMissing(attIndex)) {
                return null;
            }
            return att.relation((int)this.value(attIndex));
        }
        throw new IllegalArgumentException("Attribute isn't relation-valued!");
    }

    @Override
    public final String stringValue(int attIndex) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.stringValue(this.m_Dataset.attribute(attIndex));
    }

    @Override
    public final String stringValue(Attribute att) {
        int attIndex = att.index();
        if (this.isMissing(attIndex)) {
            return "?";
        }
        switch (att.type()) {
            case 1: 
            case 2: {
                return att.value((int)this.value(attIndex));
            }
            case 3: {
                return att.formatDate(this.value(attIndex));
            }
            case 4: {
                return att.relation((int)this.value(attIndex)).stringWithoutHeader();
            }
        }
        throw new IllegalArgumentException("Attribute isn't nominal, string or date!");
    }

    @Override
    public final String toStringMaxDecimalDigits(int afterDecimalPoint) {
        StringBuffer text = new StringBuffer(this.toStringNoWeight(afterDecimalPoint));
        if (this.m_Weight != 1.0) {
            text.append(",{" + Utils.doubleToString(this.m_Weight, afterDecimalPoint) + "}");
        }
        return text.toString();
    }

    public String toString() {
        return this.toStringMaxDecimalDigits(s_numericAfterDecimalPoint);
    }

    @Override
    public final String toString(int attIndex) {
        return this.toString(attIndex, s_numericAfterDecimalPoint);
    }

    @Override
    public final String toString(int attIndex, int afterDecimalPoint) {
        StringBuffer text = new StringBuffer();
        if (this.isMissing(attIndex)) {
            text.append("?");
        } else if (this.m_Dataset == null) {
            text.append(Utils.doubleToString(this.value(attIndex), afterDecimalPoint));
        } else {
            switch (this.m_Dataset.attribute(attIndex).type()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    text.append(Utils.quote(this.stringValue(attIndex)));
                    break;
                }
                case 0: {
                    text.append(Utils.doubleToString(this.value(attIndex), afterDecimalPoint));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown attribute type");
                }
            }
        }
        return text.toString();
    }

    @Override
    public final String toString(Attribute att) {
        return this.toString(att.index());
    }

    @Override
    public final String toString(Attribute att, int afterDecimalPoint) {
        return this.toString(att.index(), afterDecimalPoint);
    }

    @Override
    public double value(Attribute att) {
        return this.value(att.index());
    }

    @Override
    public double valueSparse(int indexOfIndex) {
        return this.m_AttValues[indexOfIndex];
    }

    @Override
    public final double weight() {
        return this.m_Weight;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10649 $");
    }

    protected abstract void forceDeleteAttributeAt(int var1);

    protected abstract void forceInsertAttributeAt(int var1);
}

