/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SpecialFunctions;
import weka.core.Statistics;
import weka.core.Utils;

public class ContingencyTables
implements RevisionHandler {
    public static final double log2 = Math.log(2.0);
    private static final double MAX_INT_FOR_CACHE_PLUS_ONE = 10000.0;
    private static final double[] INT_N_LOG_N_CACHE = new double[10000];

    public static double chiSquared(double[][] matrix, boolean yates) {
        int df = (matrix.length - 1) * (matrix[0].length - 1);
        return Statistics.chiSquaredProbability(ContingencyTables.chiVal(matrix, yates), df);
    }

    public static double chiVal(double[][] matrix, boolean useYates) {
        int col;
        int row;
        double expect = 0.0;
        double chival = 0.0;
        double n = 0.0;
        boolean yates = true;
        int nrows = matrix.length;
        int ncols = matrix[0].length;
        double[] rtotal = new double[nrows];
        double[] ctotal = new double[ncols];
        for (row = 0; row < nrows; ++row) {
            for (col = 0; col < ncols; ++col) {
                int n2 = row;
                rtotal[n2] = rtotal[n2] + matrix[row][col];
                int n3 = col;
                ctotal[n3] = ctotal[n3] + matrix[row][col];
                n += matrix[row][col];
            }
        }
        int df = (nrows - 1) * (ncols - 1);
        if (df > 1 || !useYates) {
            yates = false;
        } else if (df <= 0) {
            return 0.0;
        }
        chival = 0.0;
        for (row = 0; row < nrows; ++row) {
            if (!Utils.gr(rtotal[row], 0.0)) continue;
            for (col = 0; col < ncols; ++col) {
                if (!Utils.gr(ctotal[col], 0.0)) continue;
                expect = ctotal[col] * rtotal[row] / n;
                chival += ContingencyTables.chiCell(matrix[row][col], expect, yates);
            }
        }
        return chival;
    }

    public static boolean cochransCriterion(double[][] matrix) {
        int col;
        int row;
        double n = 0.0;
        double smallfreq = 5.0;
        int smallcount = 0;
        int nonZeroRows = 0;
        int nonZeroColumns = 0;
        int nrows = matrix.length;
        int ncols = matrix[0].length;
        double[] rtotal = new double[nrows];
        double[] ctotal = new double[ncols];
        for (row = 0; row < nrows; ++row) {
            for (col = 0; col < ncols; ++col) {
                int n2 = row;
                rtotal[n2] = rtotal[n2] + matrix[row][col];
                int n3 = col;
                ctotal[n3] = ctotal[n3] + matrix[row][col];
                n += matrix[row][col];
            }
        }
        for (row = 0; row < nrows; ++row) {
            if (!Utils.gr(rtotal[row], 0.0)) continue;
            ++nonZeroRows;
        }
        for (col = 0; col < ncols; ++col) {
            if (!Utils.gr(ctotal[col], 0.0)) continue;
            ++nonZeroColumns;
        }
        for (row = 0; row < nrows; ++row) {
            if (!Utils.gr(rtotal[row], 0.0)) continue;
            for (col = 0; col < ncols; ++col) {
                double expect;
                if (!Utils.gr(ctotal[col], 0.0) || !Utils.sm(expect = ctotal[col] * rtotal[row] / n, smallfreq)) continue;
                if (Utils.sm(expect, 1.0)) {
                    return false;
                }
                if (!((double)(++smallcount) > (double)(nonZeroRows * nonZeroColumns) / smallfreq)) continue;
                return false;
            }
        }
        return true;
    }

    public static double CramersV(double[][] matrix) {
        int min;
        double n = 0.0;
        int nrows = matrix.length;
        int ncols = matrix[0].length;
        for (int row = 0; row < nrows; ++row) {
            for (int col = 0; col < ncols; ++col) {
                n += matrix[row][col];
            }
        }
        int n2 = min = nrows < ncols ? nrows - 1 : ncols - 1;
        if (min == 0 || Utils.eq(n, 0.0)) {
            return 0.0;
        }
        return Math.sqrt(ContingencyTables.chiVal(matrix, false) / (n * (double)min));
    }

    public static double entropy(double[] array) {
        double returnValue = 0.0;
        double sum = 0.0;
        for (int i2 = 0; i2 < array.length; ++i2) {
            returnValue -= ContingencyTables.lnFunc(array[i2]);
            sum += array[i2];
        }
        if (Utils.eq(sum, 0.0)) {
            return 0.0;
        }
        return (returnValue + ContingencyTables.lnFunc(sum)) / (sum * log2);
    }

    public static double entropyConditionedOnColumns(double[][] matrix) {
        double returnValue = 0.0;
        double total = 0.0;
        for (int j = 0; j < matrix[0].length; ++j) {
            double sumForColumn = 0.0;
            for (int i2 = 0; i2 < matrix.length; ++i2) {
                returnValue += ContingencyTables.lnFunc(matrix[i2][j]);
                sumForColumn += matrix[i2][j];
            }
            returnValue -= ContingencyTables.lnFunc(sumForColumn);
            total += sumForColumn;
        }
        if (Utils.eq(total, 0.0)) {
            return 0.0;
        }
        return -returnValue / (total * log2);
    }

    public static double entropyConditionedOnRows(double[][] matrix) {
        double returnValue = 0.0;
        double total = 0.0;
        for (int i2 = 0; i2 < matrix.length; ++i2) {
            double sumForRow = 0.0;
            for (int j = 0; j < matrix[0].length; ++j) {
                returnValue += ContingencyTables.lnFunc(matrix[i2][j]);
                sumForRow += matrix[i2][j];
            }
            returnValue -= ContingencyTables.lnFunc(sumForRow);
            total += sumForRow;
        }
        if (Utils.eq(total, 0.0)) {
            return 0.0;
        }
        return -returnValue / (total * log2);
    }

    public static double entropyConditionedOnRows(double[][] train, double[][] test, double numClasses) {
        double returnValue = 0.0;
        double testSum = 0.0;
        for (int i2 = 0; i2 < test.length; ++i2) {
            double trainSumForRow = 0.0;
            double testSumForRow = 0.0;
            for (int j = 0; j < test[0].length; ++j) {
                returnValue -= test[i2][j] * Math.log(train[i2][j] + 1.0);
                trainSumForRow += train[i2][j];
                testSumForRow += test[i2][j];
            }
            testSum = testSumForRow;
            returnValue += testSumForRow * Math.log(trainSumForRow + numClasses);
        }
        return returnValue / (testSum * log2);
    }

    public static double entropyOverRows(double[][] matrix) {
        double returnValue = 0.0;
        double total = 0.0;
        for (int i2 = 0; i2 < matrix.length; ++i2) {
            double sumForRow = 0.0;
            for (int j = 0; j < matrix[0].length; ++j) {
                sumForRow += matrix[i2][j];
            }
            returnValue -= ContingencyTables.lnFunc(sumForRow);
            total += sumForRow;
        }
        if (Utils.eq(total, 0.0)) {
            return 0.0;
        }
        return (returnValue + ContingencyTables.lnFunc(total)) / (total * log2);
    }

    public static double entropyOverColumns(double[][] matrix) {
        double returnValue = 0.0;
        double total = 0.0;
        for (int j = 0; j < matrix[0].length; ++j) {
            double sumForColumn = 0.0;
            for (int i2 = 0; i2 < matrix.length; ++i2) {
                sumForColumn += matrix[i2][j];
            }
            returnValue -= ContingencyTables.lnFunc(sumForColumn);
            total += sumForColumn;
        }
        if (Utils.eq(total, 0.0)) {
            return 0.0;
        }
        return (returnValue + ContingencyTables.lnFunc(total)) / (total * log2);
    }

    public static double gainRatio(double[][] matrix) {
        int j;
        int i2;
        double preSplit = 0.0;
        double postSplit = 0.0;
        double splitEnt = 0.0;
        double total = 0.0;
        for (i2 = 0; i2 < matrix[0].length; ++i2) {
            double sumForColumn = 0.0;
            for (j = 0; j < matrix.length; ++j) {
                sumForColumn += matrix[j][i2];
            }
            preSplit += ContingencyTables.lnFunc(sumForColumn);
            total += sumForColumn;
        }
        preSplit -= ContingencyTables.lnFunc(total);
        for (i2 = 0; i2 < matrix.length; ++i2) {
            double sumForRow = 0.0;
            for (j = 0; j < matrix[0].length; ++j) {
                postSplit += ContingencyTables.lnFunc(matrix[i2][j]);
                sumForRow += matrix[i2][j];
            }
            splitEnt += ContingencyTables.lnFunc(sumForRow);
        }
        postSplit -= splitEnt;
        double infoGain = preSplit - postSplit;
        if (Utils.eq(splitEnt -= ContingencyTables.lnFunc(total), 0.0)) {
            return 0.0;
        }
        return infoGain / splitEnt;
    }

    public static double log2MultipleHypergeometric(double[][] matrix) {
        int j;
        int i2;
        double sum = 0.0;
        double total = 0.0;
        for (i2 = 0; i2 < matrix.length; ++i2) {
            double sumForRow = 0.0;
            for (j = 0; j < matrix[i2].length; ++j) {
                sumForRow += matrix[i2][j];
            }
            sum += SpecialFunctions.lnFactorial(sumForRow);
            total += sumForRow;
        }
        for (int j2 = 0; j2 < matrix[0].length; ++j2) {
            double sumForColumn = 0.0;
            for (int i3 = 0; i3 < matrix.length; ++i3) {
                sumForColumn += matrix[i3][j2];
            }
            sum += SpecialFunctions.lnFactorial(sumForColumn);
        }
        for (i2 = 0; i2 < matrix.length; ++i2) {
            for (j = 0; j < matrix[i2].length; ++j) {
                sum -= SpecialFunctions.lnFactorial(matrix[i2][j]);
            }
        }
        return -(sum -= SpecialFunctions.lnFactorial(total)) / log2;
    }

    public static double[][] reduceMatrix(double[][] matrix) {
        int col;
        int row;
        int nonZeroRows = 0;
        int nonZeroColumns = 0;
        int nrows = matrix.length;
        int ncols = matrix[0].length;
        double[] rtotal = new double[nrows];
        double[] ctotal = new double[ncols];
        for (row = 0; row < nrows; ++row) {
            for (col = 0; col < ncols; ++col) {
                int n = row;
                rtotal[n] = rtotal[n] + matrix[row][col];
                int n2 = col;
                ctotal[n2] = ctotal[n2] + matrix[row][col];
            }
        }
        for (row = 0; row < nrows; ++row) {
            if (!Utils.gr(rtotal[row], 0.0)) continue;
            ++nonZeroRows;
        }
        for (col = 0; col < ncols; ++col) {
            if (!Utils.gr(ctotal[col], 0.0)) continue;
            ++nonZeroColumns;
        }
        double[][] newMatrix = new double[nonZeroRows][nonZeroColumns];
        int currRow = 0;
        for (row = 0; row < nrows; ++row) {
            if (!Utils.gr(rtotal[row], 0.0)) continue;
            int currCol = 0;
            for (col = 0; col < ncols; ++col) {
                if (!Utils.gr(ctotal[col], 0.0)) continue;
                newMatrix[currRow][currCol] = matrix[row][col];
                ++currCol;
            }
            ++currRow;
        }
        return newMatrix;
    }

    public static double symmetricalUncertainty(double[][] matrix) {
        int j;
        int i2;
        double total = 0.0;
        double columnEntropy = 0.0;
        double rowEntropy = 0.0;
        double entropyConditionedOnRows = 0.0;
        double infoGain = 0.0;
        for (i2 = 0; i2 < matrix[0].length; ++i2) {
            double sumForColumn = 0.0;
            for (j = 0; j < matrix.length; ++j) {
                sumForColumn += matrix[j][i2];
            }
            columnEntropy += ContingencyTables.lnFunc(sumForColumn);
            total += sumForColumn;
        }
        columnEntropy -= ContingencyTables.lnFunc(total);
        for (i2 = 0; i2 < matrix.length; ++i2) {
            double sumForRow = 0.0;
            for (j = 0; j < matrix[0].length; ++j) {
                sumForRow += matrix[i2][j];
                entropyConditionedOnRows += ContingencyTables.lnFunc(matrix[i2][j]);
            }
            rowEntropy += ContingencyTables.lnFunc(sumForRow);
        }
        entropyConditionedOnRows -= rowEntropy;
        infoGain = columnEntropy - entropyConditionedOnRows;
        if (Utils.eq(columnEntropy, 0.0) || Utils.eq(rowEntropy -= ContingencyTables.lnFunc(total), 0.0)) {
            return 0.0;
        }
        return 2.0 * (infoGain / (columnEntropy + rowEntropy));
    }

    public static double tauVal(double[][] matrix) {
        double maxcol = 0.0;
        double maxtotal = 0.0;
        double n = 0.0;
        int nrows = matrix.length;
        int ncols = matrix[0].length;
        double[] ctotal = new double[ncols];
        for (int row = 0; row < nrows; ++row) {
            double max = 0.0;
            for (int col = 0; col < ncols; ++col) {
                if (Utils.gr(matrix[row][col], max)) {
                    max = matrix[row][col];
                }
                int n2 = col;
                ctotal[n2] = ctotal[n2] + matrix[row][col];
                n += matrix[row][col];
            }
            maxtotal += max;
        }
        if (Utils.eq(n, 0.0)) {
            return 0.0;
        }
        maxcol = ctotal[Utils.maxIndex(ctotal)];
        return (maxtotal - maxcol) / (n - maxcol);
    }

    public static double lnFunc(double num) {
        int n;
        if (num <= 0.0) {
            return 0.0;
        }
        if (num < 10000.0 && (double)(n = (int)num) == num) {
            return INT_N_LOG_N_CACHE[n];
        }
        return num * Math.log(num);
    }

    private static double chiCell(double freq, double expected, boolean yates) {
        if (Utils.smOrEq(expected, 0.0)) {
            return 0.0;
        }
        double diff = Math.abs(freq - expected);
        if (yates && (diff -= 0.5) < 0.0) {
            diff = 0.0;
        }
        return diff * diff / expected;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10057 $");
    }

    public static void main(String[] ops) {
        int j;
        int i2;
        double[] firstRow = new double[]{10.0, 5.0, 20.0};
        double[] secondRow = new double[]{2.0, 10.0, 6.0};
        double[] thirdRow = new double[]{5.0, 10.0, 10.0};
        double[][] matrix = new double[3][0];
        matrix[0] = firstRow;
        matrix[1] = secondRow;
        matrix[2] = thirdRow;
        for (int i3 = 0; i3 < matrix.length; ++i3) {
            for (int j2 = 0; j2 < matrix[i3].length; ++j2) {
                System.out.print(matrix[i3][j2] + " ");
            }
            System.out.println();
        }
        System.out.println("Chi-squared probability: " + ContingencyTables.chiSquared(matrix, false));
        System.out.println("Chi-squared value: " + ContingencyTables.chiVal(matrix, false));
        System.out.println("Cochran's criterion fullfilled: " + ContingencyTables.cochransCriterion(matrix));
        System.out.println("Cramer's V: " + ContingencyTables.CramersV(matrix));
        System.out.println("Entropy of first row: " + ContingencyTables.entropy(firstRow));
        System.out.println("Entropy conditioned on columns: " + ContingencyTables.entropyConditionedOnColumns(matrix));
        System.out.println("Entropy conditioned on rows: " + ContingencyTables.entropyConditionedOnRows(matrix));
        System.out.println("Entropy conditioned on rows (with Laplace): " + ContingencyTables.entropyConditionedOnRows(matrix, matrix, 3.0));
        System.out.println("Entropy of rows: " + ContingencyTables.entropyOverRows(matrix));
        System.out.println("Entropy of columns: " + ContingencyTables.entropyOverColumns(matrix));
        System.out.println("Gain ratio: " + ContingencyTables.gainRatio(matrix));
        System.out.println("Negative log2 of multiple hypergeometric probability: " + ContingencyTables.log2MultipleHypergeometric(matrix));
        System.out.println("Symmetrical uncertainty: " + ContingencyTables.symmetricalUncertainty(matrix));
        System.out.println("Tau value: " + ContingencyTables.tauVal(matrix));
        double[][] newMatrix = new double[3][3];
        newMatrix[0][0] = 1.0;
        newMatrix[0][1] = 0.0;
        newMatrix[0][2] = 1.0;
        newMatrix[1][0] = 0.0;
        newMatrix[1][1] = 0.0;
        newMatrix[1][2] = 0.0;
        newMatrix[2][0] = 1.0;
        newMatrix[2][1] = 0.0;
        newMatrix[2][2] = 1.0;
        System.out.println("Matrix with empty row and column: ");
        for (i2 = 0; i2 < newMatrix.length; ++i2) {
            for (j = 0; j < newMatrix[i2].length; ++j) {
                System.out.print(newMatrix[i2][j] + " ");
            }
            System.out.println();
        }
        System.out.println("Reduced matrix: ");
        newMatrix = ContingencyTables.reduceMatrix(newMatrix);
        for (i2 = 0; i2 < newMatrix.length; ++i2) {
            for (j = 0; j < newMatrix[i2].length; ++j) {
                System.out.print(newMatrix[i2][j] + " ");
            }
            System.out.println();
        }
    }

    static {
        int i2 = 1;
        while ((double)i2 < 10000.0) {
            double d = i2;
            ContingencyTables.INT_N_LOG_N_CACHE[i2] = d * Math.log(d);
            ++i2;
        }
    }
}

