/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.NormalizableDistance;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.neighboursearch.PerformanceStats;

public class MinkowskiDistance
extends NormalizableDistance
implements Cloneable,
TechnicalInformationHandler {
    private static final long serialVersionUID = -7446019339455453893L;
    protected double m_Order = 2.0;

    public MinkowskiDistance() {
    }

    public MinkowskiDistance(Instances data) {
        super(data);
    }

    @Override
    public String globalInfo() {
        return "Implementing Minkowski distance (or similarity) function.\n\nOne object defines not one distance but the data model in which the distances between objects of that data model can be computed.\n\nAttention: For efficiency reasons the use of consistency checks (like are the data models of the two instances exactly the same), is low.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Wikipedia");
        result.setValue(TechnicalInformation.Field.TITLE, "Minkowski distance");
        result.setValue(TechnicalInformation.Field.URL, "http://en.wikipedia.org/wiki/Minkowski_distance");
        return result;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe order 'p'. With '1' being the Manhattan distance and '2'\n\tthe Euclidean distance.\n\t(default: 2)", "P", 1, "-P <order>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('P', options);
        if (tmpStr.length() > 0) {
            this.setOrder(Double.parseDouble(tmpStr));
        } else {
            this.setOrder(2.0);
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-P");
        result.add("" + this.getOrder());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public String orderTipText() {
        return "The order of the Minkowski distance ('1' is Manhattan distance and '2' the Euclidean distance).";
    }

    public void setOrder(double value) {
        if (this.m_Order != 0.0) {
            this.m_Order = value;
            this.invalidate();
        } else {
            System.err.println("Order cannot be zero!");
        }
    }

    public double getOrder() {
        return this.m_Order;
    }

    @Override
    public double distance(Instance first, Instance second) {
        return Math.pow(this.distance(first, second, Double.POSITIVE_INFINITY), 1.0 / this.m_Order);
    }

    @Override
    public double distance(Instance first, Instance second, PerformanceStats stats) {
        return Math.pow(this.distance(first, second, Double.POSITIVE_INFINITY, stats), 1.0 / this.m_Order);
    }

    @Override
    protected double updateDistance(double currDist, double diff) {
        double result = currDist;
        return result += Math.pow(Math.abs(diff), this.m_Order);
    }

    @Override
    public void postProcessDistances(double[] distances) {
        for (int i2 = 0; i2 < distances.length; ++i2) {
            distances[i2] = Math.pow(distances[i2], 1.0 / this.m_Order);
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 0$");
    }
}

