/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import weka.core.Attribute;
import weka.core.AttributeLocator;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class RelationalLocator
extends AttributeLocator {
    private static final long serialVersionUID = 4646872277151854732L;

    public RelationalLocator(Instances data) {
        super(data, 4);
    }

    public RelationalLocator(Instances data, int fromIndex, int toIndex) {
        super(data, 4, fromIndex, toIndex);
    }

    public RelationalLocator(Instances data, int[] indices) {
        super(data, 4, indices);
    }

    public static void copyRelationalValues(Instance inst, Instances destDataset, AttributeLocator strAtts) {
        if (inst.dataset() == null) {
            throw new IllegalArgumentException("Instance has no dataset assigned!!");
        }
        if (inst.dataset().numAttributes() != destDataset.numAttributes()) {
            throw new IllegalArgumentException("Src and Dest differ in # of attributes: " + inst.dataset().numAttributes() + " != " + destDataset.numAttributes());
        }
        RelationalLocator.copyRelationalValues(inst, true, inst.dataset(), strAtts, destDataset, strAtts);
    }

    public static void copyRelationalValues(Instance instance, boolean instSrcCompat, Instances srcDataset, AttributeLocator srcLoc, Instances destDataset, AttributeLocator destLoc) {
        if (srcDataset == destDataset) {
            return;
        }
        if (srcLoc.getAttributeIndices().length != destLoc.getAttributeIndices().length) {
            throw new IllegalArgumentException("Src and Dest relational indices differ in length: " + srcLoc.getAttributeIndices().length + " != " + destLoc.getAttributeIndices().length);
        }
        if (srcLoc.getLocatorIndices().length != destLoc.getLocatorIndices().length) {
            throw new IllegalArgumentException("Src and Dest locator indices differ in length: " + srcLoc.getLocatorIndices().length + " != " + destLoc.getLocatorIndices().length);
        }
        for (int i2 = 0; i2 < srcLoc.getAttributeIndices().length; ++i2) {
            int instIndex = instSrcCompat ? srcLoc.getActualIndex(srcLoc.getAttributeIndices()[i2]) : destLoc.getActualIndex(destLoc.getAttributeIndices()[i2]);
            Attribute src = srcDataset.attribute(srcLoc.getActualIndex(srcLoc.getAttributeIndices()[i2]));
            Attribute dest = destDataset.attribute(destLoc.getActualIndex(destLoc.getAttributeIndices()[i2]));
            if (instance.isMissing(instIndex)) continue;
            int valIndex = dest.addRelation(src.relation((int)instance.value(instIndex)));
            instance.setValue(instIndex, (double)valIndex);
        }
        int[] srcIndices = srcLoc.getLocatorIndices();
        int[] destIndices = destLoc.getLocatorIndices();
        for (int i3 = 0; i3 < srcIndices.length; ++i3) {
            int index;
            int n = index = instSrcCompat ? srcLoc.getActualIndex(srcIndices[i3]) : destLoc.getActualIndex(destIndices[i3]);
            if (instance.isMissing(index)) continue;
            int valueIndex = (int)instance.value(index);
            Instances rel = instSrcCompat ? srcDataset.attribute(index).relation(valueIndex) : destDataset.attribute(index).relation(valueIndex);
            AttributeLocator srcRelAttsNew = srcLoc.getLocator(srcIndices[i3]);
            Instances srcDatasetNew = srcRelAttsNew.getData();
            AttributeLocator destRelAttsNew = destLoc.getLocator(destIndices[i3]);
            Instances destDatasetNew = destRelAttsNew.getData();
            for (int n2 = 0; n2 < rel.numInstances(); ++n2) {
                RelationalLocator.copyRelationalValues(rel.instance(n2), instSrcCompat, srcDatasetNew, srcRelAttsNew, destDatasetNew, destRelAttsNew);
            }
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 12038 $");
    }
}

