/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.util.HashSet;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Tag;

public class SelectedTag
implements RevisionHandler,
Serializable {
    private static final long serialVersionUID = 6947341624626504975L;
    protected int m_Selected;
    protected Tag[] m_Tags;

    public SelectedTag(int tagID, Tag[] tags) {
        int i2;
        HashSet<Integer> ID = new HashSet<Integer>();
        HashSet<String> IDStr = new HashSet<String>();
        for (i2 = 0; i2 < tags.length; ++i2) {
            Integer newID = new Integer(tags[i2].getID());
            if (ID.contains(newID)) {
                throw new IllegalArgumentException("The IDs are not unique: " + newID + "!");
            }
            ID.add(newID);
            String IDstring = tags[i2].getIDStr();
            if (IDStr.contains(IDstring)) {
                throw new IllegalArgumentException("The ID strings are not unique: " + IDstring + "!");
            }
            IDStr.add(IDstring);
        }
        for (i2 = 0; i2 < tags.length; ++i2) {
            if (tags[i2].getID() != tagID) continue;
            this.m_Selected = i2;
            this.m_Tags = tags;
            return;
        }
        throw new IllegalArgumentException("Selected tag is not valid");
    }

    public SelectedTag(String tagText, Tag[] tags) {
        for (int i2 = 0; i2 < tags.length; ++i2) {
            if (!tags[i2].getReadable().equalsIgnoreCase(tagText) && !tags[i2].getIDStr().equalsIgnoreCase(tagText)) continue;
            this.m_Selected = i2;
            this.m_Tags = tags;
            return;
        }
        throw new IllegalArgumentException("Selected tag is not valid");
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        SelectedTag s = (SelectedTag)o;
        return s.getTags() == this.m_Tags && s.getSelectedTag() == this.m_Tags[this.m_Selected];
    }

    public Tag getSelectedTag() {
        return this.m_Tags[this.m_Selected];
    }

    public Tag[] getTags() {
        return this.m_Tags;
    }

    public String toString() {
        return this.getSelectedTag().toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 11718 $");
    }
}

