/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import weka.core.Attribute;
import weka.core.AttributeLocator;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class StringLocator
extends AttributeLocator {
    private static final long serialVersionUID = 7805522230268783972L;

    public StringLocator(Instances data) {
        super(data, 2);
    }

    public StringLocator(Instances data, int fromIndex, int toIndex) {
        super(data, 2, fromIndex, toIndex);
    }

    public StringLocator(Instances data, int[] indices) {
        super(data, 2, indices);
    }

    public static void copyStringValues(Instance inst, Instances destDataset, AttributeLocator strAtts) {
        if (inst.dataset() == null) {
            throw new IllegalArgumentException("Instance has no dataset assigned!!");
        }
        if (inst.dataset().numAttributes() != destDataset.numAttributes()) {
            throw new IllegalArgumentException("Src and Dest differ in # of attributes: " + inst.dataset().numAttributes() + " != " + destDataset.numAttributes());
        }
        StringLocator.copyStringValues(inst, true, inst.dataset(), strAtts, destDataset, strAtts);
    }

    public static void copyStringValues(Instance instance, boolean instSrcCompat, Instances srcDataset, AttributeLocator srcLoc, Instances destDataset, AttributeLocator destLoc) {
        if (srcDataset == destDataset) {
            return;
        }
        if (srcLoc.getAttributeIndices().length != destLoc.getAttributeIndices().length) {
            throw new IllegalArgumentException("Src and Dest string indices differ in length: " + srcLoc.getAttributeIndices().length + " != " + destLoc.getAttributeIndices().length);
        }
        if (srcLoc.getLocatorIndices().length != destLoc.getLocatorIndices().length) {
            throw new IllegalArgumentException("Src and Dest locator indices differ in length: " + srcLoc.getLocatorIndices().length + " != " + destLoc.getLocatorIndices().length);
        }
        for (int i2 = 0; i2 < srcLoc.getAttributeIndices().length; ++i2) {
            int instIndex = instSrcCompat ? srcLoc.getActualIndex(srcLoc.getAttributeIndices()[i2]) : destLoc.getActualIndex(destLoc.getAttributeIndices()[i2]);
            Attribute src = srcDataset.attribute(srcLoc.getActualIndex(srcLoc.getAttributeIndices()[i2]));
            Attribute dest = destDataset.attribute(destLoc.getActualIndex(destLoc.getAttributeIndices()[i2]));
            if (instance.isMissing(instIndex)) continue;
            int valIndex = dest.addStringValue(src, (int)instance.value(instIndex));
            instance.setValue(instIndex, (double)valIndex);
        }
        int[] srcIndices = srcLoc.getLocatorIndices();
        int[] destIndices = destLoc.getLocatorIndices();
        for (int i3 = 0; i3 < srcIndices.length; ++i3) {
            int index;
            int n = index = instSrcCompat ? srcLoc.getActualIndex(srcIndices[i3]) : destLoc.getActualIndex(destIndices[i3]);
            if (instance.isMissing(index)) continue;
            int valueIndex = (int)instance.value(index);
            Instances rel = instSrcCompat ? srcDataset.attribute(index).relation(valueIndex) : destDataset.attribute(index).relation(valueIndex);
            AttributeLocator srcStrAttsNew = srcLoc.getLocator(srcIndices[i3]);
            Instances srcDatasetNew = srcStrAttsNew.getData();
            AttributeLocator destStrAttsNew = destLoc.getLocator(destIndices[i3]);
            Instances destDatasetNew = destStrAttsNew.getData();
            for (int n2 = 0; n2 < rel.numInstances(); ++n2) {
                StringLocator.copyStringValues(rel.instance(n2), instSrcCompat, srcDatasetNew, srcStrAttsNew, destDatasetNew, destStrAttsNew);
            }
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 12038 $");
    }
}

