/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.PrintStream;
import java.util.Date;
import java.util.Vector;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class Tee
extends PrintStream
implements RevisionHandler {
    protected Vector<PrintStream> m_Streams = new Vector();
    protected Vector<Boolean> m_Timestamps = new Vector();
    protected Vector<String> m_Prefixes = new Vector();
    protected PrintStream m_Default = null;

    public Tee() {
        this(System.out);
    }

    public Tee(PrintStream def) {
        super(def);
        this.m_Default = def;
        this.clear();
    }

    public void clear() {
        this.m_Streams.clear();
        this.m_Timestamps.clear();
        this.m_Prefixes.clear();
        if (this.getDefault() != null) {
            this.add(this.getDefault());
        }
    }

    public PrintStream getDefault() {
        return this.m_Default;
    }

    public void add(PrintStream p) {
        this.add(p, false);
    }

    public void add(PrintStream p, boolean timestamp) {
        this.add(p, timestamp, "");
    }

    public void add(PrintStream p, boolean timestamp, String prefix) {
        if (this.m_Streams.contains(p)) {
            this.remove(p);
        }
        if (prefix == null) {
            prefix = "";
        }
        this.m_Streams.add(p);
        this.m_Timestamps.add(new Boolean(timestamp));
        this.m_Prefixes.add(prefix);
    }

    public PrintStream get(int index) {
        if (index >= 0 && index < this.size()) {
            return this.m_Streams.get(index);
        }
        return null;
    }

    public PrintStream remove(PrintStream p) {
        if (this.contains(p)) {
            int index = this.m_Streams.indexOf(p);
            this.m_Timestamps.remove(index);
            this.m_Prefixes.remove(index);
            return this.m_Streams.remove(index);
        }
        return null;
    }

    public PrintStream remove(int index) {
        if (index >= 0 && index < this.size()) {
            this.m_Timestamps.remove(index);
            this.m_Prefixes.remove(index);
            return this.m_Streams.remove(index);
        }
        return null;
    }

    public boolean contains(PrintStream p) {
        return this.m_Streams.contains(p);
    }

    public int size() {
        return this.m_Streams.size();
    }

    private void printHeader() {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (!this.m_Prefixes.get(i2).equals("")) {
                this.m_Streams.get(i2).print("[" + this.m_Prefixes.get(i2) + "]\t");
            }
            if (!this.m_Timestamps.get(i2).booleanValue()) continue;
            this.m_Streams.get(i2).print("[" + new Date() + "]\t");
        }
    }

    @Override
    public void flush() {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.m_Streams.get(i2).flush();
        }
    }

    @Override
    public void print(int x) {
        this.printHeader();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.m_Streams.get(i2).print(x);
        }
        this.flush();
    }

    @Override
    public void print(long x) {
        this.printHeader();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.m_Streams.get(i2).print(x);
        }
        this.flush();
    }

    @Override
    public void print(float x) {
        this.printHeader();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.m_Streams.get(i2).print(x);
        }
        this.flush();
    }

    @Override
    public void print(double x) {
        this.printHeader();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.m_Streams.get(i2).print(x);
        }
        this.flush();
    }

    @Override
    public void print(boolean x) {
        this.printHeader();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.m_Streams.get(i2).print(x);
        }
        this.flush();
    }

    @Override
    public void print(char x) {
        this.printHeader();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.m_Streams.get(i2).print(x);
        }
        this.flush();
    }

    @Override
    public void print(char[] x) {
        this.printHeader();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.m_Streams.get(i2).print(x);
        }
        this.flush();
    }

    @Override
    public void print(String x) {
        this.printHeader();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.m_Streams.get(i2).print(x);
        }
        this.flush();
    }

    @Override
    public void print(Object x) {
        this.printHeader();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.m_Streams.get(i2).print(x);
        }
        this.flush();
    }

    @Override
    public void println() {
        this.printHeader();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.m_Streams.get(i2).println();
        }
        this.flush();
    }

    @Override
    public void println(int x) {
        this.printHeader();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.m_Streams.get(i2).println(x);
        }
        this.flush();
    }

    @Override
    public void println(long x) {
        this.printHeader();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.m_Streams.get(i2).println(x);
        }
        this.flush();
    }

    @Override
    public void println(float x) {
        this.printHeader();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.m_Streams.get(i2).println(x);
        }
        this.flush();
    }

    @Override
    public void println(double x) {
        this.printHeader();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.m_Streams.get(i2).println(x);
        }
        this.flush();
    }

    @Override
    public void println(boolean x) {
        this.printHeader();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.m_Streams.get(i2).println(x);
        }
        this.flush();
    }

    @Override
    public void println(char x) {
        this.printHeader();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.m_Streams.get(i2).println(x);
        }
        this.flush();
    }

    @Override
    public void println(char[] x) {
        this.printHeader();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.m_Streams.get(i2).println(x);
        }
        this.flush();
    }

    @Override
    public void println(String x) {
        this.printHeader();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.m_Streams.get(i2).println(x);
        }
        this.flush();
    }

    @Override
    public void println(Object x) {
        int i2;
        if (x instanceof Throwable) {
            Throwable t = (Throwable)x;
            StackTraceElement[] trace = t.getStackTrace();
            String line = t.toString() + "\n";
            for (i2 = 0; i2 < trace.length; ++i2) {
                line = line + "\t" + trace[i2].toString() + "\n";
            }
            x = line;
        }
        this.printHeader();
        for (i2 = 0; i2 < this.size(); ++i2) {
            this.m_Streams.get(i2).println(x);
        }
        this.flush();
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.printHeader();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.m_Streams.get(i2).write(buf, off, len);
        }
        this.flush();
    }

    @Override
    public void write(int b) {
        this.printHeader();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.m_Streams.get(i2).write(b);
        }
        this.flush();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.m_Streams.size();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 11247 $");
    }
}

