/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.IncrementalConverter;
import weka.core.converters.URLSourcedLoader;

public class ArffLoader
extends AbstractFileLoader
implements BatchConverter,
IncrementalConverter,
URLSourcedLoader {
    static final long serialVersionUID = 2726929550544048587L;
    public static String FILE_EXTENSION = ".arff";
    public static String FILE_EXTENSION_COMPRESSED = FILE_EXTENSION + ".gz";
    protected String m_URL = "http://";
    protected transient Reader m_sourceReader = null;
    protected transient ArffReader m_ArffReader = null;
    protected boolean m_retainStringVals;

    public String globalInfo() {
        return "Reads a source that is in arff (attribute relation file format) format. ";
    }

    public String retainStringValsTipText() {
        return "If true then the values of string attributes are retained in memory when reading incrementally. Leave this set to false when using incremental classifiers in the Knowledge Flow.";
    }

    public void setRetainStringVals(boolean retain) {
        this.m_retainStringVals = retain;
    }

    public boolean getRetainStringVals() {
        return this.m_retainStringVals;
    }

    @Override
    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    @Override
    public String[] getFileExtensions() {
        return new String[]{FILE_EXTENSION, FILE_EXTENSION_COMPRESSED};
    }

    @Override
    public String getFileDescription() {
        return "Arff data files";
    }

    @Override
    public void reset() throws IOException {
        this.m_structure = null;
        this.m_ArffReader = null;
        this.setRetrieval(0);
        if (this.m_File != null && !new File(this.m_File).isDirectory()) {
            this.setFile(new File(this.m_File));
        } else if (this.m_URL != null && !this.m_URL.equals("http://")) {
            this.setURL(this.m_URL);
        }
    }

    public void setSource(URL url) throws IOException {
        this.m_structure = null;
        this.setRetrieval(0);
        this.setSource(url.openStream());
        this.m_URL = url.toString();
        this.m_File = null;
    }

    @Override
    public File retrieveFile() {
        return new File(this.m_File);
    }

    @Override
    public void setFile(File file) throws IOException {
        this.m_File = file.getPath();
        this.setSource(file);
    }

    @Override
    public void setURL(String url) throws IOException {
        this.m_URL = url;
        this.setSource(new URL(url));
    }

    @Override
    public String retrieveURL() {
        return this.m_URL;
    }

    @Override
    public void setSource(InputStream in) throws IOException {
        this.m_File = new File(System.getProperty("user.dir")).getAbsolutePath();
        this.m_URL = "http://";
        this.m_sourceReader = new BufferedReader(new InputStreamReader(in));
    }

    @Override
    public Instances getStructure() throws IOException {
        if (this.m_structure == null) {
            if (this.m_sourceReader == null) {
                throw new IOException("No source has been specified");
            }
            try {
                this.m_ArffReader = new ArffReader(this.m_sourceReader, 1, this.getRetrieval() == 1);
                this.m_ArffReader.setRetainStringValues(this.getRetainStringVals());
                this.m_structure = this.m_ArffReader.getStructure();
            }
            catch (Exception ex) {
                throw new IOException("Unable to determine structure as arff (Reason: " + ex.toString() + ").");
            }
        }
        return new Instances(this.m_structure, 0);
    }

    @Override
    public Instances getDataSet() throws IOException {
        Instances insts = null;
        try {
            Instance inst;
            if (this.m_sourceReader == null) {
                throw new IOException("No source has been specified");
            }
            if (this.getRetrieval() == 2) {
                throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
            }
            this.setRetrieval(1);
            if (this.m_structure == null) {
                this.getStructure();
            }
            insts = new Instances(this.m_structure, 0);
            while ((inst = this.m_ArffReader.readInstance(this.m_structure)) != null) {
                insts.add(inst);
            }
        }
        finally {
            if (this.m_sourceReader != null) {
                this.m_sourceReader.close();
            }
        }
        return insts;
    }

    @Override
    public Instance getNextInstance(Instances structure) throws IOException {
        this.m_structure = structure;
        if (this.getRetrieval() == 1) {
            throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
        }
        this.setRetrieval(2);
        Instance current = null;
        if (this.m_sourceReader != null) {
            current = this.m_ArffReader.readInstance(this.m_structure);
        }
        if (this.m_sourceReader != null && current == null) {
            try {
                this.m_sourceReader.close();
                this.m_sourceReader = null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return current;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 11506 $");
    }

    public static void main(String[] args) {
        ArffLoader.runFileLoader(new ArffLoader(), args);
    }

    public static class ArffReader
    implements RevisionHandler {
        protected StreamTokenizer m_Tokenizer;
        protected double[] m_ValueBuffer;
        protected int[] m_IndicesBuffer;
        protected List<Integer> m_stringAttIndices;
        protected Instances m_Data;
        protected int m_Lines;
        protected boolean m_batchMode = true;
        protected boolean m_retainStringValues = false;
        protected String m_fieldSeparator;
        protected List<String> m_enclosures;

        public ArffReader(Reader reader) throws IOException {
            Instance inst;
            this.m_retainStringValues = true;
            this.m_batchMode = true;
            this.m_Tokenizer = new StreamTokenizer(reader);
            this.initTokenizer();
            this.readHeader(1000);
            this.initBuffers();
            while ((inst = this.readInstance(this.m_Data)) != null) {
                this.m_Data.add(inst);
            }
            this.compactify();
        }

        public ArffReader(Reader reader, int capacity) throws IOException {
            this(reader, capacity, true);
        }

        public ArffReader(Reader reader, int capacity, boolean batch) throws IOException {
            this.m_batchMode = batch;
            if (batch) {
                this.m_retainStringValues = true;
            }
            if (capacity < 0) {
                throw new IllegalArgumentException("Capacity has to be positive!");
            }
            this.m_Tokenizer = new StreamTokenizer(reader);
            this.initTokenizer();
            this.readHeader(capacity);
            this.initBuffers();
        }

        public ArffReader(Reader reader, Instances template, int lines, String ... fieldSepAndEnclosures) throws IOException {
            this(reader, template, lines, 100, true, fieldSepAndEnclosures);
            Instance inst;
            while ((inst = this.readInstance(this.m_Data)) != null) {
                this.m_Data.add(inst);
            }
            this.compactify();
        }

        public ArffReader(Reader reader, Instances template, int lines, int capacity, String ... fieldSepAndEnclosures) throws IOException {
            this(reader, template, lines, capacity, false, fieldSepAndEnclosures);
        }

        public ArffReader(Reader reader, Instances template, int lines, int capacity, boolean batch, String ... fieldSepAndEnclosures) throws IOException {
            this.m_batchMode = batch;
            if (batch) {
                this.m_retainStringValues = true;
            }
            if (fieldSepAndEnclosures != null && fieldSepAndEnclosures.length > 0) {
                if (fieldSepAndEnclosures[0] != null && fieldSepAndEnclosures[0].length() > 0) {
                    this.m_fieldSeparator = fieldSepAndEnclosures[0];
                }
                if (fieldSepAndEnclosures.length > 1) {
                    this.m_enclosures = new ArrayList<String>();
                    for (int i2 = 1; i2 < fieldSepAndEnclosures.length; ++i2) {
                        if (fieldSepAndEnclosures[i2] == null || fieldSepAndEnclosures[i2].length() <= 0) continue;
                        this.m_enclosures.add(fieldSepAndEnclosures[i2]);
                    }
                    if (this.m_enclosures.size() == 0) {
                        this.m_enclosures = null;
                    }
                }
            }
            this.m_Lines = lines;
            this.m_Tokenizer = new StreamTokenizer(reader);
            this.initTokenizer();
            this.m_Data = new Instances(template, capacity);
            this.initBuffers();
        }

        protected void initBuffers() {
            this.m_ValueBuffer = new double[this.m_Data.numAttributes()];
            this.m_IndicesBuffer = new int[this.m_Data.numAttributes()];
            this.m_stringAttIndices = new ArrayList<Integer>();
            if (this.m_Data.checkForStringAttributes()) {
                for (int i2 = 0; i2 < this.m_Data.numAttributes(); ++i2) {
                    if (!this.m_Data.attribute(i2).isString()) continue;
                    this.m_stringAttIndices.add(i2);
                }
            }
        }

        protected void compactify() {
            if (this.m_Data != null) {
                this.m_Data.compactify();
            }
        }

        protected void errorMessage(String msg) throws IOException {
            String str = msg + ", read " + this.m_Tokenizer.toString();
            if (this.m_Lines > 0) {
                int line = Integer.parseInt(str.replaceAll(".* line ", ""));
                str = str.replaceAll(" line .*", " line " + (this.m_Lines + line - 1));
            }
            throw new IOException(str);
        }

        public int getLineNo() {
            return this.m_Lines + this.m_Tokenizer.lineno();
        }

        protected void getFirstToken() throws IOException {
            while (this.m_Tokenizer.nextToken() == 10) {
            }
            if (this.m_Tokenizer.ttype == 39 || this.m_Tokenizer.ttype == 34) {
                this.m_Tokenizer.ttype = -3;
            } else if (this.m_Tokenizer.ttype == -3 && this.m_Tokenizer.sval.equals("?")) {
                this.m_Tokenizer.ttype = 63;
            }
        }

        protected void getIndex() throws IOException {
            if (this.m_Tokenizer.nextToken() == 10) {
                this.errorMessage("premature end of line");
            }
            if (this.m_Tokenizer.ttype == -1) {
                this.errorMessage("premature end of file");
            }
        }

        protected void getLastToken(boolean endOfFileOk) throws IOException {
            if (!(this.m_Tokenizer.nextToken() == 10 || this.m_Tokenizer.ttype == -1 && endOfFileOk)) {
                this.errorMessage("end of line expected");
            }
        }

        protected double getInstanceWeight() throws IOException {
            double weight = Double.NaN;
            this.m_Tokenizer.nextToken();
            if (this.m_Tokenizer.ttype == 10 || this.m_Tokenizer.ttype == -1) {
                return weight;
            }
            if (this.m_Tokenizer.ttype == 123) {
                this.m_Tokenizer.nextToken();
                String weightS = this.m_Tokenizer.sval;
                try {
                    weight = Double.parseDouble(weightS);
                }
                catch (NumberFormatException e) {
                    return weight;
                }
                this.m_Tokenizer.nextToken();
                if (this.m_Tokenizer.ttype != 125) {
                    this.errorMessage("Problem reading instance weight");
                }
            }
            return weight;
        }

        protected void getNextToken() throws IOException {
            if (this.m_Tokenizer.nextToken() == 10) {
                this.errorMessage("premature end of line");
            }
            if (this.m_Tokenizer.ttype == -1) {
                this.errorMessage("premature end of file");
            } else if (this.m_Tokenizer.ttype == 39 || this.m_Tokenizer.ttype == 34) {
                this.m_Tokenizer.ttype = -3;
            } else if (this.m_Tokenizer.ttype == -3 && this.m_Tokenizer.sval.equals("?")) {
                this.m_Tokenizer.ttype = 63;
            }
        }

        protected void initTokenizer() {
            this.m_Tokenizer.resetSyntax();
            this.m_Tokenizer.whitespaceChars(0, 32);
            this.m_Tokenizer.wordChars(33, 255);
            if (this.m_fieldSeparator != null) {
                this.m_Tokenizer.whitespaceChars(this.m_fieldSeparator.charAt(0), this.m_fieldSeparator.charAt(0));
            } else {
                this.m_Tokenizer.whitespaceChars(44, 44);
            }
            this.m_Tokenizer.commentChar(37);
            if (this.m_enclosures != null && this.m_enclosures.size() > 0) {
                for (String e : this.m_enclosures) {
                    this.m_Tokenizer.quoteChar(e.charAt(0));
                }
            } else {
                this.m_Tokenizer.quoteChar(34);
                this.m_Tokenizer.quoteChar(39);
            }
            this.m_Tokenizer.ordinaryChar(123);
            this.m_Tokenizer.ordinaryChar(125);
            this.m_Tokenizer.eolIsSignificant(true);
        }

        public Instance readInstance(Instances structure) throws IOException {
            return this.readInstance(structure, true);
        }

        public Instance readInstance(Instances structure, boolean flag) throws IOException {
            return this.getInstance(structure, flag);
        }

        protected Instance getInstance(Instances structure, boolean flag) throws IOException {
            this.m_Data = structure;
            if (this.m_Data.numAttributes() == 0) {
                this.errorMessage("no header information available");
            }
            this.getFirstToken();
            if (this.m_Tokenizer.ttype == -1) {
                return null;
            }
            if (this.m_Tokenizer.ttype == 123) {
                return this.getInstanceSparse(flag);
            }
            return this.getInstanceFull(flag);
        }

        protected Instance getInstanceSparse(boolean flag) throws IOException {
            int numValues = 0;
            int maxIndex = -1;
            if (!this.m_batchMode && !this.m_retainStringValues && this.m_stringAttIndices != null) {
                for (int i2 = 0; i2 < this.m_stringAttIndices.size(); ++i2) {
                    this.m_Data.attribute(this.m_stringAttIndices.get(i2)).setStringValue(null);
                }
            }
            while (true) {
                this.getIndex();
                if (this.m_Tokenizer.ttype == 125) break;
                try {
                    this.m_IndicesBuffer[numValues] = Integer.valueOf(this.m_Tokenizer.sval);
                }
                catch (NumberFormatException e) {
                    this.errorMessage("index number expected");
                }
                if (this.m_IndicesBuffer[numValues] <= maxIndex) {
                    this.errorMessage("indices have to be ordered");
                }
                if (this.m_IndicesBuffer[numValues] < 0 || this.m_IndicesBuffer[numValues] >= this.m_Data.numAttributes()) {
                    this.errorMessage("index out of bounds");
                }
                maxIndex = this.m_IndicesBuffer[numValues];
                this.getNextToken();
                if (this.m_Tokenizer.ttype == 63) {
                    this.m_ValueBuffer[numValues] = Utils.missingValue();
                } else {
                    if (this.m_Tokenizer.ttype != -3) {
                        this.errorMessage("not a valid value");
                    }
                    switch (this.m_Data.attribute(this.m_IndicesBuffer[numValues]).type()) {
                        case 1: {
                            int valIndex = this.m_Data.attribute(this.m_IndicesBuffer[numValues]).indexOfValue(this.m_Tokenizer.sval);
                            if (valIndex == -1) {
                                this.errorMessage("nominal value not declared in header");
                            }
                            this.m_ValueBuffer[numValues] = valIndex;
                            break;
                        }
                        case 0: {
                            try {
                                this.m_ValueBuffer[numValues] = Double.valueOf(this.m_Tokenizer.sval);
                            }
                            catch (NumberFormatException e) {
                                this.errorMessage("number expected");
                            }
                            break;
                        }
                        case 2: {
                            if (this.m_batchMode || this.m_retainStringValues) {
                                this.m_ValueBuffer[numValues] = this.m_Data.attribute(this.m_IndicesBuffer[numValues]).addStringValue(this.m_Tokenizer.sval);
                                break;
                            }
                            this.m_ValueBuffer[numValues] = 0.0;
                            this.m_Data.attribute(this.m_IndicesBuffer[numValues]).addStringValue(this.m_Tokenizer.sval);
                            break;
                        }
                        case 3: {
                            try {
                                this.m_ValueBuffer[numValues] = this.m_Data.attribute(this.m_IndicesBuffer[numValues]).parseDate(this.m_Tokenizer.sval);
                            }
                            catch (ParseException e) {
                                this.errorMessage("unparseable date: " + this.m_Tokenizer.sval);
                            }
                            break;
                        }
                        case 4: {
                            try {
                                ArffReader arff = new ArffReader((Reader)new StringReader(this.m_Tokenizer.sval), this.m_Data.attribute(this.m_IndicesBuffer[numValues]).relation(), 0, new String[0]);
                                Instances data = arff.getData();
                                this.m_ValueBuffer[numValues] = this.m_Data.attribute(this.m_IndicesBuffer[numValues]).addRelation(data);
                                break;
                            }
                            catch (Exception e) {
                                throw new IOException(e.toString() + " of line " + this.getLineNo());
                            }
                        }
                        default: {
                            this.errorMessage("unknown attribute type in column " + this.m_IndicesBuffer[numValues]);
                        }
                    }
                }
                ++numValues;
            }
            double weight = 1.0;
            if (flag) {
                weight = this.getInstanceWeight();
                if (!Double.isNaN(weight)) {
                    this.getLastToken(true);
                } else {
                    weight = 1.0;
                }
            }
            double[] tempValues = new double[numValues];
            int[] tempIndices = new int[numValues];
            System.arraycopy(this.m_ValueBuffer, 0, tempValues, 0, numValues);
            System.arraycopy(this.m_IndicesBuffer, 0, tempIndices, 0, numValues);
            SparseInstance inst = new SparseInstance(weight, tempValues, tempIndices, this.m_Data.numAttributes());
            inst.setDataset(this.m_Data);
            return inst;
        }

        protected Instance getInstanceFull(boolean flag) throws IOException {
            double[] instance = new double[this.m_Data.numAttributes()];
            block13: for (int i2 = 0; i2 < this.m_Data.numAttributes(); ++i2) {
                if (i2 > 0) {
                    this.getNextToken();
                }
                if (this.m_Tokenizer.ttype == 63) {
                    instance[i2] = Utils.missingValue();
                    continue;
                }
                if (this.m_Tokenizer.ttype != -3) {
                    this.errorMessage("not a valid value");
                }
                switch (this.m_Data.attribute(i2).type()) {
                    case 1: {
                        int index = this.m_Data.attribute(i2).indexOfValue(this.m_Tokenizer.sval);
                        if (index == -1) {
                            this.errorMessage("nominal value not declared in header");
                        }
                        instance[i2] = index;
                        continue block13;
                    }
                    case 0: {
                        try {
                            instance[i2] = Double.valueOf(this.m_Tokenizer.sval);
                        }
                        catch (NumberFormatException e) {
                            this.errorMessage("number expected");
                        }
                        continue block13;
                    }
                    case 2: {
                        if (this.m_batchMode || this.m_retainStringValues) {
                            instance[i2] = this.m_Data.attribute(i2).addStringValue(this.m_Tokenizer.sval);
                            continue block13;
                        }
                        instance[i2] = 0.0;
                        this.m_Data.attribute(i2).setStringValue(this.m_Tokenizer.sval);
                        continue block13;
                    }
                    case 3: {
                        try {
                            instance[i2] = this.m_Data.attribute(i2).parseDate(this.m_Tokenizer.sval);
                        }
                        catch (ParseException e) {
                            this.errorMessage("unparseable date: " + this.m_Tokenizer.sval);
                        }
                        continue block13;
                    }
                    case 4: {
                        try {
                            ArffReader arff = new ArffReader((Reader)new StringReader(this.m_Tokenizer.sval), this.m_Data.attribute(i2).relation(), 0, new String[0]);
                            Instances data = arff.getData();
                            instance[i2] = this.m_Data.attribute(i2).addRelation(data);
                            continue block13;
                        }
                        catch (Exception e) {
                            throw new IOException(e.toString() + " of line " + this.getLineNo());
                        }
                    }
                    default: {
                        this.errorMessage("unknown attribute type in column " + i2);
                    }
                }
            }
            double weight = 1.0;
            if (flag) {
                weight = this.getInstanceWeight();
                if (!Double.isNaN(weight)) {
                    this.getLastToken(true);
                } else {
                    weight = 1.0;
                }
            }
            DenseInstance inst = new DenseInstance(weight, instance);
            inst.setDataset(this.m_Data);
            return inst;
        }

        protected void readHeader(int capacity) throws IOException {
            this.m_Lines = 0;
            String relationName = "";
            this.getFirstToken();
            if (this.m_Tokenizer.ttype == -1) {
                this.errorMessage("premature end of file");
            }
            if ("@relation".equalsIgnoreCase(this.m_Tokenizer.sval)) {
                this.getNextToken();
                relationName = this.m_Tokenizer.sval;
                this.getLastToken(false);
            } else {
                this.errorMessage("keyword @relation expected");
            }
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            this.getFirstToken();
            if (this.m_Tokenizer.ttype == -1) {
                this.errorMessage("premature end of file");
            }
            while ("@attribute".equalsIgnoreCase(this.m_Tokenizer.sval)) {
                attributes = this.parseAttribute(attributes);
            }
            if (!"@data".equalsIgnoreCase(this.m_Tokenizer.sval)) {
                this.errorMessage("keyword @data expected");
            }
            if (attributes.size() == 0) {
                this.errorMessage("no attributes declared");
            }
            this.m_Data = new Instances(relationName, attributes, capacity);
        }

        protected ArrayList<Attribute> parseAttribute(ArrayList<Attribute> attributes) throws IOException {
            this.getNextToken();
            String attributeName = this.m_Tokenizer.sval;
            this.getNextToken();
            if (this.m_Tokenizer.ttype == -3) {
                if (this.m_Tokenizer.sval.equalsIgnoreCase("real") || this.m_Tokenizer.sval.equalsIgnoreCase("integer") || this.m_Tokenizer.sval.equalsIgnoreCase("numeric")) {
                    attributes.add(new Attribute(attributeName, attributes.size()));
                    this.readTillEOL();
                } else if (this.m_Tokenizer.sval.equalsIgnoreCase("string")) {
                    attributes.add(new Attribute(attributeName, (List<String>)null, attributes.size()));
                    this.readTillEOL();
                } else if (this.m_Tokenizer.sval.equalsIgnoreCase("date")) {
                    String format = null;
                    if (this.m_Tokenizer.nextToken() != 10) {
                        if (this.m_Tokenizer.ttype != -3 && this.m_Tokenizer.ttype != 39 && this.m_Tokenizer.ttype != 34) {
                            this.errorMessage("not a valid date format");
                        }
                        format = this.m_Tokenizer.sval;
                        this.readTillEOL();
                    } else {
                        this.m_Tokenizer.pushBack();
                    }
                    attributes.add(new Attribute(attributeName, format, attributes.size()));
                } else if (this.m_Tokenizer.sval.equalsIgnoreCase("relational")) {
                    this.readTillEOL();
                    ArrayList<Attribute> atts = attributes;
                    attributes = new ArrayList();
                    this.getFirstToken();
                    if (this.m_Tokenizer.ttype == -1) {
                        this.errorMessage("premature end of file");
                    }
                    while (true) {
                        if ("@attribute".equalsIgnoreCase(this.m_Tokenizer.sval)) {
                            attributes = this.parseAttribute(attributes);
                            continue;
                        }
                        if ("@end".equalsIgnoreCase(this.m_Tokenizer.sval)) {
                            this.getNextToken();
                            if (attributeName.equalsIgnoreCase(this.m_Tokenizer.sval)) break;
                            this.errorMessage("declaration of subrelation " + attributeName + " must be terminated by @end " + attributeName);
                            break;
                        }
                        this.errorMessage("declaration of subrelation " + attributeName + " must be terminated by @end " + attributeName);
                    }
                    Instances relation = new Instances(attributeName, attributes, 0);
                    attributes = atts;
                    attributes.add(new Attribute(attributeName, relation, attributes.size()));
                } else {
                    this.errorMessage("no valid attribute type or invalid enumeration");
                }
            } else {
                ArrayList<String> attributeValues = new ArrayList<String>();
                this.m_Tokenizer.pushBack();
                if (this.m_Tokenizer.nextToken() != 123) {
                    this.errorMessage("{ expected at beginning of enumeration");
                }
                while (this.m_Tokenizer.nextToken() != 125) {
                    if (this.m_Tokenizer.ttype == 10) {
                        this.errorMessage("} expected at end of enumeration");
                        continue;
                    }
                    attributeValues.add(this.m_Tokenizer.sval);
                }
                attributes.add(new Attribute(attributeName, attributeValues, attributes.size()));
            }
            this.getLastToken(false);
            this.getFirstToken();
            if (this.m_Tokenizer.ttype == -1) {
                this.errorMessage("premature end of file");
            }
            return attributes;
        }

        protected void readTillEOL() throws IOException {
            while (this.m_Tokenizer.nextToken() != 10) {
            }
            this.m_Tokenizer.pushBack();
        }

        public Instances getStructure() {
            return new Instances(this.m_Data, 0);
        }

        public Instances getData() {
            return this.m_Data;
        }

        public void setRetainStringValues(boolean retain) {
            this.m_retainStringValues = retain;
        }

        public boolean getRetainStringValues() {
            return this.m_retainStringValues;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 11506 $");
        }
    }
}

