/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import weka.core.Capabilities;
import weka.core.DictionaryBuilder;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionMetadata;
import weka.core.RevisionUtils;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.BatchConverter;
import weka.core.converters.IncrementalConverter;
import weka.core.stemmers.NullStemmer;
import weka.core.stemmers.Stemmer;
import weka.core.stopwords.Null;
import weka.core.stopwords.StopwordsHandler;
import weka.core.tokenizers.Tokenizer;

public class DictionarySaver
extends AbstractFileSaver
implements BatchConverter,
IncrementalConverter {
    private static final long serialVersionUID = -19891905988830722L;
    protected transient OutputStream m_binaryStream;
    protected DictionaryBuilder m_dictionaryBuilder = new DictionaryBuilder();
    protected boolean m_dictionaryIsBinary;
    private long m_periodicPruningRate;

    public DictionarySaver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Writes a dictionary constructed from string attributes in incoming instances to a destination.";
    }

    @OptionMetadata(displayName="Save dictionary in binary form", description="Save as a binary serialized dictionary", commandLineParamName="binary-dict", commandLineParamSynopsis="-binary-dict", commandLineParamIsFlag=true, displayOrder=2)
    public void setSaveBinaryDictionary(boolean binary) {
        this.m_dictionaryIsBinary = binary;
    }

    public boolean getSaveBinaryDictionary() {
        return this.m_dictionaryIsBinary;
    }

    public String getAttributeIndices() {
        return this.m_dictionaryBuilder.getAttributeIndices();
    }

    @OptionMetadata(displayName="Range of attributes to operate on", description="Specify range of attributes to act on. This is a comma separated list of attribute\nindices, with \"first\" and \"last\" valid values.", commandLineParamName="R", commandLineParamSynopsis="-R <range>", displayOrder=4)
    public void setAttributeIndices(String rangeList) {
        this.m_dictionaryBuilder.setAttributeIndices(rangeList);
    }

    public boolean getInvertSelection() {
        return this.m_dictionaryBuilder.getInvertSelection();
    }

    @OptionMetadata(displayName="Invert selection", description="Set attributes selection mode. If false, only selected attributes in the range will\nbe worked on. If true, only non-selected attributes will be processed", commandLineParamName="V", commandLineParamSynopsis="-V", commandLineParamIsFlag=true, displayOrder=5)
    public void setInvertSelection(boolean invert) {
        this.m_dictionaryBuilder.setInvertSelection(invert);
    }

    public boolean getLowerCaseTokens() {
        return this.m_dictionaryBuilder.getLowerCaseTokens();
    }

    @OptionMetadata(displayName="Lower case tokens", description="Convert all tokens to lowercase when matching against dictionary entries.", commandLineParamName="L", commandLineParamSynopsis="-L", commandLineParamIsFlag=true, displayOrder=10)
    public void setLowerCaseTokens(boolean downCaseTokens) {
        this.m_dictionaryBuilder.setLowerCaseTokens(downCaseTokens);
    }

    @OptionMetadata(displayName="Stemmer to use", description="The stemming algorithm (classname plus parameters) to use.", commandLineParamName="stemmer", commandLineParamSynopsis="-stemmer <spec>", displayOrder=11)
    public void setStemmer(Stemmer value) {
        if (value != null) {
            this.m_dictionaryBuilder.setStemmer(value);
        } else {
            this.m_dictionaryBuilder.setStemmer(new NullStemmer());
        }
    }

    public Stemmer getStemmer() {
        return this.m_dictionaryBuilder.getStemmer();
    }

    @OptionMetadata(displayName="Stop words handler", description="The stopwords handler to use (default = Null)", commandLineParamName="stopwords-handler", commandLineParamSynopsis="-stopwords-handler <spec>", displayOrder=12)
    public void setStopwordsHandler(StopwordsHandler value) {
        if (value != null) {
            this.m_dictionaryBuilder.setStopwordsHandler(value);
        } else {
            this.m_dictionaryBuilder.setStopwordsHandler(new Null());
        }
    }

    public StopwordsHandler getStopwordsHandler() {
        return this.m_dictionaryBuilder.getStopwordsHandler();
    }

    @OptionMetadata(displayName="Tokenizer", description="The tokenizing algorithm (classname plus parameters) to use.\n(default: weka.core.tokenizers.WordTokenizer)", commandLineParamName="tokenizer", commandLineParamSynopsis="-tokenizer <spec>", displayOrder=13)
    public void setTokenizer(Tokenizer value) {
        this.m_dictionaryBuilder.setTokenizer(value);
    }

    public Tokenizer getTokenizer() {
        return this.m_dictionaryBuilder.getTokenizer();
    }

    public long getPeriodicPruning() {
        return this.m_periodicPruningRate;
    }

    @OptionMetadata(displayName="Periodic pruning rate", description="Prune the dictionary every x instances\n(default = 0 - i.e. no periodic pruning)", commandLineParamName="P", commandLineParamSynopsis="-P <integer>", displayOrder=14)
    public void setPeriodicPruning(long newPeriodicPruning) {
        this.m_periodicPruningRate = newPeriodicPruning;
    }

    public int getWordsToKeep() {
        return this.m_dictionaryBuilder.getWordsToKeep();
    }

    @OptionMetadata(displayName="Number of words to attempt to keep", description="The number of words (per class if there is a class attribute assigned) to attempt to keep.", commandLineParamName="W", commandLineParamSynopsis="-W <integer>", displayOrder=15)
    public void setWordsToKeep(int newWordsToKeep) {
        this.m_dictionaryBuilder.setWordsToKeep(newWordsToKeep);
    }

    public int getMinTermFreq() {
        return this.m_dictionaryBuilder.getMinTermFreq();
    }

    @OptionMetadata(displayName="Minimum term frequency", description="The minimum term frequency to use when pruning the dictionary\n(default = 1).", commandLineParamName="M", commandLineParamSynopsis="-M <integer>", displayOrder=16)
    public void setMinTermFreq(int newMinTermFreq) {
        this.m_dictionaryBuilder.setMinTermFreq(newMinTermFreq);
    }

    public boolean getDoNotOperateOnPerClassBasis() {
        return this.m_dictionaryBuilder.getDoNotOperateOnPerClassBasis();
    }

    @OptionMetadata(displayName="Do not operate on a per-class basis", description="If this is set, the maximum number of words and the\nminimum term frequency is not enforced on a per-class\nbasis but based on the documents in all the classes\n(even if a class attribute is set).", commandLineParamName="O", commandLineParamSynopsis="-O", commandLineParamIsFlag=true, displayOrder=17)
    public void setDoNotOperateOnPerClassBasis(boolean newDoNotOperateOnPerClassBasis) {
        this.m_dictionaryBuilder.setDoNotOperateOnPerClassBasis(newDoNotOperateOnPerClassBasis);
    }

    @OptionMetadata(displayName="Sort dictionary", description="Sort the dictionary alphabetically", commandLineParamName="sort", commandLineParamSynopsis="-sort", commandLineParamIsFlag=true, displayOrder=18)
    public void setKeepDictionarySorted(boolean sorted) {
        this.m_dictionaryBuilder.setSortDictionary(sorted);
    }

    public boolean getKeepDictionarySorted() {
        return this.m_dictionaryBuilder.getSortDictionary();
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.STRING_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public String getFileDescription() {
        return "Plain text or binary serialized dictionary files created from text in string attributes";
    }

    @Override
    public void writeIncremental(Instance inst) throws IOException {
        int writeMode = this.getWriteMode();
        Instances structure = this.getInstances();
        if (this.getRetrieval() == 1 || this.getRetrieval() == 0) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        if (writeMode == 1) {
            if (structure == null) {
                this.setWriteMode(2);
                if (inst != null) {
                    throw new IOException("Structure (header Information) has to be set in advance");
                }
            } else {
                this.setWriteMode(3);
            }
            writeMode = this.getWriteMode();
        }
        if (writeMode == 2) {
            this.cancel();
        }
        if (writeMode == 3) {
            this.m_dictionaryBuilder.reset();
            try {
                this.m_dictionaryBuilder.setup(structure);
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
            this.setWriteMode(0);
            writeMode = this.getWriteMode();
        }
        if (writeMode == 0) {
            if (structure == null) {
                throw new IOException("No instances information available.");
            }
            if (inst != null) {
                this.m_dictionaryBuilder.processInstance(inst);
            } else {
                try {
                    this.m_dictionaryBuilder.finalizeDictionary();
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                if (this.retrieveFile() == null && this.getWriter() == null) {
                    if (this.getSaveBinaryDictionary()) {
                        throw new IOException("Can't output binary dictionary to standard out!");
                    }
                    this.m_dictionaryBuilder.saveDictionary(System.out);
                } else if (this.getSaveBinaryDictionary()) {
                    this.m_dictionaryBuilder.saveDictionary(this.m_binaryStream);
                } else {
                    this.m_dictionaryBuilder.saveDictionary(this.getWriter());
                }
                this.resetStructure();
                this.resetWriter();
            }
        }
    }

    @Override
    public void writeBatch() throws IOException {
        if (this.getInstances() == null) {
            throw new IOException("No instances to save");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(1);
        this.setWriteMode(0);
        this.m_dictionaryBuilder.reset();
        try {
            this.m_dictionaryBuilder.setup(this.getInstances());
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        for (int i2 = 0; i2 < this.getInstances().numInstances(); ++i2) {
            this.m_dictionaryBuilder.processInstance(this.getInstances().instance(i2));
        }
        try {
            this.m_dictionaryBuilder.finalizeDictionary();
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        if (this.retrieveFile() == null && this.getWriter() == null) {
            if (this.getSaveBinaryDictionary()) {
                throw new IOException("Can't output binary dictionary to standard out!");
            }
            this.m_dictionaryBuilder.saveDictionary(System.out);
            this.setWriteMode(1);
            return;
        }
        if (this.getSaveBinaryDictionary()) {
            this.m_dictionaryBuilder.saveDictionary(this.m_binaryStream);
        } else {
            this.m_dictionaryBuilder.saveDictionary(this.getWriter());
        }
        this.setWriteMode(1);
        this.resetWriter();
        this.setWriteMode(2);
    }

    @Override
    public void resetOptions() {
        super.resetOptions();
        this.setFileExtension(".dict");
    }

    @Override
    public void resetWriter() {
        super.resetWriter();
        this.m_binaryStream = null;
    }

    @Override
    public void setDestination(OutputStream output) throws IOException {
        super.setDestination(output);
        this.m_binaryStream = new BufferedOutputStream(output);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 12690 $");
    }

    public static void main(String[] args) {
        DictionarySaver.runFileSaver(new DictionarySaver(), args);
    }
}

