/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.URLSourcedLoader;

public class MatlabLoader
extends AbstractFileLoader
implements BatchConverter,
URLSourcedLoader {
    private static final long serialVersionUID = -8861142318612875251L;
    public static String FILE_EXTENSION = ".m";
    protected String m_URL = "http://";
    protected transient Reader m_sourceReader = null;
    protected Vector<Vector<Double>> m_Buffer = null;

    public String globalInfo() {
        return "Reads a Matlab file containing a single matrix in ASCII format.";
    }

    @Override
    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    @Override
    public String[] getFileExtensions() {
        return new String[]{this.getFileExtension()};
    }

    @Override
    public String getFileDescription() {
        return "Matlab ASCII files";
    }

    @Override
    public void reset() throws IOException {
        this.m_structure = null;
        this.m_Buffer = null;
        this.setRetrieval(0);
        if (this.m_File != null && new File(this.m_File).isFile()) {
            this.setFile(new File(this.m_File));
        } else if (this.m_URL != null && !this.m_URL.equals("http://")) {
            this.setURL(this.m_URL);
        }
    }

    public void setSource(URL url) throws IOException {
        this.m_structure = null;
        this.m_Buffer = null;
        this.setRetrieval(0);
        this.setSource(url.openStream());
        this.m_URL = url.toString();
    }

    @Override
    public void setURL(String url) throws IOException {
        this.m_URL = url;
        this.setSource(new URL(url));
    }

    @Override
    public String retrieveURL() {
        return this.m_URL;
    }

    @Override
    public void setSource(InputStream in) throws IOException {
        this.m_File = new File(System.getProperty("user.dir")).getAbsolutePath();
        this.m_URL = "http://";
        this.m_sourceReader = new BufferedReader(new InputStreamReader(in));
    }

    @Override
    public Instances getStructure() throws IOException {
        if (this.m_sourceReader == null) {
            throw new IOException("No source has been specified");
        }
        if (this.m_structure == null) {
            int numAtt = 0;
            this.m_Buffer = new Vector();
            Vector<Double> row = new Vector<Double>();
            StringBuffer str = new StringBuffer();
            boolean isComment = false;
            this.m_Buffer.add(row);
            try {
                int c;
                while ((c = this.m_sourceReader.read()) != -1) {
                    char chr = (char)c;
                    if (chr == '%') {
                        isComment = true;
                    }
                    if (chr == '\n' || chr == '\r') {
                        isComment = false;
                        if (str.length() > 0) {
                            row.add(new Double(str.toString()));
                        }
                        if (numAtt == 0) {
                            numAtt = row.size();
                        }
                        if (row.size() > 0) {
                            row = new Vector();
                            this.m_Buffer.add(row);
                        }
                        str = new StringBuffer();
                        continue;
                    }
                    if (isComment) continue;
                    if (chr == '\t' || chr == ' ') {
                        if (str.length() <= 0) continue;
                        row.add(new Double(str.toString()));
                        str = new StringBuffer();
                        continue;
                    }
                    str.append(chr);
                }
                if (str.length() > 0) {
                    row.add(new Double(str.toString()));
                }
                ArrayList<Attribute> atts = new ArrayList<Attribute>(numAtt);
                for (int i2 = 0; i2 < numAtt; ++i2) {
                    atts.add(new Attribute("att_" + (i2 + 1)));
                }
                String relName = !this.m_URL.equals("http://") ? this.m_URL : this.m_File;
                this.m_structure = new Instances(relName, atts, 0);
                this.m_structure.setClassIndex(this.m_structure.numAttributes() - 1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IOException("Unable to determine structure as Matlab ASCII file: " + ex);
            }
        }
        return new Instances(this.m_structure, 0);
    }

    @Override
    public Instances getDataSet() throws IOException {
        if (this.m_sourceReader == null) {
            throw new IOException("No source has been specified");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
        }
        this.setRetrieval(1);
        if (this.m_structure == null) {
            this.getStructure();
        }
        Instances result = new Instances(this.m_structure, 0);
        for (int i2 = 0; i2 < this.m_Buffer.size(); ++i2) {
            Vector<Double> row = this.m_Buffer.get(i2);
            if (row.size() == 0) continue;
            double[] data = new double[row.size()];
            for (int n = 0; n < row.size(); ++n) {
                data[n] = row.get(n);
            }
            result.add(new DenseInstance(1.0, data));
        }
        try {
            this.m_sourceReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Instance getNextInstance(Instances structure) throws IOException {
        throw new IOException("MatlabLoader can't read data sets incrementally.");
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        MatlabLoader.runFileLoader(new MatlabLoader(), args);
    }
}

