/*
 * Decompiled with CFR 0.152.
 */
package weka.core.matrix;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class ExponentialFormat
extends DecimalFormat
implements RevisionHandler {
    private static final long serialVersionUID = -5298981701073897741L;
    protected DecimalFormat nf;
    protected boolean sign;
    protected int digits;
    protected int exp;
    protected boolean trailing = true;

    public ExponentialFormat() {
        this(5);
    }

    public ExponentialFormat(int digits) {
        this(digits, false);
    }

    public ExponentialFormat(int digits, boolean trailing) {
        this(digits, 2, true, trailing);
    }

    public ExponentialFormat(int digits, int exp, boolean sign, boolean trailing) {
        this.digits = digits;
        this.exp = exp;
        this.sign = sign;
        this.trailing = trailing;
        this.nf = new DecimalFormat(this.pattern());
        this.nf.setPositivePrefix("+");
        this.nf.setNegativePrefix("-");
    }

    public int width() {
        if (!this.trailing) {
            throw new RuntimeException("flexible width");
        }
        if (this.sign) {
            return 1 + this.digits + 2 + this.exp;
        }
        return this.digits + 2 + this.exp;
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        StringBuffer s = new StringBuffer(this.nf.format(number));
        if (this.sign) {
            if (s.charAt(0) == '+') {
                s.setCharAt(0, ' ');
            }
        } else if (s.charAt(0) == '-') {
            s.setCharAt(0, '*');
        } else {
            s.deleteCharAt(0);
        }
        return toAppendTo.append(s);
    }

    private String pattern() {
        int i2;
        StringBuffer s = new StringBuffer();
        s.append("0.");
        for (i2 = 0; i2 < this.digits - 1; ++i2) {
            if (this.trailing) {
                s.append('0');
                continue;
            }
            s.append('#');
        }
        s.append('E');
        for (i2 = 0; i2 < this.exp; ++i2) {
            s.append('0');
        }
        return s.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

