/*
 * Decompiled with CFR 0.152.
 */
package weka.core.matrix;

import java.util.Arrays;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.matrix.FlexibleDecimalFormat;

public class IntVector
implements Cloneable,
RevisionHandler {
    int[] V;
    private int sizeOfVector;

    public IntVector() {
        this.V = new int[0];
        this.setSize(0);
    }

    public IntVector(int n) {
        this.V = new int[n];
        this.setSize(n);
    }

    public IntVector(int n, int s) {
        this(n);
        this.set(s);
    }

    public IntVector(int[] v) {
        if (v == null) {
            this.V = new int[0];
            this.setSize(0);
        } else {
            this.V = new int[v.length];
            this.setSize(v.length);
            this.set(0, this.size() - 1, v, 0);
        }
    }

    public int size() {
        return this.sizeOfVector;
    }

    public void setSize(int size) {
        if (size > this.capacity()) {
            throw new IllegalArgumentException("insufficient capacity");
        }
        this.sizeOfVector = size;
    }

    public void set(int s) {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.set(i2, s);
        }
    }

    public void set(int i0, int i1, int[] v, int j0) {
        for (int i2 = i0; i2 <= i1; ++i2) {
            this.set(i2, v[j0 + i2 - i0]);
        }
    }

    public void set(int i0, int i1, IntVector v, int j0) {
        for (int i2 = i0; i2 <= i1; ++i2) {
            this.set(i2, v.get(j0 + i2 - i0));
        }
    }

    public void set(IntVector v) {
        this.set(0, v.size() - 1, v, 0);
    }

    public static IntVector seq(int i0, int i1) {
        if (i1 < i0) {
            throw new IllegalArgumentException("i1 < i0 ");
        }
        IntVector v = new IntVector(i1 - i0 + 1);
        for (int i2 = 0; i2 < i1 - i0 + 1; ++i2) {
            v.set(i2, i2 + i0);
        }
        return v;
    }

    public int[] getArray() {
        return this.V;
    }

    protected void setArray(int[] a) {
        this.V = a;
    }

    public void sort() {
        Arrays.sort(this.V, 0, this.size());
    }

    public int[] getArrayCopy() {
        int[] b = new int[this.size()];
        for (int i2 = 0; i2 <= this.size() - 1; ++i2) {
            b[i2] = this.V[i2];
        }
        return b;
    }

    public int capacity() {
        return this.V.length;
    }

    public void setCapacity(int capacity) {
        if (capacity == this.capacity()) {
            return;
        }
        int[] old_V = this.V;
        int m = Math.min(capacity, this.size());
        this.V = new int[capacity];
        this.setSize(capacity);
        this.set(0, m - 1, old_V, 0);
    }

    public void set(int i2, int s) {
        this.V[i2] = s;
    }

    public int get(int i2) {
        return this.V[i2];
    }

    public IntVector copy() {
        return (IntVector)this.clone();
    }

    public Object clone() {
        IntVector u = new IntVector(this.size());
        for (int i2 = 0; i2 < this.size(); ++i2) {
            u.V[i2] = this.V[i2];
        }
        return u;
    }

    public IntVector subvector(int i0, int i1) {
        IntVector v = new IntVector(i1 - i0 + 1);
        v.set(0, i1 - i0, this, i0);
        return v;
    }

    public IntVector subvector(IntVector index) {
        IntVector v = new IntVector(index.size());
        for (int i2 = 0; i2 < index.size(); ++i2) {
            v.V[i2] = this.V[index.V[i2]];
        }
        return v;
    }

    public void swap(int i2, int j) {
        if (i2 == j) {
            return;
        }
        int t = this.get(i2);
        this.set(i2, this.get(j));
        this.set(j, t);
    }

    public void shift(int i2, int j) {
        if (i2 == j) {
            return;
        }
        if (i2 < j) {
            int t = this.V[i2];
            for (int k = i2; k <= j - 1; ++k) {
                this.V[k] = this.V[k + 1];
            }
            this.V[j] = t;
        } else {
            this.shift(j, i2);
        }
    }

    public void shiftToEnd(int j) {
        this.shift(j, this.size() - 1);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        return this.toString(5, false);
    }

    public String toString(int digits, boolean trailing) {
        if (this.isEmpty()) {
            return "null vector";
        }
        StringBuffer text = new StringBuffer();
        FlexibleDecimalFormat nf = new FlexibleDecimalFormat(digits, trailing);
        nf.grouping(true);
        for (int i2 = 0; i2 < this.size(); ++i2) {
            nf.update(this.get(i2));
        }
        int count = 0;
        int width = 80;
        for (int i3 = 0; i3 < this.size(); ++i3) {
            String number = nf.format(this.get(i3));
            if ((count += 1 + number.length()) > width - 1) {
                text.append('\n');
                count = 1 + number.length();
            }
            text.append(" " + number);
        }
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        IntVector u = new IntVector();
        System.out.println(u);
        IntVector v = IntVector.seq(10, 25);
        System.out.println(v);
        IntVector w = IntVector.seq(25, 10);
        System.out.println(w);
    }
}

