/*
 * Decompiled with CFR 0.152.
 */
package weka.core.matrix;

import java.io.Serializable;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.matrix.Matrix;

public class LUDecomposition
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -2731022568037808629L;
    private double[][] LU;
    private int m;
    private int n;
    private int pivsign;
    private int[] piv;

    public LUDecomposition(Matrix A) {
        this.LU = A.getArrayCopy();
        this.m = A.getRowDimension();
        this.n = A.getColumnDimension();
        this.piv = new int[this.m];
        for (int i2 = 0; i2 < this.m; ++i2) {
            this.piv[i2] = i2;
        }
        this.pivsign = 1;
        double[] LUcolj = new double[this.m];
        for (int j = 0; j < this.n; ++j) {
            int i3;
            int i4;
            for (i4 = 0; i4 < this.m; ++i4) {
                LUcolj[i4] = this.LU[i4][j];
            }
            i4 = 0;
            while (i4 < this.m) {
                double[] LUrowi = this.LU[i4];
                int kmax = Math.min(i4, j);
                double s = 0.0;
                for (int k = 0; k < kmax; ++k) {
                    s += LUrowi[k] * LUcolj[k];
                }
                int n = i4++;
                double d = LUcolj[n] - s;
                LUcolj[n] = d;
                LUrowi[j] = d;
            }
            int p = j;
            for (i3 = j + 1; i3 < this.m; ++i3) {
                if (!(Math.abs(LUcolj[i3]) > Math.abs(LUcolj[p]))) continue;
                p = i3;
            }
            if (p != j) {
                int k;
                for (k = 0; k < this.n; ++k) {
                    double t = this.LU[p][k];
                    this.LU[p][k] = this.LU[j][k];
                    this.LU[j][k] = t;
                }
                k = this.piv[p];
                this.piv[p] = this.piv[j];
                this.piv[j] = k;
                this.pivsign = -this.pivsign;
            }
            if (!(j < this.m & this.LU[j][j] != 0.0)) continue;
            for (i3 = j + 1; i3 < this.m; ++i3) {
                double[] dArray = this.LU[i3];
                int n = j;
                dArray[n] = dArray[n] / this.LU[j][j];
            }
        }
    }

    public boolean isNonsingular() {
        for (int j = 0; j < this.n; ++j) {
            if (this.LU[j][j] != 0.0) continue;
            return false;
        }
        return true;
    }

    public Matrix getL() {
        Matrix X = new Matrix(this.m, this.n);
        double[][] L = X.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                L[i2][j] = i2 > j ? this.LU[i2][j] : (i2 == j ? 1.0 : 0.0);
            }
        }
        return X;
    }

    public Matrix getU() {
        Matrix X = new Matrix(this.n, this.n);
        double[][] U = X.getArray();
        for (int i2 = 0; i2 < this.n; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                U[i2][j] = i2 <= j ? this.LU[i2][j] : 0.0;
            }
        }
        return X;
    }

    public int[] getPivot() {
        int[] p = new int[this.m];
        for (int i2 = 0; i2 < this.m; ++i2) {
            p[i2] = this.piv[i2];
        }
        return p;
    }

    public double[] getDoublePivot() {
        double[] vals = new double[this.m];
        for (int i2 = 0; i2 < this.m; ++i2) {
            vals[i2] = this.piv[i2];
        }
        return vals;
    }

    public double det() {
        if (this.m != this.n) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        double d = this.pivsign;
        for (int j = 0; j < this.n; ++j) {
            d *= this.LU[j][j];
        }
        return d;
    }

    public Matrix solve(Matrix B) {
        int j;
        int i2;
        int k;
        if (B.getRowDimension() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        int nx = B.getColumnDimension();
        Matrix Xmat = B.getMatrix(this.piv, 0, nx - 1);
        double[][] X = Xmat.getArray();
        for (k = 0; k < this.n; ++k) {
            for (i2 = k + 1; i2 < this.n; ++i2) {
                for (j = 0; j < nx; ++j) {
                    double[] dArray = X[i2];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * this.LU[i2][k];
                }
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            int j2 = 0;
            while (j2 < nx) {
                double[] dArray = X[k];
                int n = j2++;
                dArray[n] = dArray[n] / this.LU[k][k];
            }
            for (i2 = 0; i2 < k; ++i2) {
                for (j = 0; j < nx; ++j) {
                    double[] dArray = X[i2];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * this.LU[i2][k];
                }
            }
        }
        return Xmat;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5953 $");
    }
}

