/*
 * Decompiled with CFR 0.152.
 */
package weka.core.matrix;

import java.util.Random;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Statistics;
import weka.core.matrix.DoubleVector;

public class Maths
implements RevisionHandler {
    public static final double PSI = 0.3989422804014327;
    public static final double logPSI = -0.9189385332046727;
    public static final int undefinedDistribution = 0;
    public static final int normalDistribution = 1;
    public static final int chisqDistribution = 2;

    public static double hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }

    public static double square(double x) {
        return x * x;
    }

    public static double pnorm(double x) {
        return Statistics.normalProbability(x);
    }

    public static double pnorm(double x, double mean, double sd) {
        if (sd <= 0.0) {
            throw new IllegalArgumentException("standard deviation <= 0.0");
        }
        return Maths.pnorm((x - mean) / sd);
    }

    public static DoubleVector pnorm(double x, DoubleVector mean, double sd) {
        DoubleVector p = new DoubleVector(mean.size());
        for (int i2 = 0; i2 < mean.size(); ++i2) {
            p.set(i2, Maths.pnorm(x, mean.get(i2), sd));
        }
        return p;
    }

    public static double dnorm(double x) {
        return Math.exp(-x * x / 2.0) * 0.3989422804014327;
    }

    public static double dnorm(double x, double mean, double sd) {
        if (sd <= 0.0) {
            throw new IllegalArgumentException("standard deviation <= 0.0");
        }
        return Maths.dnorm((x - mean) / sd);
    }

    public static DoubleVector dnorm(double x, DoubleVector mean, double sd) {
        DoubleVector den = new DoubleVector(mean.size());
        for (int i2 = 0; i2 < mean.size(); ++i2) {
            den.set(i2, Maths.dnorm(x, mean.get(i2), sd));
        }
        return den;
    }

    public static double dnormLog(double x) {
        return -0.9189385332046727 - x * x / 2.0;
    }

    public static double dnormLog(double x, double mean, double sd) {
        if (sd <= 0.0) {
            throw new IllegalArgumentException("standard deviation <= 0.0");
        }
        return -Math.log(sd) + Maths.dnormLog((x - mean) / sd);
    }

    public static DoubleVector dnormLog(double x, DoubleVector mean, double sd) {
        DoubleVector denLog = new DoubleVector(mean.size());
        for (int i2 = 0; i2 < mean.size(); ++i2) {
            denLog.set(i2, Maths.dnormLog(x, mean.get(i2), sd));
        }
        return denLog;
    }

    public static DoubleVector rnorm(int n, double mean, double sd, Random random) {
        if (sd < 0.0) {
            throw new IllegalArgumentException("standard deviation < 0.0");
        }
        if (sd == 0.0) {
            return new DoubleVector(n, mean);
        }
        DoubleVector v = new DoubleVector(n);
        for (int i2 = 0; i2 < n; ++i2) {
            v.set(i2, (random.nextGaussian() + mean) / sd);
        }
        return v;
    }

    public static double pchisq(double x) {
        double xh = Math.sqrt(x);
        return Maths.pnorm(xh) - Maths.pnorm(-xh);
    }

    public static double pchisq(double x, double ncp) {
        double mean = Math.sqrt(ncp);
        double xh = Math.sqrt(x);
        return Maths.pnorm(xh - mean) - Maths.pnorm(-xh - mean);
    }

    public static DoubleVector pchisq(double x, DoubleVector ncp) {
        int n = ncp.size();
        DoubleVector p = new DoubleVector(n);
        double xh = Math.sqrt(x);
        for (int i2 = 0; i2 < n; ++i2) {
            double mean = Math.sqrt(ncp.get(i2));
            p.set(i2, Maths.pnorm(xh - mean) - Maths.pnorm(-xh - mean));
        }
        return p;
    }

    public static double dchisq(double x) {
        if (x == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double xh = Math.sqrt(x);
        return Maths.dnorm(xh) / xh;
    }

    public static double dchisq(double x, double ncp) {
        if (ncp == 0.0) {
            return Maths.dchisq(x);
        }
        double xh = Math.sqrt(x);
        double mean = Math.sqrt(ncp);
        return (Maths.dnorm(xh - mean) + Maths.dnorm(-xh - mean)) / (2.0 * xh);
    }

    public static DoubleVector dchisq(double x, DoubleVector ncp) {
        int n = ncp.size();
        DoubleVector d = new DoubleVector(n);
        double xh = Math.sqrt(x);
        for (int i2 = 0; i2 < n; ++i2) {
            double mean = Math.sqrt(ncp.get(i2));
            if (ncp.get(i2) == 0.0) {
                d.set(i2, Maths.dchisq(x));
                continue;
            }
            d.set(i2, (Maths.dnorm(xh - mean) + Maths.dnorm(-xh - mean)) / (2.0 * xh));
        }
        return d;
    }

    public static double dchisqLog(double x) {
        if (x == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double xh = Math.sqrt(x);
        return Maths.dnormLog(xh) - Math.log(xh);
    }

    public static double dchisqLog(double x, double ncp) {
        if (ncp == 0.0) {
            return Maths.dchisqLog(x);
        }
        double xh = Math.sqrt(x);
        double mean = Math.sqrt(ncp);
        return Math.log(Maths.dnorm(xh - mean) + Maths.dnorm(-xh - mean)) - Math.log(2.0 * xh);
    }

    public static DoubleVector dchisqLog(double x, DoubleVector ncp) {
        DoubleVector dLog = new DoubleVector(ncp.size());
        double xh = Math.sqrt(x);
        for (int i2 = 0; i2 < ncp.size(); ++i2) {
            double mean = Math.sqrt(ncp.get(i2));
            if (ncp.get(i2) == 0.0) {
                dLog.set(i2, Maths.dchisqLog(x));
                continue;
            }
            dLog.set(i2, Math.log(Maths.dnorm(xh - mean) + Maths.dnorm(-xh - mean)) - Math.log(2.0 * xh));
        }
        return dLog;
    }

    public static DoubleVector rchisq(int n, double ncp, Random random) {
        DoubleVector v = new DoubleVector(n);
        double mean = Math.sqrt(ncp);
        for (int i2 = 0; i2 < n; ++i2) {
            double x = random.nextGaussian() + mean;
            v.set(i2, x * x);
        }
        return v;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5953 $");
    }
}

