/*
 * Decompiled with CFR 0.152.
 */
package weka.core.matrix;

import java.io.Serializable;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.matrix.Maths;
import weka.core.matrix.Matrix;

public class QRDecomposition
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -5013090736132211418L;
    private double[][] QR;
    private int m;
    private int n;
    private double[] Rdiag;

    public QRDecomposition(Matrix A) {
        this.QR = A.getArrayCopy();
        this.m = A.getRowDimension();
        this.n = A.getColumnDimension();
        this.Rdiag = new double[this.n];
        for (int k = 0; k < this.n; ++k) {
            int i2;
            double nrm = 0.0;
            for (i2 = k; i2 < this.m; ++i2) {
                nrm = Maths.hypot(nrm, this.QR[i2][k]);
            }
            if (nrm != 0.0) {
                if (this.QR[k][k] < 0.0) {
                    nrm = -nrm;
                }
                for (i2 = k; i2 < this.m; ++i2) {
                    double[] dArray = this.QR[i2];
                    int n = k;
                    dArray[n] = dArray[n] / nrm;
                }
                double[] dArray = this.QR[k];
                int n = k;
                dArray[n] = dArray[n] + 1.0;
                for (int j = k + 1; j < this.n; ++j) {
                    int i3;
                    double s = 0.0;
                    for (i3 = k; i3 < this.m; ++i3) {
                        s += this.QR[i3][k] * this.QR[i3][j];
                    }
                    s = -s / this.QR[k][k];
                    for (i3 = k; i3 < this.m; ++i3) {
                        double[] dArray2 = this.QR[i3];
                        int n2 = j;
                        dArray2[n2] = dArray2[n2] + s * this.QR[i3][k];
                    }
                }
            }
            this.Rdiag[k] = -nrm;
        }
    }

    public boolean isFullRank() {
        for (int j = 0; j < this.n; ++j) {
            if (this.Rdiag[j] != 0.0) continue;
            return false;
        }
        return true;
    }

    public Matrix getH() {
        Matrix X = new Matrix(this.m, this.n);
        double[][] H = X.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                H[i2][j] = i2 >= j ? this.QR[i2][j] : 0.0;
            }
        }
        return X;
    }

    public Matrix getR() {
        Matrix X = new Matrix(this.n, this.n);
        double[][] R = X.getArray();
        for (int i2 = 0; i2 < this.n; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                R[i2][j] = i2 < j ? this.QR[i2][j] : (i2 == j ? this.Rdiag[i2] : 0.0);
            }
        }
        return X;
    }

    public Matrix getQ() {
        Matrix X = new Matrix(this.m, this.n);
        double[][] Q = X.getArray();
        for (int k = this.n - 1; k >= 0; --k) {
            for (int i2 = 0; i2 < this.m; ++i2) {
                Q[i2][k] = 0.0;
            }
            Q[k][k] = 1.0;
            for (int j = k; j < this.n; ++j) {
                int i3;
                if (this.QR[k][k] == 0.0) continue;
                double s = 0.0;
                for (i3 = k; i3 < this.m; ++i3) {
                    s += this.QR[i3][k] * Q[i3][j];
                }
                s = -s / this.QR[k][k];
                for (i3 = k; i3 < this.m; ++i3) {
                    double[] dArray = Q[i3];
                    int n = j;
                    dArray[n] = dArray[n] + s * this.QR[i3][k];
                }
            }
        }
        return X;
    }

    public Matrix solve(Matrix B) {
        int j;
        int k;
        if (B.getRowDimension() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isFullRank()) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        int nx = B.getColumnDimension();
        double[][] X = B.getArrayCopy();
        for (k = 0; k < this.n; ++k) {
            for (j = 0; j < nx; ++j) {
                int i2;
                double s = 0.0;
                for (i2 = k; i2 < this.m; ++i2) {
                    s += this.QR[i2][k] * X[i2][j];
                }
                s = -s / this.QR[k][k];
                for (i2 = k; i2 < this.m; ++i2) {
                    double[] dArray = X[i2];
                    int n = j;
                    dArray[n] = dArray[n] + s * this.QR[i2][k];
                }
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            j = 0;
            while (j < nx) {
                double[] dArray = X[k];
                int n = j++;
                dArray[n] = dArray[n] / this.Rdiag[k];
            }
            for (int i3 = 0; i3 < k; ++i3) {
                for (int j2 = 0; j2 < nx; ++j2) {
                    double[] dArray = X[i3];
                    int n = j2;
                    dArray[n] = dArray[n] - X[k][j2] * this.QR[i3][k];
                }
            }
        }
        return new Matrix(X, this.n, nx).getMatrix(0, this.n - 1, 0, nx - 1);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5953 $");
    }
}

