/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import weka.core.pmml.SparseArray;

public class Array
implements Serializable {
    private static final long serialVersionUID = 4286234448957826177L;
    protected ArrayList<String> m_values = new ArrayList();
    protected ArrayType m_type = ArrayType.NUM;

    public static boolean isArray(Element arrayE) {
        String name = arrayE.getTagName();
        return name.equals("Array") || name.equals("NUM-ARRAY") || name.equals("INT-ARRAY") || name.equals("REAL-ARRAY") || name.equals("STRING-ARRAY") || Array.isSparseArray(arrayE);
    }

    private static boolean isSparseArray(Element arrayE) {
        String name = arrayE.getTagName();
        return name.equals("INT-SparseArray") || name.equals("REAL-SparseArray");
    }

    public static Array create(List<Object> values, List<Integer> indices) throws Exception {
        ArrayType type = null;
        Object first = values.get(0);
        if (first instanceof Double || first instanceof Float) {
            type = ArrayType.REAL;
        } else if (first instanceof Integer || first instanceof Long) {
            type = ArrayType.INT;
        } else if (first instanceof String) {
            type = ArrayType.STRING;
        } else {
            throw new Exception("[Array] unsupport type!");
        }
        if (indices != null) {
            if (indices.size() != values.size()) {
                throw new Exception("[Array] num values is not equal to num indices!!");
            }
            if (type == ArrayType.REAL) {
                type = ArrayType.REAL_SPARSE;
            } else if (type == ArrayType.INT) {
                type = ArrayType.INT_SPARSE;
            } else {
                throw new Exception("[Array] sparse arrays can only be integer, long, float or double!");
            }
            return new SparseArray(type, values, indices);
        }
        return new Array(type, values);
    }

    public static Array create(Element arrayE) throws Exception {
        if (!Array.isArray(arrayE)) {
            throw new Exception("[Array] the supplied element does not contain an array!");
        }
        if (Array.isSparseArray(arrayE)) {
            return new SparseArray(arrayE);
        }
        return new Array(arrayE);
    }

    protected void initialize(Element arrayE) throws Exception {
        block4: {
            String arrayS;
            block2: {
                String type;
                block5: {
                    block3: {
                        arrayS = arrayE.getTagName();
                        if (!arrayS.equals("Array")) break block2;
                        type = arrayE.getAttribute("type");
                        if (!type.equals("int")) break block3;
                        this.m_type = ArrayType.INT;
                        break block4;
                    }
                    if (!type.equals("real")) break block5;
                    this.m_type = ArrayType.REAL;
                    break block4;
                }
                if (!type.equals("string")) break block4;
                this.m_type = ArrayType.STRING;
                break block4;
            }
            for (ArrayType a : ArrayType.values()) {
                if (!a.toString().equals(arrayS)) continue;
                this.m_type = a;
                break;
            }
        }
        String contents = arrayE.getChildNodes().item(0).getNodeValue();
        StringReader sr = new StringReader(contents);
        StreamTokenizer st = new StreamTokenizer(sr);
        st.resetSyntax();
        st.whitespaceChars(0, 32);
        st.wordChars(33, 255);
        st.whitespaceChars(32, 32);
        st.quoteChar(34);
        st.quoteChar(39);
        st.nextToken();
        while (st.ttype != -1 && st.ttype != 10) {
            this.m_values.add(st.sval);
            st.nextToken();
        }
    }

    protected Array(Element arrayE) throws Exception {
        this.initialize(arrayE);
    }

    protected Array(ArrayType type, List<Object> values) {
        this.m_values = new ArrayList();
        this.m_type = type;
        for (Object o : values) {
            this.m_values.add(o.toString());
        }
    }

    public ArrayType getType() {
        return this.m_type;
    }

    public boolean isSparse() {
        return false;
    }

    public int numValues() {
        return this.m_values.size();
    }

    public boolean contains(String value) {
        return this.m_values.contains(value);
    }

    public boolean contains(int value) {
        return this.contains(new Integer(value).toString());
    }

    public boolean contains(double value) {
        return this.contains(new Double(value).toString());
    }

    public boolean contains(float value) {
        return this.contains(new Float(value).toString());
    }

    private void checkInRange(int index) throws Exception {
        if (index >= this.m_values.size() || index < 0) {
            throw new IllegalArgumentException("[Array] index out of range " + index);
        }
    }

    public int index(int position) {
        return position;
    }

    public String value(int index) throws Exception {
        return this.actualValue(index);
    }

    protected String actualValue(int index) throws Exception {
        this.checkInRange(index);
        return this.m_values.get(index);
    }

    public String valueString(int index) throws Exception {
        return this.value(index);
    }

    public double valueDouble(int index) throws Exception {
        if (this.m_type == ArrayType.STRING) {
            throw new Exception("[Array] Array does not contain numbers!");
        }
        return Double.parseDouble(this.value(index));
    }

    public float valueFloat(int index) throws Exception {
        if (this.m_type == ArrayType.STRING) {
            throw new Exception("[Array] Array does not contain numbers!");
        }
        return Float.parseFloat(this.value(index));
    }

    public int valueInt(int index) throws Exception {
        if (this.m_type != ArrayType.INT && this.m_type != ArrayType.INT_SPARSE) {
            throw new Exception("[Array] Array does not contain integers!");
        }
        return Integer.parseInt(this.value(index));
    }

    public String valueSparse(int indexOfIndex) throws Exception {
        return this.actualValue(indexOfIndex);
    }

    public String valueSparseString(int indexOfIndex) throws Exception {
        return this.valueSparse(indexOfIndex);
    }

    public double valueSparseDouble(int indexOfIndex) throws Exception {
        return Double.parseDouble(this.actualValue(indexOfIndex));
    }

    public float valueSparseFloat(int indexOfIndex) throws Exception {
        return Float.parseFloat(this.actualValue(indexOfIndex));
    }

    public int valueSparseInt(int indexOfIndex) throws Exception {
        return Integer.parseInt(this.actualValue(indexOfIndex));
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append("<");
        for (int i2 = 0; i2 < this.m_values.size(); ++i2) {
            text.append(this.m_values.get(i2));
            if (i2 >= this.m_values.size() - 1) continue;
            text.append(",");
        }
        text.append(">");
        return text.toString();
    }

    public static enum ArrayType {
        NUM("NUM-ARRAY"),
        INT("INT-ARRAY"),
        REAL("REAL-ARRAY"),
        STRING("STRING-ARRAY"),
        REAL_SPARSE("REAL-SparseArray"),
        INT_SPARSE("INT-SparseArray");

        private final String m_stringVal;

        private ArrayType(String name) {
            this.m_stringVal = name;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }
}

